/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.io.protocol.proto.ProtocolDescriptor;
import com.google.io.protocol.proto.RPC_ServiceDescriptor;
import java.util.Set;
import javax.annotation.Nullable;

public class ProtocolDB {
    private static final ProtocolDB EMPTY = new ProtocolDB();

    public static ProtocolDB getEmptyDB() {
        return EMPTY;
    }

    public static ProtocolDB merge(ProtocolDB a, ProtocolDB b) {
        return new MergedProtocolDB(a, b);
    }

    @Nullable
    public ProtocolDescriptor find(String name) {
        return null;
    }

    @Nullable
    public ProtocolDescriptor findByTypeId(int typeId) {
        return null;
    }

    public Set<String> findByFileName(String fileName) {
        return ImmutableSet.of();
    }

    @Nullable
    public RPC_ServiceDescriptor findService(String name) {
        return null;
    }

    @Nullable
    public String findFileNameContainingExtension(String extendeeType, int number) {
        return null;
    }

    public Set<Integer> findAllExtensionNumbers(String extendeeType) {
        return ImmutableSet.of();
    }

    private static class MergedProtocolDB
    extends ProtocolDB {
        private final ProtocolDB a;
        private final ProtocolDB b;

        MergedProtocolDB(ProtocolDB a, ProtocolDB b) {
            Preconditions.checkNotNull((Object)a, (Object)"a");
            Preconditions.checkNotNull((Object)b, (Object)"b");
            this.a = a;
            this.b = b;
        }

        @Override
        public ProtocolDescriptor find(String name) {
            ProtocolDescriptor descriptor = this.a.find(name);
            if (descriptor == null) {
                descriptor = this.b.find(name);
            }
            return descriptor;
        }

        @Override
        public Set<String> findByFileName(String fileName) {
            return Sets.union(this.a.findByFileName(fileName), this.b.findByFileName(fileName));
        }

        @Override
        public RPC_ServiceDescriptor findService(String name) {
            RPC_ServiceDescriptor descriptor = this.a.findService(name);
            if (descriptor == null) {
                descriptor = this.b.findService(name);
            }
            return descriptor;
        }

        @Override
        @Nullable
        public String findFileNameContainingExtension(String extendeeType, int number) {
            String fileName = this.a.findFileNameContainingExtension(extendeeType, number);
            if (fileName == null) {
                fileName = this.b.findFileNameContainingExtension(extendeeType, number);
            }
            return fileName;
        }

        @Override
        public Set<Integer> findAllExtensionNumbers(String extendeeType) {
            return Sets.union(this.a.findAllExtensionNumbers(extendeeType), this.b.findAllExtensionNumbers(extendeeType));
        }
    }
}

