/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline;

import com.google.appengine.api.taskqueue.DeferredTask;
import com.google.appengine.api.taskqueue.DeferredTaskContext;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.RetryOptions;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.tools.pipeline.Job;
import com.google.appengine.tools.pipeline.Job1;
import com.google.appengine.tools.pipeline.JobSetting;
import com.google.appengine.tools.pipeline.NoSuchObjectException;
import com.google.appengine.tools.pipeline.PipelineService;
import com.google.appengine.tools.pipeline.PipelineServiceFactory;
import com.google.appengine.tools.pipeline.Value;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class Jobs {
    private Jobs() {
    }

    public static JobSetting.WaitForSetting[] createWaitForSettingArray(Value<?> ... values) {
        JobSetting.WaitForSetting[] settings = new JobSetting.WaitForSetting[values.length];
        int i = 0;
        for (Value<?> value : values) {
            settings[i++] = Job.waitFor(value);
        }
        return settings;
    }

    public static <T> Value<T> waitForAll(Job<?> caller, Value<T> value, Value<?> ... values) {
        return caller.futureCall(new WaitForAllJob(), value, (JobSetting[])Jobs.createWaitForSettingArray(values));
    }

    public static <T> Value<T> waitForAll(Job<?> caller, T value, Value<?> ... values) {
        return caller.futureCall(new WaitForAllJob(), Job.immediate(value), (JobSetting[])Jobs.createWaitForSettingArray(values));
    }

    public static <T> Value<T> waitForAllAndDelete(Job<?> caller, Value<T> value, Value<?> ... values) {
        return caller.futureCall(new DeletePipelineJob(caller.getPipelineKey().getName()), value, (JobSetting[])Jobs.createWaitForSettingArray(values));
    }

    public static <T> Value<T> waitForAllAndDelete(Job<?> caller, T value, Value<?> ... values) {
        return caller.futureCall(new DeletePipelineJob(caller.getPipelineKey().getName()), Job.immediate(value), (JobSetting[])Jobs.createWaitForSettingArray(values));
    }

    private static class DeletePipelineJob<T>
    extends Job1<T, T> {
        private static final long serialVersionUID = -5440838671291502355L;
        private static final Logger log = Logger.getLogger(DeletePipelineJob.class.getName());
        private final String key;

        DeletePipelineJob(String rootJobKey) {
            this.key = rootJobKey;
        }

        @Override
        public Value<T> run(T value) {
            DeferredTask deleteRecordsTask = new DeferredTask(){
                private static final long serialVersionUID = -7510918963650055768L;

                public void run() {
                    PipelineService service = PipelineServiceFactory.newPipelineService();
                    try {
                        service.deletePipelineRecords(DeletePipelineJob.this.key);
                        String string = String.valueOf(DeletePipelineJob.this.key);
                        log.info(string.length() != 0 ? "Deleted pipeline: ".concat(string) : new String("Deleted pipeline: "));
                    }
                    catch (IllegalStateException e) {
                        int attempts;
                        String string = String.valueOf(DeletePipelineJob.this.key);
                        log.info(string.length() != 0 ? "Failed to delete pipeline: ".concat(string) : new String("Failed to delete pipeline: "));
                        HttpServletRequest request = DeferredTaskContext.getCurrentRequest();
                        if (request != null && (attempts = request.getIntHeader("X-AppEngine-TaskExecutionCount")) <= 5) {
                            int n = attempts;
                            log.info(new StringBuilder(43).append("Request to retry deferred task #").append(n).toString());
                            DeferredTaskContext.markForRetry();
                            return;
                        }
                        try {
                            service.deletePipelineRecords(DeletePipelineJob.this.key, true, false);
                            String string2 = String.valueOf(DeletePipelineJob.this.key);
                            log.info(string2.length() != 0 ? "Force deleted pipeline: ".concat(string2) : new String("Force deleted pipeline: "));
                        }
                        catch (Exception ex) {
                            String string3 = String.valueOf(DeletePipelineJob.this.key);
                            log.log(Level.WARNING, string3.length() != 0 ? "Failed to force delete pipeline: ".concat(string3) : new String("Failed to force delete pipeline: "), ex);
                        }
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        // empty catch block
                    }
                }
            };
            String queueName = (String)Optional.fromNullable((Object)this.getOnQueue()).or((Object)"default");
            Queue queue = QueueFactory.getQueue((String)queueName);
            queue.add(TaskOptions.Builder.withPayload((DeferredTask)deleteRecordsTask).countdownMillis(10000L).retryOptions(RetryOptions.Builder.withMinBackoffSeconds((double)2.0).maxBackoffSeconds(20.0)));
            return DeletePipelineJob.immediate(value);
        }
    }

    private static class WaitForAllJob<T>
    extends Job1<T, T> {
        private static final long serialVersionUID = 3151677893523195265L;

        private WaitForAllJob() {
        }

        @Override
        public Value<T> run(T value) {
            return WaitForAllJob.immediate(value);
        }
    }

    public static class Transform<F, T>
    extends Job1<T, F> {
        private static final long serialVersionUID = 1280795955105207728L;
        private Function<F, T> function;

        public Transform(Function<F, T> function) {
            Preconditions.checkArgument((boolean)(function instanceof Serializable), (Object)"Function not serializable");
            this.function = function;
        }

        @Override
        public Value<T> run(F from) throws Exception {
            return Transform.immediate(this.function.apply(from));
        }
    }
}

