/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.taskqueue.TaskAlreadyExistsException;
import com.google.appengine.tools.pipeline.FutureList;
import com.google.appengine.tools.pipeline.ImmediateValue;
import com.google.appengine.tools.pipeline.Job;
import com.google.appengine.tools.pipeline.Job0;
import com.google.appengine.tools.pipeline.JobSetting;
import com.google.appengine.tools.pipeline.NoSuchObjectException;
import com.google.appengine.tools.pipeline.OrphanedObjectException;
import com.google.appengine.tools.pipeline.Value;
import com.google.appengine.tools.pipeline.impl.FutureValueImpl;
import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.backend.AppEngineBackEnd;
import com.google.appengine.tools.pipeline.impl.backend.PipelineBackEnd;
import com.google.appengine.tools.pipeline.impl.backend.UpdateSpec;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.ExceptionRecord;
import com.google.appengine.tools.pipeline.impl.model.JobInstanceRecord;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import com.google.appengine.tools.pipeline.impl.model.PipelineObjects;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import com.google.appengine.tools.pipeline.impl.model.SlotDescriptor;
import com.google.appengine.tools.pipeline.impl.servlets.PipelineServlet;
import com.google.appengine.tools.pipeline.impl.tasks.CancelJobTask;
import com.google.appengine.tools.pipeline.impl.tasks.DelayedSlotFillTask;
import com.google.appengine.tools.pipeline.impl.tasks.DeletePipelineTask;
import com.google.appengine.tools.pipeline.impl.tasks.FanoutTask;
import com.google.appengine.tools.pipeline.impl.tasks.FinalizeJobTask;
import com.google.appengine.tools.pipeline.impl.tasks.HandleChildExceptionTask;
import com.google.appengine.tools.pipeline.impl.tasks.HandleSlotFilledTask;
import com.google.appengine.tools.pipeline.impl.tasks.ObjRefTask;
import com.google.appengine.tools.pipeline.impl.tasks.RunJobTask;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import com.google.appengine.tools.pipeline.impl.util.GUIDGenerator;
import com.google.appengine.tools.pipeline.impl.util.StringUtils;
import com.google.appengine.tools.pipeline.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PipelineManager {
    private static final Logger logger = Logger.getLogger(PipelineManager.class.getName());
    private static PipelineBackEnd backEnd = new AppEngineBackEnd();

    public static String startNewPipeline(JobSetting[] settings, Job<?> jobInstance, Object ... params) {
        UpdateSpec updateSpec = new UpdateSpec(null);
        RootJobInstance rootJobInstance = jobInstance;
        if (JobRecord.isExceptionHandlerSpecified(jobInstance)) {
            rootJobInstance = new RootJobInstance(jobInstance, settings, params);
            params = new Object[]{};
        }
        JobRecord jobRecord = PipelineManager.registerNewJobRecord(updateSpec, settings, null, null, rootJobInstance, params);
        updateSpec.setRootJobKey(jobRecord.getRootJobKey());
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
        return jobRecord.getKey().getName();
    }

    public static JobRecord registerNewJobRecord(UpdateSpec updateSpec, JobSetting[] settings, JobRecord generatorJob, String graphGUID, Job<?> jobInstance, Object[] params) {
        JobRecord jobRecord;
        if (generatorJob == null) {
            if (graphGUID != null) {
                throw new IllegalArgumentException("graphGUID must be null for root jobs");
            }
            jobRecord = JobRecord.createRootJobRecord(jobInstance, settings);
        } else {
            jobRecord = new JobRecord(generatorJob, graphGUID, jobInstance, false, settings);
        }
        return PipelineManager.registerNewJobRecord(updateSpec, jobRecord, params);
    }

    public static JobRecord registerNewJobRecord(UpdateSpec updateSpec, JobRecord jobRecord, Object[] params) {
        if (logger.isLoggable(Level.FINE)) {
            String string = String.valueOf(String.valueOf(jobRecord));
            logger.fine(new StringBuilder(28 + string.length()).append("registerNewJobRecord job(\"").append(string).append("\")").toString());
        }
        updateSpec.setRootJobKey(jobRecord.getRootJobKey());
        Key generatorKey = jobRecord.getGeneratorJobKey();
        String graphGuid = jobRecord.getGraphGuid();
        for (Object param : params) {
            Value<Object> value = null != param && param instanceof Value ? (Value)param : new ImmediateValue<Object>(param);
            PipelineManager.registerSlotsWithBarrier(updateSpec, value, jobRecord.getRootJobKey(), generatorKey, jobRecord.getQueueSettings(), graphGuid, jobRecord.getRunBarrierInflated());
        }
        if (0 == jobRecord.getRunBarrierInflated().getWaitingOnKeys().size()) {
            Slot slot = new Slot(jobRecord.getRootJobKey(), generatorKey, graphGuid);
            jobRecord.getRunBarrierInflated().addPhantomArgumentSlot(slot);
            PipelineManager.registerSlotFilled(updateSpec, jobRecord.getQueueSettings(), slot, null);
        }
        UpdateSpec.Group updateGroup = updateSpec.getNonTransactionalGroup();
        updateGroup.includeBarrier(jobRecord.getRunBarrierInflated());
        updateGroup.includeBarrier(jobRecord.getFinalizeBarrierInflated());
        updateGroup.includeSlot(jobRecord.getOutputSlotInflated());
        updateGroup.includeJob(jobRecord);
        updateGroup.includeJobInstanceRecord(jobRecord.getJobInstanceInflated());
        return jobRecord;
    }

    private static void registerSlotsWithBarrier(UpdateSpec updateSpec, Value<?> value, Key rootJobKey, Key generatorJobKey, QueueSettings queueSettings, String graphGUID, Barrier barrier) {
        if (null == value || value instanceof ImmediateValue) {
            Object concreteValue = null;
            if (null != value) {
                ImmediateValue iv = (ImmediateValue)value;
                concreteValue = iv.getValue();
            }
            Slot slot = new Slot(rootJobKey, generatorJobKey, graphGUID);
            PipelineManager.registerSlotFilled(updateSpec, queueSettings, slot, concreteValue);
            barrier.addRegularArgumentSlot(slot);
        } else if (value instanceof FutureValueImpl) {
            FutureValueImpl futureValue = (FutureValueImpl)value;
            Slot slot = futureValue.getSlot();
            barrier.addRegularArgumentSlot(slot);
            updateSpec.getNonTransactionalGroup().includeSlot(slot);
        } else if (value instanceof FutureList) {
            FutureList futureList = (FutureList)value;
            ArrayList<Slot> slotList = new ArrayList<Slot>(futureList.getListOfValues().size());
            Slot dummyListSlot = new Slot(rootJobKey, generatorJobKey, graphGUID);
            PipelineManager.registerSlotFilled(updateSpec, queueSettings, dummyListSlot, null);
            for (Value valFromList : futureList.getListOfValues()) {
                Slot slot = null;
                if (valFromList instanceof ImmediateValue) {
                    ImmediateValue ivFromList = (ImmediateValue)valFromList;
                    slot = new Slot(rootJobKey, generatorJobKey, graphGUID);
                    PipelineManager.registerSlotFilled(updateSpec, queueSettings, slot, ivFromList.getValue());
                } else if (valFromList instanceof FutureValueImpl) {
                    FutureValueImpl futureValFromList = (FutureValueImpl)valFromList;
                    slot = futureValFromList.getSlot();
                } else {
                    if (value instanceof FutureList) {
                        throw new IllegalArgumentException("The Pipeline framework does not currently support FutureLists of FutureLists");
                    }
                    PipelineManager.throwUnrecognizedValueException(valFromList);
                }
                slotList.add(slot);
                updateSpec.getNonTransactionalGroup().includeSlot(slot);
            }
            barrier.addListArgumentSlots(dummyListSlot, slotList);
        } else {
            PipelineManager.throwUnrecognizedValueException(value);
        }
    }

    private static void throwUnrecognizedValueException(Value<?> value) {
        String string = String.valueOf(value.getClass().getName());
        throw new RuntimeException(string.length() != 0 ? "Internal logic error: Unrecognized implementation of Value interface: ".concat(string) : new String("Internal logic error: Unrecognized implementation of Value interface: "));
    }

    private static void registerSlotFilled(UpdateSpec updateSpec, QueueSettings queueSettings, Slot slot, Object value) {
        slot.fill(value);
        updateSpec.getNonTransactionalGroup().includeSlot(slot);
        HandleSlotFilledTask task = new HandleSlotFilledTask(slot.getKey(), queueSettings);
        updateSpec.getFinalTransaction().registerTask(task);
    }

    public static PipelineObjects queryFullPipeline(String rootJobHandle) {
        Key rootJobKey = KeyFactory.createKey((String)"pipeline-job", (String)rootJobHandle);
        return backEnd.queryFullPipeline(rootJobKey);
    }

    public static Pair<? extends Iterable<JobRecord>, String> queryRootPipelines(String classFilter, String cursor, int limit) {
        return backEnd.queryRootPipelines(classFilter, cursor, limit);
    }

    public static Set<String> getRootPipelinesDisplayName() {
        return backEnd.getRootPipelinesDisplayName();
    }

    private static void checkNonEmpty(String s, String name) {
        if (null == s || s.trim().length() == 0) {
            throw new IllegalArgumentException(String.valueOf(name).concat(" is empty."));
        }
    }

    public static JobRecord getJob(String jobHandle) throws NoSuchObjectException {
        PipelineManager.checkNonEmpty(jobHandle, "jobHandle");
        Key key = KeyFactory.createKey((String)"pipeline-job", (String)jobHandle);
        String string = String.valueOf(key.getName());
        logger.finest(string.length() != 0 ? "getJob: ".concat(string) : new String("getJob: "));
        return backEnd.queryJob(key, JobRecord.InflationType.FOR_OUTPUT);
    }

    public static void stopJob(String jobHandle) throws NoSuchObjectException {
        PipelineManager.checkNonEmpty(jobHandle, "jobHandle");
        Key key = KeyFactory.createKey((String)"pipeline-job", (String)jobHandle);
        JobRecord jobRecord = backEnd.queryJob(key, JobRecord.InflationType.NONE);
        jobRecord.setState(JobRecord.State.STOPPED);
        UpdateSpec updateSpec = new UpdateSpec(jobRecord.getRootJobKey());
        updateSpec.getOrCreateTransaction("stopJob").includeJob(jobRecord);
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
    }

    public static void cancelJob(String jobHandle) throws NoSuchObjectException {
        PipelineManager.checkNonEmpty(jobHandle, "jobHandle");
        Key key = KeyFactory.createKey((String)"pipeline-job", (String)jobHandle);
        JobRecord jobRecord = backEnd.queryJob(key, JobRecord.InflationType.NONE);
        CancelJobTask cancelJobTask = new CancelJobTask(key, jobRecord.getQueueSettings());
        try {
            backEnd.enqueue(cancelJobTask);
        }
        catch (TaskAlreadyExistsException e) {
            // empty catch block
        }
    }

    public static void deletePipelineRecords(String pipelineHandle, boolean force, boolean async) throws NoSuchObjectException, IllegalStateException {
        PipelineManager.checkNonEmpty(pipelineHandle, "pipelineHandle");
        Key key = KeyFactory.createKey((String)"pipeline-job", (String)pipelineHandle);
        backEnd.deletePipeline(key, force, async);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void acceptPromisedValue(String promiseHandle, Object value) throws NoSuchObjectException, OrphanedObjectException {
        PipelineManager.checkNonEmpty(promiseHandle, "promiseHandle");
        Key key = KeyFactory.stringToKey((String)promiseHandle);
        PipelineModelObject slot = null;
        int attempts = 0;
        boolean interrupted = false;
        try {
            while (slot == null) {
                ++attempts;
                try {
                    slot = backEnd.querySlot(key, false);
                }
                catch (NoSuchObjectException e) {
                    if (attempts >= 5) {
                        String string;
                        String string2 = String.valueOf(promiseHandle);
                        if (string2.length() != 0) {
                            string = "There is no promise with handle ".concat(string2);
                            throw new NoSuchObjectException(string);
                        }
                        string = new String("There is no promise with handle ");
                        throw new NoSuchObjectException(string);
                    }
                    try {
                        Thread.sleep((long)Math.pow(2.0, attempts - 1) * 1000L);
                    }
                    catch (InterruptedException f) {
                        interrupted = true;
                    }
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        Key generatorJobKey = slot.getGeneratorJobKey();
        if (null == generatorJobKey) {
            String f = String.valueOf(String.valueOf(slot));
            throw new RuntimeException(new StringBuilder(79 + f.length()).append("Pipeline is fatally corrupted. Slot for promised value has no generatorJobKey: ").append(f).toString());
        }
        JobRecord generatorJob = backEnd.queryJob(generatorJobKey, JobRecord.InflationType.NONE);
        if (null == generatorJob) {
            String string = String.valueOf(String.valueOf("Pipeline is fatally corrupted. The generator job for a promised value slot was not found: "));
            String string3 = String.valueOf(String.valueOf(generatorJobKey));
            throw new RuntimeException(new StringBuilder(0 + string.length() + string3.length()).append(string).append(string3).toString());
        }
        String childGraphGuid = generatorJob.getChildGraphGuid();
        if (null == childGraphGuid) {
            throw new NoSuchObjectException("The framework is not ready to accept the promised value yet. Please try again after the job that generated the promis handle has completed.");
        }
        if (!childGraphGuid.equals(slot.getGraphGuid())) {
            throw new OrphanedObjectException(promiseHandle);
        }
        UpdateSpec updateSpec = new UpdateSpec(slot.getRootJobKey());
        PipelineManager.registerSlotFilled(updateSpec, generatorJob.getQueueSettings(), (Slot)slot, value);
        backEnd.save(updateSpec, generatorJob.getQueueSettings());
    }

    public static void processTask(Task task) {
        String string = String.valueOf(String.valueOf(task));
        logger.finest(new StringBuilder(16 + string.length()).append("Processing task ").append(string).toString());
        try {
            switch (task.getType()) {
                case RUN_JOB: {
                    PipelineManager.runJob((RunJobTask)task);
                    break;
                }
                case HANDLE_SLOT_FILLED: {
                    PipelineManager.handleSlotFilled((HandleSlotFilledTask)task);
                    break;
                }
                case FINALIZE_JOB: {
                    PipelineManager.finalizeJob((FinalizeJobTask)task);
                    break;
                }
                case FAN_OUT: {
                    PipelineManager.handleFanoutTaskOrAbandonTask((FanoutTask)task);
                    break;
                }
                case CANCEL_JOB: {
                    PipelineManager.cancelJob((CancelJobTask)task);
                    break;
                }
                case DELETE_PIPELINE: {
                    DeletePipelineTask deletePipelineTask = (DeletePipelineTask)task;
                    try {
                        backEnd.deletePipeline(deletePipelineTask.getRootJobKey(), deletePipelineTask.shouldForce(), false);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "DeletePipeline operation failed.", e);
                    }
                    break;
                }
                case HANDLE_CHILD_EXCEPTION: {
                    PipelineManager.handleChildException((HandleChildExceptionTask)task);
                    break;
                }
                case DELAYED_SLOT_FILL: {
                    PipelineManager.handleDelayedSlotFill((DelayedSlotFillTask)task);
                    break;
                }
                default: {
                    String string2 = String.valueOf(String.valueOf((Object)task.getType()));
                    throw new IllegalArgumentException(new StringBuilder(24 + string2.length()).append("Unrecognized task type: ").append(string2).toString());
                }
            }
        }
        catch (AbandonTaskException abandonTaskException) {
            // empty catch block
        }
    }

    public static PipelineBackEnd getBackEnd() {
        return backEnd;
    }

    private static void invokePrivateJobMethod(String methodName, Job<?> job, Object ... params) {
        Class[] signature = new Class[params.length];
        int i = 0;
        for (Object param : params) {
            signature[i++] = param.getClass();
        }
        PipelineManager.invokePrivateJobMethod(methodName, job, signature, params);
    }

    private static void invokePrivateJobMethod(String methodName, Job<?> job, Class<?>[] signature, Object ... params) {
        try {
            Method method = Job.class.getDeclaredMethod(methodName, signature);
            method.setAccessible(true);
            method.invoke(job, params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method findJobMethodToInvoke(Class<?> klass, boolean callErrorHandler, Object[] params) {
        Method runMethod = null;
        if (callErrorHandler) {
            if (params.length != 1) {
                int n = params.length;
                throw new RuntimeException(new StringBuilder(66).append("Invalid number of parameters passed to handleException:").append(n).toString());
            }
            Object parameter = params[0];
            if (parameter == null) {
                int n = params.length;
                throw new RuntimeException(new StringBuilder(53).append("Null parameters passed to handleException:").append(n).toString());
            }
            Class<?> parameterClass = parameter.getClass();
            if (!Throwable.class.isAssignableFrom(parameterClass)) {
                String string = String.valueOf(parameterClass.getName());
                throw new RuntimeException(string.length() != 0 ? "Parameter that is not an exception passed to handleException:".concat(string) : new String("Parameter that is not an exception passed to handleException:"));
            }
            Class<?> exceptionClass = parameterClass;
            while (true) {
                try {
                    runMethod = klass.getMethod("handleException", exceptionClass);
                }
                catch (NoSuchMethodException e) {
                    if ((exceptionClass = exceptionClass.getSuperclass()) != null) continue;
                }
                break;
            }
        }
        for (Method method : klass.getMethods()) {
            if (!"run".equals(method.getName())) continue;
            runMethod = method;
            break;
        }
        return runMethod;
    }

    private static void setJobRecord(Job<?> job, JobRecord jobRecord) {
        PipelineManager.invokePrivateJobMethod("setJobRecord", job, jobRecord);
    }

    private static void setCurrentRunGuid(Job<?> job, String guid) {
        PipelineManager.invokePrivateJobMethod("setCurrentRunGuid", job, guid);
    }

    private static void setUpdateSpec(Job<?> job, UpdateSpec updateSpec) {
        PipelineManager.invokePrivateJobMethod("setUpdateSpec", job, updateSpec);
    }

    private static void runJob(RunJobTask task) {
        CharSequence builder;
        Key jobKey = task.getJobKey();
        JobRecord jobRecord = PipelineManager.queryJobOrAbandonTask(jobKey, JobRecord.InflationType.FOR_RUN);
        jobRecord.getQueueSettings().merge(task.getQueueSettings());
        Key rootJobKey = jobRecord.getRootJobKey();
        String string = String.valueOf(String.valueOf(jobKey.getName()));
        String string2 = String.valueOf(String.valueOf(PipelineServlet.makeViewerUrl(rootJobKey, jobKey)));
        logger.info(new StringBuilder(29 + string.length() + string2.length()).append("Running pipeline job ").append(string).append("; UI at ").append(string2).toString());
        JobRecord rootJobRecord = rootJobKey.equals((Object)jobKey) ? jobRecord : PipelineManager.queryJobOrAbandonTask(rootJobKey, JobRecord.InflationType.NONE);
        if (rootJobRecord.getState() == JobRecord.State.STOPPED) {
            String string3 = String.valueOf(String.valueOf(rootJobRecord));
            logger.warning(new StringBuilder(31 + string3.length()).append("The pipeline has been stopped: ").append(string3).toString());
            throw new AbandonTaskException();
        }
        Barrier runBarrier = jobRecord.getRunBarrierInflated();
        if (null == runBarrier) {
            String string4 = String.valueOf(String.valueOf(jobRecord));
            throw new RuntimeException(new StringBuilder(45 + string4.length()).append("Internal logic error: ").append(string4).append(" has not been inflated.").toString());
        }
        Barrier finalizeBarrier = jobRecord.getFinalizeBarrierInflated();
        if (null == finalizeBarrier) {
            String string5 = String.valueOf(String.valueOf(jobRecord));
            throw new RuntimeException(new StringBuilder(55 + string5.length()).append("Internal logic error: finalize barrier not inflated in ").append(string5).toString());
        }
        runBarrier.setReleased();
        UpdateSpec tempSpec = new UpdateSpec(rootJobKey);
        tempSpec.getOrCreateTransaction("releaseRunBarrier").includeBarrier(runBarrier);
        backEnd.save(tempSpec, jobRecord.getQueueSettings());
        JobRecord.State jobState = jobRecord.getState();
        switch (jobState) {
            case WAITING_TO_RUN: 
            case RETRY: {
                break;
            }
            case WAITING_TO_FINALIZE: {
                String string6 = String.valueOf(String.valueOf(jobRecord));
                logger.info(new StringBuilder(30 + string6.length()).append("This job has already been run ").append(string6).toString());
                return;
            }
            case STOPPED: {
                String string7 = String.valueOf(String.valueOf(jobRecord));
                logger.info(new StringBuilder(25 + string7.length()).append("This job has been stoped ").append(string7).toString());
                return;
            }
            case CANCELED: {
                String string8 = String.valueOf(String.valueOf(jobRecord));
                logger.info(new StringBuilder(35 + string8.length()).append("This job has already been canceled ").append(string8).toString());
                return;
            }
            case FINALIZED: {
                String string9 = String.valueOf(String.valueOf(jobRecord));
                logger.info(new StringBuilder(30 + string9.length()).append("This job has already been run ").append(string9).toString());
                return;
            }
        }
        JobInstanceRecord record = jobRecord.getJobInstanceInflated();
        if (null == record) {
            String string10 = String.valueOf(String.valueOf(jobRecord));
            throw new RuntimeException(new StringBuilder(56 + string10.length()).append("Internal logic error:").append(string10).append(" does not have jobInstanceInflated.").toString());
        }
        Job<?> job = record.getJobInstanceDeserialized();
        UpdateSpec updateSpec = new UpdateSpec(rootJobKey);
        PipelineManager.setJobRecord(job, jobRecord);
        String currentRunGUID = GUIDGenerator.nextGUID();
        PipelineManager.setCurrentRunGuid(job, currentRunGUID);
        PipelineManager.setUpdateSpec(job, updateSpec);
        Object[] params = runBarrier.buildArgumentArray();
        boolean callExceptionHandler = jobRecord.isCallExceptionHandler();
        Method methodToExecute = PipelineManager.findJobMethodToInvoke(job.getClass(), callExceptionHandler, params);
        if (callExceptionHandler && methodToExecute == null) {
            Throwable exceptionToHandle = (Throwable)params[0];
            PipelineManager.handleExceptionDuringRun(jobRecord, rootJobRecord, currentRunGUID, exceptionToHandle);
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            builder = new StringBuilder(1024);
            String string11 = String.valueOf(String.valueOf(jobRecord));
            ((StringBuilder)builder).append(new StringBuilder(22 + string11.length()).append("Running ").append(string11).append(" with params: ").toString());
            ((StringBuilder)builder).append(StringUtils.toString(params));
            logger.finest(((StringBuilder)builder).toString());
        }
        jobRecord.incrementAttemptNumber();
        jobRecord.setStartTime(new Date());
        tempSpec = new UpdateSpec(jobRecord.getRootJobKey());
        tempSpec.getNonTransactionalGroup().includeJob(jobRecord);
        if (!backEnd.saveWithJobStateCheck(tempSpec, jobRecord.getQueueSettings(), jobKey, JobRecord.State.WAITING_TO_RUN, JobRecord.State.RETRY)) {
            builder = String.valueOf(String.valueOf(jobRecord));
            logger.info(new StringBuilder(82 + ((String)builder).length()).append("Ignoring runJob request for job ").append((String)builder).append(" which is not in a").append(" WAITING_TO_RUN or a RETRY state").toString());
            return;
        }
        Value returnValue = null;
        Throwable caughtException = null;
        try {
            methodToExecute.setAccessible(true);
            returnValue = (Value)methodToExecute.invoke(job, params);
        }
        catch (InvocationTargetException e) {
            caughtException = e.getCause();
        }
        catch (Throwable e) {
            caughtException = e;
        }
        if (null != caughtException) {
            PipelineManager.handleExceptionDuringRun(jobRecord, rootJobRecord, currentRunGUID, caughtException);
            return;
        }
        String string12 = String.valueOf(String.valueOf(returnValue));
        logger.finest(new StringBuilder(14 + string12.length()).append("Job returned: ").append(string12).toString());
        PipelineManager.registerSlotsWithBarrier(updateSpec, returnValue, rootJobKey, jobRecord.getKey(), jobRecord.getQueueSettings(), currentRunGUID, finalizeBarrier);
        jobRecord.setState(JobRecord.State.WAITING_TO_FINALIZE);
        jobRecord.setChildGraphGuid(currentRunGUID);
        updateSpec.getFinalTransaction().includeJob(jobRecord);
        updateSpec.getFinalTransaction().includeBarrier(finalizeBarrier);
        backEnd.saveWithJobStateCheck(updateSpec, jobRecord.getQueueSettings(), jobKey, JobRecord.State.WAITING_TO_RUN, JobRecord.State.RETRY);
    }

    private static void cancelJob(CancelJobTask cancelJobTask) {
        Key jobKey = cancelJobTask.getJobKey();
        JobRecord jobRecord = PipelineManager.queryJobOrAbandonTask(jobKey, JobRecord.InflationType.FOR_RUN);
        jobRecord.getQueueSettings().merge(cancelJobTask.getQueueSettings());
        Key rootJobKey = jobRecord.getRootJobKey();
        String string = String.valueOf(jobKey.getName());
        logger.info(string.length() != 0 ? "Cancelling pipeline job ".concat(string) : new String("Cancelling pipeline job "));
        JobRecord rootJobRecord = rootJobKey.equals((Object)jobKey) ? jobRecord : PipelineManager.queryJobOrAbandonTask(rootJobKey, JobRecord.InflationType.NONE);
        if (rootJobRecord.getState() == JobRecord.State.STOPPED) {
            String string2 = String.valueOf(String.valueOf(rootJobRecord));
            logger.warning(new StringBuilder(31 + string2.length()).append("The pipeline has been stopped: ").append(string2).toString());
            throw new AbandonTaskException();
        }
        switch (jobRecord.getState()) {
            case WAITING_TO_RUN: 
            case RETRY: 
            case WAITING_TO_FINALIZE: {
                break;
            }
            case STOPPED: {
                String string3 = String.valueOf(String.valueOf(jobRecord));
                logger.info(new StringBuilder(25 + string3.length()).append("This job has been stoped ").append(string3).toString());
                return;
            }
            case CANCELED: {
                String string4 = String.valueOf(String.valueOf(jobRecord));
                logger.info(new StringBuilder(35 + string4.length()).append("This job has already been canceled ").append(string4).toString());
                return;
            }
            case FINALIZED: {
                String string5 = String.valueOf(String.valueOf(jobRecord));
                logger.info(new StringBuilder(30 + string5.length()).append("This job has already been run ").append(string5).toString());
                return;
            }
        }
        if (jobRecord.getChildKeys().size() > 0) {
            PipelineManager.cancelChildren(jobRecord, null);
        }
        if (logger.isLoggable(Level.FINEST)) {
            String string6 = String.valueOf(String.valueOf(jobRecord));
            logger.finest(new StringBuilder(20 + string6.length()).append("Marking ").append(string6).append(" as CANCELED").toString());
        }
        jobRecord.setState(JobRecord.State.CANCELED);
        UpdateSpec updateSpec = new UpdateSpec(jobRecord.getRootJobKey());
        updateSpec.getNonTransactionalGroup().includeJob(jobRecord);
        if (jobRecord.isExceptionHandlerSpecified()) {
            PipelineManager.executeExceptionHandler(updateSpec, jobRecord, new CancellationException(), true);
        }
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
    }

    private static void handleExceptionDuringRun(JobRecord jobRecord, JobRecord rootJobRecord, String currentRunGUID, Throwable caughtException) {
        String string;
        int attemptNumber = jobRecord.getAttemptNumber();
        int maxAttempts = jobRecord.getMaxAttempts();
        if (jobRecord.isCallExceptionHandler()) {
            string = String.valueOf(String.valueOf(jobRecord));
            logger.log(Level.INFO, new StringBuilder(72 + string.length()).append("An exception occurred when attempting to execute exception hander job ").append(string).append(". ").toString(), caughtException);
        } else {
            string = String.valueOf(String.valueOf(jobRecord));
            int n = attemptNumber;
            int n2 = maxAttempts;
            logger.log(Level.INFO, new StringBuilder(98 + string.length()).append("An exception occurred when attempting to run ").append(string).append(". ").append("This was attempt number ").append(n).append(" of ").append(n2).append(".").toString(), caughtException);
        }
        if (jobRecord.isIgnoreException()) {
            return;
        }
        UpdateSpec updateSpec = new UpdateSpec(jobRecord.getRootJobKey());
        ExceptionRecord exceptionRecord = new ExceptionRecord(jobRecord.getRootJobKey(), jobRecord.getKey(), currentRunGUID, caughtException);
        updateSpec.getNonTransactionalGroup().includeException(exceptionRecord);
        Key exceptionKey = exceptionRecord.getKey();
        jobRecord.setExceptionKey(exceptionKey);
        if (jobRecord.isCallExceptionHandler() || attemptNumber >= maxAttempts) {
            jobRecord.setState(JobRecord.State.STOPPED);
            updateSpec.getNonTransactionalGroup().includeJob(jobRecord);
            if (jobRecord.isExceptionHandlerSpecified()) {
                PipelineManager.cancelChildren(jobRecord, null);
                PipelineManager.executeExceptionHandler(updateSpec, jobRecord, caughtException, false);
            } else if (null != jobRecord.getExceptionHandlingAncestorKey()) {
                PipelineManager.cancelChildren(jobRecord, null);
                HandleChildExceptionTask handleChildExceptionTask = new HandleChildExceptionTask(jobRecord.getExceptionHandlingAncestorKey(), jobRecord.getKey(), jobRecord.getQueueSettings());
                updateSpec.getFinalTransaction().registerTask(handleChildExceptionTask);
            } else {
                rootJobRecord.setState(JobRecord.State.STOPPED);
                rootJobRecord.setExceptionKey(exceptionKey);
                updateSpec.getNonTransactionalGroup().includeJob(rootJobRecord);
            }
            backEnd.save(updateSpec, jobRecord.getQueueSettings());
        } else {
            jobRecord.setState(JobRecord.State.RETRY);
            int backoffFactor = jobRecord.getBackoffFactor();
            int backoffSeconds = jobRecord.getBackoffSeconds();
            RunJobTask task = new RunJobTask(jobRecord.getKey(), attemptNumber, jobRecord.getQueueSettings());
            task.getQueueSettings().setDelayInSeconds((long)backoffSeconds * (long)Math.pow(backoffFactor, attemptNumber));
            updateSpec.getFinalTransaction().includeJob(jobRecord);
            updateSpec.getFinalTransaction().registerTask(task);
            backEnd.saveWithJobStateCheck(updateSpec, jobRecord.getQueueSettings(), jobRecord.getKey(), JobRecord.State.WAITING_TO_RUN, JobRecord.State.RETRY);
        }
    }

    private static void executeExceptionHandler(UpdateSpec updateSpec, JobRecord jobRecord, Throwable caughtException, boolean ignoreException) {
        updateSpec.getNonTransactionalGroup().includeJob(jobRecord);
        String errorHandlingGraphGuid = GUIDGenerator.nextGUID();
        Job<?> jobInstance = jobRecord.getJobInstanceInflated().getJobInstanceDeserialized();
        JobRecord errorHandlingJobRecord = new JobRecord(jobRecord, errorHandlingGraphGuid, jobInstance, true, new JobSetting[0]);
        errorHandlingJobRecord.setOutputSlotInflated(jobRecord.getOutputSlotInflated());
        errorHandlingJobRecord.setIgnoreException(ignoreException);
        PipelineManager.registerNewJobRecord(updateSpec, errorHandlingJobRecord, new Object[]{new ImmediateValue<Throwable>(caughtException)});
    }

    private static void cancelChildren(JobRecord jobRecord, Key failedChildKey) {
        for (Key childKey : jobRecord.getChildKeys()) {
            if (childKey.equals((Object)failedChildKey)) continue;
            CancelJobTask cancelJobTask = new CancelJobTask(childKey, jobRecord.getQueueSettings());
            try {
                backEnd.enqueue(cancelJobTask);
            }
            catch (TaskAlreadyExistsException e) {}
        }
    }

    private static void handleChildException(HandleChildExceptionTask handleChildExceptionTask) {
        Key jobKey = handleChildExceptionTask.getKey();
        Key failedChildKey = handleChildExceptionTask.getFailedChildKey();
        JobRecord jobRecord = PipelineManager.queryJobOrAbandonTask(jobKey, JobRecord.InflationType.FOR_RUN);
        jobRecord.getQueueSettings().merge(handleChildExceptionTask.getQueueSettings());
        Key rootJobKey = jobRecord.getRootJobKey();
        String string = String.valueOf(String.valueOf(jobKey.getName()));
        String string2 = String.valueOf(String.valueOf(PipelineServlet.makeViewerUrl(rootJobKey, jobKey)));
        logger.info(new StringBuilder(47 + string.length() + string2.length()).append("Running pipeline job ").append(string).append(" exception handler; UI at ").append(string2).toString());
        JobRecord rootJobRecord = rootJobKey.equals((Object)jobKey) ? jobRecord : PipelineManager.queryJobOrAbandonTask(rootJobKey, JobRecord.InflationType.NONE);
        if (rootJobRecord.getState() == JobRecord.State.STOPPED) {
            String string3 = String.valueOf(String.valueOf(rootJobRecord));
            logger.warning(new StringBuilder(31 + string3.length()).append("The pipeline has been stopped: ").append(string3).toString());
            throw new AbandonTaskException();
        }
        JobRecord failedJobRecord = PipelineManager.queryJobOrAbandonTask(failedChildKey, JobRecord.InflationType.FOR_OUTPUT);
        UpdateSpec updateSpec = new UpdateSpec(rootJobKey);
        PipelineManager.cancelChildren(jobRecord, failedChildKey);
        PipelineManager.executeExceptionHandler(updateSpec, jobRecord, failedJobRecord.getException(), false);
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
    }

    private static void finalizeJob(FinalizeJobTask finalizeJobTask) {
        Key jobKey = finalizeJobTask.getJobKey();
        JobRecord jobRecord = PipelineManager.queryJobOrAbandonTask(jobKey, JobRecord.InflationType.FOR_FINALIZE);
        jobRecord.getQueueSettings().merge(finalizeJobTask.getQueueSettings());
        switch (jobRecord.getState()) {
            case WAITING_TO_FINALIZE: {
                break;
            }
            case WAITING_TO_RUN: 
            case RETRY: {
                String string = String.valueOf(String.valueOf(jobRecord));
                throw new RuntimeException(new StringBuilder(18 + string.length()).append(string).append(" is in RETRY state").toString());
            }
            case STOPPED: {
                String string = String.valueOf(String.valueOf(jobRecord));
                logger.info(new StringBuilder(25 + string.length()).append("This job has been stoped ").append(string).toString());
                return;
            }
            case CANCELED: {
                String string = String.valueOf(String.valueOf(jobRecord));
                logger.info(new StringBuilder(35 + string.length()).append("This job has already been canceled ").append(string).toString());
                return;
            }
            case FINALIZED: {
                String string = String.valueOf(String.valueOf(jobRecord));
                logger.info(new StringBuilder(30 + string.length()).append("This job has already been run ").append(string).toString());
                return;
            }
        }
        Barrier finalizeBarrier = jobRecord.getFinalizeBarrierInflated();
        if (null == finalizeBarrier) {
            String string = String.valueOf(String.valueOf(jobRecord));
            throw new RuntimeException(new StringBuilder(22 + string.length()).append(string).append(" has not been inflated").toString());
        }
        Slot outputSlot = jobRecord.getOutputSlotInflated();
        if (null == outputSlot) {
            String string = String.valueOf(String.valueOf(jobRecord));
            throw new RuntimeException(new StringBuilder(23 + string.length()).append(string).append(" has not been inflated.").toString());
        }
        finalizeBarrier.setReleased();
        UpdateSpec updateSpec = new UpdateSpec(jobRecord.getRootJobKey());
        updateSpec.getOrCreateTransaction("releaseFinalizeBarrier").includeBarrier(finalizeBarrier);
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
        updateSpec = new UpdateSpec(jobRecord.getRootJobKey());
        List<Object> finalizeArguments = finalizeBarrier.buildArgumentList();
        int numFinalizeArguments = finalizeArguments.size();
        if (1 != numFinalizeArguments) {
            int n = numFinalizeArguments;
            throw new RuntimeException(new StringBuilder(54).append("Internal logic error: numFinalizeArguments=").append(n).toString());
        }
        Object finalizeValue = finalizeArguments.get(0);
        String string = String.valueOf(String.valueOf(jobRecord));
        String string2 = String.valueOf(String.valueOf(finalizeValue));
        logger.finest(new StringBuilder(23 + string.length() + string2.length()).append("Finalizing ").append(string).append(" with value=").append(string2).toString());
        outputSlot.fill(finalizeValue);
        jobRecord.setState(JobRecord.State.FINALIZED);
        jobRecord.setEndTime(new Date());
        Key fillerJobKey = PipelineManager.getFinalizeSlotFiller(finalizeBarrier);
        if (null == fillerJobKey) {
            fillerJobKey = jobKey;
        }
        outputSlot.setSourceJobKey(fillerJobKey);
        updateSpec.getNonTransactionalGroup().includeJob(jobRecord);
        updateSpec.getNonTransactionalGroup().includeSlot(outputSlot);
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
        HandleSlotFilledTask task = new HandleSlotFilledTask(outputSlot.getKey(), jobRecord.getQueueSettings());
        backEnd.enqueue(task);
    }

    private static Key getFinalizeSlotFiller(Barrier finalizeBarrier) {
        Key fillerJobKey = null;
        for (SlotDescriptor slotDescriptor : finalizeBarrier.getWaitingOnInflated()) {
            Key key = slotDescriptor.slot.getSourceJobKey();
            if (null == key) continue;
            if (null == fillerJobKey) {
                fillerJobKey = key;
                continue;
            }
            if (fillerJobKey.toString().equals(key.toString())) continue;
            return null;
        }
        return fillerJobKey;
    }

    private static void handleSlotFilled(HandleSlotFilledTask hsfTask) {
        Key slotKey = hsfTask.getSlotKey();
        Slot slot = PipelineManager.querySlotOrAbandonTask(slotKey, true);
        List<Barrier> waitingList = slot.getWaitingOnMeInflated();
        if (null == waitingList) {
            String string = String.valueOf(String.valueOf(slot));
            throw new RuntimeException(new StringBuilder(38 + string.length()).append("Internal logic error: ").append(string).append(" is not inflated").toString());
        }
        for (Barrier barrier : waitingList) {
            ObjRefTask task;
            String string = String.valueOf(String.valueOf(barrier));
            logger.finest(new StringBuilder(9 + string.length()).append("Checking ").append(string).toString());
            if (barrier.isReleased()) continue;
            boolean shouldBeReleased = true;
            if (null == barrier.getWaitingOnInflated()) {
                String string2 = String.valueOf(String.valueOf(barrier));
                throw new RuntimeException(new StringBuilder(39 + string2.length()).append("Internal logic error: ").append(string2).append(" is not inflated.").toString());
            }
            for (SlotDescriptor sd : barrier.getWaitingOnInflated()) {
                if (sd.slot.isFilled()) continue;
                String string3 = String.valueOf(String.valueOf(sd.slot));
                logger.finest(new StringBuilder(12 + string3.length()).append("Not filled: ").append(string3).toString());
                shouldBeReleased = false;
                break;
            }
            if (!shouldBeReleased) continue;
            Key jobKey = barrier.getJobKey();
            JobRecord jobRecord = PipelineManager.queryJobOrAbandonTask(jobKey, JobRecord.InflationType.NONE);
            jobRecord.getQueueSettings().merge(hsfTask.getQueueSettings());
            switch (barrier.getType()) {
                case RUN: {
                    task = new RunJobTask(jobKey, jobRecord.getQueueSettings());
                    break;
                }
                case FINALIZE: {
                    task = new FinalizeJobTask(jobKey, jobRecord.getQueueSettings());
                    break;
                }
                default: {
                    String string4 = String.valueOf(String.valueOf((Object)barrier.getType()));
                    throw new RuntimeException(new StringBuilder(21 + string4.length()).append("Unknown barrier type ").append(string4).toString());
                }
            }
            try {
                backEnd.enqueue(task);
            }
            catch (TaskAlreadyExistsException e) {}
        }
    }

    private static void handleDelayedSlotFill(DelayedSlotFillTask task) {
        Key slotKey = task.getSlotKey();
        Slot slot = PipelineManager.querySlotOrAbandonTask(slotKey, true);
        Key rootJobKey = task.getRootJobKey();
        UpdateSpec updateSpec = new UpdateSpec(rootJobKey);
        slot.fill(null);
        updateSpec.getNonTransactionalGroup().includeSlot(slot);
        backEnd.save(updateSpec, task.getQueueSettings());
        PipelineManager.handleSlotFilled(new HandleSlotFilledTask(slotKey, task.getQueueSettings()));
    }

    private static JobRecord queryJobOrAbandonTask(Key key, JobRecord.InflationType inflationType) {
        try {
            return backEnd.queryJob(key, inflationType);
        }
        catch (NoSuchObjectException e) {
            String string = String.valueOf(String.valueOf(key));
            logger.log(Level.WARNING, new StringBuilder(54 + string.length()).append("Cannot find some part of the job: ").append(string).append(". Ignoring the task.").toString(), e);
            throw new AbandonTaskException();
        }
    }

    private static Slot querySlotOrAbandonTask(Key key, boolean inflate) {
        try {
            return backEnd.querySlot(key, inflate);
        }
        catch (NoSuchObjectException e) {
            String string = String.valueOf(String.valueOf(key));
            logger.log(Level.WARNING, new StringBuilder(42 + string.length()).append("Cannot find the slot: ").append(string).append(". Ignoring the task.").toString(), e);
            throw new AbandonTaskException();
        }
    }

    private static void handleFanoutTaskOrAbandonTask(FanoutTask fanoutTask) {
        try {
            backEnd.handleFanoutTask(fanoutTask);
        }
        catch (NoSuchObjectException e) {
            logger.log(Level.SEVERE, "Pipeline is fatally corrupted. Fanout task record not found", e);
            throw new AbandonTaskException();
        }
    }

    public static void registerDelayedValue(UpdateSpec spec, JobRecord generatorJobRecord, long delaySec, Slot slot) {
        Key rootKey = generatorJobRecord.getRootJobKey();
        QueueSettings queueSettings = generatorJobRecord.getQueueSettings();
        DelayedSlotFillTask task = new DelayedSlotFillTask(slot, delaySec, rootKey, queueSettings);
        spec.getFinalTransaction().registerTask(task);
    }

    private static class AbandonTaskException
    extends RuntimeException {
        private static final long serialVersionUID = 358437646006972459L;

        private AbandonTaskException() {
        }
    }

    private static final class RootJobInstance
    extends Job0<Object> {
        private static final long serialVersionUID = -2162670129577469245L;
        private final Job<?> jobInstance;
        private final JobSetting[] settings;
        private final Object[] params;

        public RootJobInstance(Job<?> jobInstance, JobSetting[] settings, Object[] params) {
            this.jobInstance = jobInstance;
            this.settings = settings;
            this.params = params;
        }

        @Override
        public Value<Object> run() throws Exception {
            return this.futureCallUnchecked(this.settings, this.jobInstance, this.params);
        }

        @Override
        public String getJobDisplayName() {
            return this.jobInstance.getJobDisplayName();
        }
    }
}

