/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl;

public final class QueueSettings
implements Cloneable {
    private String onBackend;
    private String onModule;
    private String moduleVersion;
    private String onQueue;
    private Long delay;

    public QueueSettings merge(QueueSettings other) {
        if (this.onBackend == null && this.onModule == null) {
            this.onBackend = other.getOnBackend();
        }
        if (this.onModule == null && this.onBackend == null) {
            this.onModule = other.getOnModule();
            this.moduleVersion = other.getModuleVersion();
        }
        if (this.onQueue == null) {
            this.onQueue = other.getOnQueue();
        }
        return this;
    }

    public QueueSettings setOnBackend(String onBackend) {
        if (onBackend != null && this.onModule != null) {
            throw new IllegalStateException("OnModule and OnBackend cannot be combined");
        }
        this.onBackend = onBackend;
        return this;
    }

    public String getOnBackend() {
        return this.onBackend;
    }

    public QueueSettings setOnModule(String onModule) {
        if (onModule != null && this.onBackend != null) {
            throw new IllegalStateException("OnModule and OnBackend cannot be combined");
        }
        this.onModule = onModule;
        return this;
    }

    public String getOnModule() {
        return this.onModule;
    }

    public QueueSettings setModuleVersion(String moduleVersion) {
        this.moduleVersion = moduleVersion;
        return this;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public QueueSettings setOnQueue(String onQueue) {
        this.onQueue = onQueue;
        return this;
    }

    public String getOnQueue() {
        return this.onQueue;
    }

    public void setDelayInSeconds(Long delay) {
        this.delay = delay;
    }

    public Long getDelayInSeconds() {
        return this.delay;
    }

    public QueueSettings clone() {
        try {
            return (QueueSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.onBackend));
        String string2 = String.valueOf(String.valueOf(this.onModule));
        String string3 = String.valueOf(String.valueOf(this.moduleVersion));
        String string4 = String.valueOf(String.valueOf(this.onQueue));
        String string5 = String.valueOf(String.valueOf(this.delay));
        return new StringBuilder(79 + string.length() + string2.length() + string3.length() + string4.length() + string5.length()).append("QueueSettings[onBackEnd=").append(string).append(", onModule=").append(string2).append(", moduleVersion=").append(string3).append(", onQueue=").append(string4).append(", delayInSeconds=").append(string5).append("]").toString();
    }
}

