/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.backend;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.PropertyProjection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.tools.cloudstorage.ExceptionHandler;
import com.google.appengine.tools.cloudstorage.NonRetriableException;
import com.google.appengine.tools.cloudstorage.RetriesExhaustedException;
import com.google.appengine.tools.cloudstorage.RetryHelper;
import com.google.appengine.tools.cloudstorage.RetryParams;
import com.google.appengine.tools.pipeline.NoSuchObjectException;
import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.backend.AppEngineTaskQueue;
import com.google.appengine.tools.pipeline.impl.backend.PipelineBackEnd;
import com.google.appengine.tools.pipeline.impl.backend.UpdateSpec;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.ExceptionRecord;
import com.google.appengine.tools.pipeline.impl.model.FanoutTaskRecord;
import com.google.appengine.tools.pipeline.impl.model.JobInstanceRecord;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import com.google.appengine.tools.pipeline.impl.model.PipelineObjects;
import com.google.appengine.tools.pipeline.impl.model.ShardedValue;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import com.google.appengine.tools.pipeline.impl.tasks.DeletePipelineTask;
import com.google.appengine.tools.pipeline.impl.tasks.FanoutTask;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import com.google.appengine.tools.pipeline.impl.util.SerializationUtils;
import com.google.appengine.tools.pipeline.impl.util.TestUtils;
import com.google.appengine.tools.pipeline.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class AppEngineBackEnd
implements PipelineBackEnd {
    private static final RetryParams RETRY_PARAMS = new RetryParams.Builder().retryDelayBackoffFactor(2.0).initialRetryDelayMillis(300L).maxRetryDelayMillis(5000L).retryMinAttempts(5).retryMaxAttempts(5).build();
    private static final ExceptionHandler EXCEPTION_HANDLER = new ExceptionHandler.Builder().retryOn(new Class[]{ConcurrentModificationException.class, DatastoreTimeoutException.class, DatastoreFailureException.class}).abortOn(new Class[]{EntityNotFoundException.class, NoSuchObjectException.class}).build();
    private static final Logger logger = Logger.getLogger(AppEngineBackEnd.class.getName());
    private static final int MAX_BLOB_BYTE_SIZE = 1000000;
    private final DatastoreService dataStore = DatastoreServiceFactory.getDatastoreService();
    private final AppEngineTaskQueue taskQueue = new AppEngineTaskQueue();

    private void putAll(Collection<? extends PipelineModelObject> objects) {
        if (objects.isEmpty()) {
            return;
        }
        ArrayList<Entity> entityList = new ArrayList<Entity>(objects.size());
        for (PipelineModelObject pipelineModelObject : objects) {
            String string = String.valueOf(String.valueOf(pipelineModelObject));
            logger.finest(new StringBuilder(9 + string.length()).append("Storing: ").append(string).toString());
            entityList.add(pipelineModelObject.toEntity());
        }
        this.dataStore.put(entityList);
    }

    private void saveAll(UpdateSpec.Group group) {
        this.putAll(group.getBarriers());
        this.putAll(group.getJobs());
        this.putAll(group.getSlots());
        this.putAll(group.getJobInstanceRecords());
        this.putAll(group.getFailureRecords());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transactionallySaveAll(UpdateSpec.Transaction transactionSpec, QueueSettings queueSettings, Key rootJobKey, Key jobKey, JobRecord.State ... expectedStates) {
        Transaction transaction = this.dataStore.beginTransaction();
        try {
            UpdateSpec.TransactionWithTasks transactionWithTasks;
            Collection<Task> tasks;
            if (jobKey != null && expectedStates != null) {
                Entity entity = null;
                try {
                    entity = this.dataStore.get(jobKey);
                }
                catch (EntityNotFoundException e) {
                    String string = String.valueOf(String.valueOf(jobKey));
                    throw new RuntimeException(new StringBuilder(63 + string.length()).append("Fatal Pipeline corruption error. No JobRecord found with key = ").append(string).toString());
                }
                JobRecord jobRecord = new JobRecord(entity);
                JobRecord.State state = jobRecord.getState();
                boolean stateIsExpected = false;
                for (JobRecord.State expectedState : expectedStates) {
                    if (state != expectedState) continue;
                    stateIsExpected = true;
                    break;
                }
                if (!stateIsExpected) {
                    String arr$ = String.valueOf(String.valueOf(jobRecord));
                    String string = String.valueOf(String.valueOf(Arrays.asList(expectedStates)));
                    logger.info(new StringBuilder(94 + arr$.length() + string.length()).append("Job ").append(arr$).append(" is not in one of the expected states: ").append(string).append(" and so transactionallySaveAll() will not continue.").toString());
                    boolean bl = false;
                    return bl;
                }
            }
            this.saveAll(transactionSpec);
            if (transactionSpec instanceof UpdateSpec.TransactionWithTasks && (tasks = (transactionWithTasks = (UpdateSpec.TransactionWithTasks)transactionSpec).getTasks()).size() > 0) {
                byte[] encodedTasks = FanoutTask.encodeTasks(tasks);
                FanoutTaskRecord ftRecord = new FanoutTaskRecord(rootJobKey, encodedTasks);
                this.dataStore.put(null, ftRecord.toEntity());
                FanoutTask fannoutTask = new FanoutTask(ftRecord.getKey(), queueSettings);
                this.taskQueue.enqueue(fannoutTask);
            }
            transaction.commit();
        }
        finally {
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        return true;
    }

    private <R> R tryFiveTimes(Operation<R> operation) {
        try {
            return (R)RetryHelper.runWithRetries(operation, (RetryParams)RETRY_PARAMS, (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (NonRetriableException | RetriesExhaustedException e) {
            if (e.getCause() instanceof RuntimeException) {
                String string = String.valueOf(String.valueOf(e.getCause().getMessage()));
                String string2 = String.valueOf(String.valueOf(operation.getName()));
                logger.info(new StringBuilder(42 + string.length() + string2.length()).append(string).append(" during ").append(string2).append(" throwing after multiple attempts ").toString());
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void enqueue(Task task) {
        this.taskQueue.enqueue(task);
    }

    @Override
    public boolean saveWithJobStateCheck(final UpdateSpec updateSpec, final QueueSettings queueSettings, final Key jobKey, final JobRecord.State ... expectedStates) {
        this.tryFiveTimes(new Operation<Void>("save"){

            @Override
            public Void call() {
                AppEngineBackEnd.this.saveAll(updateSpec.getNonTransactionalGroup());
                return null;
            }
        });
        for (final UpdateSpec.Transaction transactionSpec : updateSpec.getTransactions()) {
            this.tryFiveTimes(new Operation<Void>("save"){

                @Override
                public Void call() {
                    AppEngineBackEnd.this.transactionallySaveAll(transactionSpec, queueSettings, updateSpec.getRootJobKey(), null, new JobRecord.State[0]);
                    return null;
                }
            });
        }
        TestUtils.throwHereForTesting("AppEngineBackeEnd.saveWithJobStateCheck.beforeFinalTransaction");
        final AtomicBoolean wasSaved = new AtomicBoolean(true);
        this.tryFiveTimes(new Operation<Void>("save"){

            @Override
            public Void call() {
                wasSaved.set(AppEngineBackEnd.this.transactionallySaveAll(updateSpec.getFinalTransaction(), queueSettings, updateSpec.getRootJobKey(), jobKey, expectedStates));
                return null;
            }
        });
        return wasSaved.get();
    }

    @Override
    public void save(UpdateSpec updateSpec, QueueSettings queueSettings) {
        this.saveWithJobStateCheck(updateSpec, queueSettings, null, new JobRecord.State[0]);
    }

    @Override
    public JobRecord queryJob(Key jobKey, JobRecord.InflationType inflationType) throws NoSuchObjectException {
        Entity entity = this.getEntity("queryJob", jobKey);
        JobRecord jobRecord = new JobRecord(entity);
        Barrier runBarrier = null;
        Barrier finalizeBarrier = null;
        Slot outputSlot = null;
        JobInstanceRecord jobInstanceRecord = null;
        ExceptionRecord failureRecord = null;
        switch (inflationType) {
            case FOR_RUN: {
                runBarrier = this.queryBarrier(jobRecord.getRunBarrierKey(), true);
                finalizeBarrier = this.queryBarrier(jobRecord.getFinalizeBarrierKey(), false);
                jobInstanceRecord = new JobInstanceRecord(this.getEntity("queryJob", jobRecord.getJobInstanceKey()));
                outputSlot = this.querySlot(jobRecord.getOutputSlotKey(), false);
                break;
            }
            case FOR_FINALIZE: {
                finalizeBarrier = this.queryBarrier(jobRecord.getFinalizeBarrierKey(), true);
                outputSlot = this.querySlot(jobRecord.getOutputSlotKey(), false);
                break;
            }
            case FOR_OUTPUT: {
                outputSlot = this.querySlot(jobRecord.getOutputSlotKey(), false);
                Key failureKey = jobRecord.getExceptionKey();
                failureRecord = this.queryFailure(failureKey);
                break;
            }
        }
        jobRecord.inflate(runBarrier, finalizeBarrier, outputSlot, jobInstanceRecord, failureRecord);
        String string = String.valueOf(String.valueOf(jobRecord));
        logger.finest(new StringBuilder(16 + string.length()).append("Query returned: ").append(string).toString());
        return jobRecord;
    }

    private Barrier queryBarrier(Key barrierKey, boolean inflate) throws NoSuchObjectException {
        Entity entity = this.getEntity("queryBarrier", barrierKey);
        Barrier barrier = new Barrier(entity);
        if (inflate) {
            ArrayList<Barrier> barriers = new ArrayList<Barrier>(1);
            barriers.add(barrier);
            this.inflateBarriers(barriers);
        }
        String string = String.valueOf(String.valueOf(barrier));
        logger.finest(new StringBuilder(19 + string.length()).append("Querying returned: ").append(string).toString());
        return barrier;
    }

    private void inflateBarriers(Collection<Barrier> barriers) {
        HashSet<Key> keySet = new HashSet<Key>(barriers.size() * 5);
        for (Barrier barrier : barriers) {
            for (Key key : barrier.getWaitingOnKeys()) {
                keySet.add(key);
            }
        }
        Map<Key, Entity> entityMap = this.getEntities("inflateBarriers", keySet);
        HashMap<Key, Slot> slotMap = new HashMap<Key, Slot>(entityMap.size());
        for (Key key : keySet) {
            Slot s = new Slot(entityMap.get(key));
            slotMap.put(key, s);
        }
        for (Barrier barrier : barriers) {
            barrier.inflate(slotMap);
        }
    }

    @Override
    public Slot querySlot(Key slotKey, boolean inflate) throws NoSuchObjectException {
        Entity entity = this.getEntity("querySlot", slotKey);
        Slot slot = new Slot(entity);
        if (inflate) {
            Map<Key, Entity> entities = this.getEntities("querySlot", slot.getWaitingOnMeKeys());
            HashMap<Key, Barrier> barriers = new HashMap<Key, Barrier>(entities.size());
            for (Map.Entry<Key, Entity> entry : entities.entrySet()) {
                barriers.put(entry.getKey(), new Barrier(entry.getValue()));
            }
            slot.inflate(barriers);
            this.inflateBarriers(barriers.values());
        }
        return slot;
    }

    @Override
    public ExceptionRecord queryFailure(Key failureKey) throws NoSuchObjectException {
        if (failureKey == null) {
            return null;
        }
        Entity entity = this.getEntity("ReadExceptionRecord", failureKey);
        return new ExceptionRecord(entity);
    }

    @Override
    public Object serializeValue(PipelineModelObject model, Object value) throws IOException {
        byte[] bytes = SerializationUtils.serialize(value);
        if (bytes.length < 1000000) {
            return new Blob(bytes);
        }
        int shardId = 0;
        int offset = 0;
        final ArrayList<Entity> shardedValues = new ArrayList<Entity>(bytes.length / 1000000 + 1);
        while (offset < bytes.length) {
            int limit = offset + 1000000;
            byte[] chunk = Arrays.copyOfRange(bytes, offset, Math.min(limit, bytes.length));
            offset = limit;
            shardedValues.add(new ShardedValue(model, shardId++, chunk).toEntity());
        }
        return this.tryFiveTimes(new Operation<List<Key>>("serializeValue"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Key> call() {
                List keys;
                Transaction tx = AppEngineBackEnd.this.dataStore.beginTransaction();
                try {
                    keys = AppEngineBackEnd.this.dataStore.put(tx, (Iterable)shardedValues);
                    tx.commit();
                }
                finally {
                    if (tx.isActive()) {
                        tx.rollback();
                    }
                }
                return keys;
            }
        });
    }

    @Override
    public Object deserializeValue(PipelineModelObject model, Object serializedVersion) throws IOException {
        if (serializedVersion instanceof Blob) {
            return SerializationUtils.deserialize(((Blob)serializedVersion).getBytes());
        }
        Collection keys = (Collection)serializedVersion;
        Map<Key, Entity> entities = this.getEntities("deserializeValue", keys);
        ShardedValue[] shardedValues = new ShardedValue[entities.size()];
        int totalSize = 0;
        int index = 0;
        for (Key key : keys) {
            Entity entity = entities.get(key);
            ShardedValue shardedValue = new ShardedValue(entity);
            shardedValues[index++] = shardedValue;
            totalSize += shardedValue.getValue().length;
        }
        byte[] totalBytes = new byte[totalSize];
        int offset = 0;
        for (ShardedValue shardedValue : shardedValues) {
            byte[] shardBytes = shardedValue.getValue();
            System.arraycopy(shardBytes, 0, totalBytes, offset, shardBytes.length);
            offset += shardBytes.length;
        }
        return SerializationUtils.deserialize(totalBytes);
    }

    private Map<Key, Entity> getEntities(String logString, final Collection<Key> keys) {
        Map<Key, Entity> result = this.tryFiveTimes(new Operation<Map<Key, Entity>>(logString){

            @Override
            public Map<Key, Entity> call() {
                return AppEngineBackEnd.this.dataStore.get(null, (Iterable)keys);
            }
        });
        if (keys.size() != result.size()) {
            ArrayList<Key> missing = new ArrayList<Key>(keys);
            missing.removeAll(result.keySet());
            String string = String.valueOf(String.valueOf(missing));
            throw new RuntimeException(new StringBuilder(27 + string.length()).append("Missing entities for keys: ").append(string).toString());
        }
        return result;
    }

    private Entity getEntity(String logString, final Key key) throws NoSuchObjectException {
        try {
            return this.tryFiveTimes(new Operation<Entity>(logString){

                @Override
                public Entity call() throws EntityNotFoundException {
                    return AppEngineBackEnd.this.dataStore.get(null, key);
                }
            });
        }
        catch (NonRetriableException | RetriesExhaustedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EntityNotFoundException) {
                throw new NoSuchObjectException(key.toString(), cause);
            }
            throw e;
        }
    }

    @Override
    public void handleFanoutTask(FanoutTask fanoutTask) throws NoSuchObjectException {
        Key fanoutTaskRecordKey = fanoutTask.getRecordKey();
        Entity entity = this.getEntity("handleFanoutTask", fanoutTaskRecordKey);
        FanoutTaskRecord ftRecord = new FanoutTaskRecord(entity);
        byte[] encodedBytes = ftRecord.getPayload();
        this.taskQueue.enqueue(FanoutTask.decodeTasks(encodedBytes));
    }

    public List<Entity> queryAll(String kind, Key rootJobKey) {
        Query query = new Query(kind);
        query.setFilter((Query.Filter)new Query.FilterPredicate("rootJobKey", Query.FilterOperator.EQUAL, (Object)rootJobKey));
        final PreparedQuery preparedQuery = this.dataStore.prepare(query);
        final FetchOptions options = FetchOptions.Builder.withChunkSize((int)500);
        return this.tryFiveTimes(new Operation<List<Entity>>("queryFullPipeline"){

            @Override
            public List<Entity> call() {
                return preparedQuery.asList(options);
            }
        });
    }

    @Override
    public Pair<? extends Iterable<JobRecord>, String> queryRootPipelines(String classFilter, String cursor, final int limit) {
        Query query = new Query("pipeline-job");
        Query.FilterPredicate filter = classFilter == null || classFilter.isEmpty() ? new Query.FilterPredicate("rootJobDisplayName", Query.FilterOperator.GREATER_THAN, null) : new Query.FilterPredicate("rootJobDisplayName", Query.FilterOperator.EQUAL, (Object)classFilter);
        query.setFilter((Query.Filter)filter);
        final PreparedQuery preparedQuery = this.dataStore.prepare(query);
        final FetchOptions fetchOptions = FetchOptions.Builder.withDefaults();
        if (limit > 0) {
            fetchOptions.limit(limit + 1);
        }
        if (cursor != null) {
            fetchOptions.startCursor(Cursor.fromWebSafeString((String)cursor));
        }
        return this.tryFiveTimes(new Operation<Pair<? extends Iterable<JobRecord>, String>>("queryRootPipelines"){

            @Override
            public Pair<? extends Iterable<JobRecord>, String> call() {
                QueryResultIterator entities = preparedQuery.asQueryResultIterable(fetchOptions).iterator();
                Cursor dsCursor = null;
                LinkedList<JobRecord> roots = new LinkedList<JobRecord>();
                while (entities.hasNext()) {
                    if (limit > 0 && roots.size() >= limit) {
                        dsCursor = entities.getCursor();
                        break;
                    }
                    JobRecord jobRecord = new JobRecord((Entity)entities.next());
                    roots.add(jobRecord);
                }
                return Pair.of(roots, dsCursor == null ? null : dsCursor.toWebSafeString());
            }
        });
    }

    @Override
    public Set<String> getRootPipelinesDisplayName() {
        Query query = new Query("pipeline-job");
        query.addProjection((Projection)new PropertyProjection("rootJobDisplayName", String.class));
        query.setDistinct(true);
        final PreparedQuery preparedQuery = this.dataStore.prepare(query);
        return this.tryFiveTimes(new Operation<Set<String>>("getRootPipelinesDisplayName"){

            @Override
            public Set<String> call() {
                LinkedHashSet<String> pipelines = new LinkedHashSet<String>();
                for (Entity entity : preparedQuery.asIterable()) {
                    pipelines.add((String)entity.getProperty("rootJobDisplayName"));
                }
                return pipelines;
            }
        });
    }

    @Override
    public PipelineObjects queryFullPipeline(Key rootJobKey) {
        HashMap<Key, JobRecord> jobs = new HashMap<Key, JobRecord>();
        HashMap<Key, Slot> slots = new HashMap<Key, Slot>();
        HashMap<Key, Barrier> barriers = new HashMap<Key, Barrier>();
        HashMap<Key, JobInstanceRecord> jobInstanceRecords = new HashMap<Key, JobInstanceRecord>();
        HashMap<Key, ExceptionRecord> failureRecords = new HashMap<Key, ExceptionRecord>();
        for (Entity entity : this.queryAll("pipeline-barrier", rootJobKey)) {
            barriers.put(entity.getKey(), new Barrier(entity));
        }
        for (Entity entity : this.queryAll("pipeline-slot", rootJobKey)) {
            slots.put(entity.getKey(), new Slot(entity, true));
        }
        for (Entity entity : this.queryAll("pipeline-job", rootJobKey)) {
            jobs.put(entity.getKey(), new JobRecord(entity));
        }
        for (Entity entity : this.queryAll("pipeline-jobInstanceRecord", rootJobKey)) {
            jobInstanceRecords.put(entity.getKey(), new JobInstanceRecord(entity));
        }
        for (Entity entity : this.queryAll("pipeline-exception", rootJobKey)) {
            failureRecords.put(entity.getKey(), new ExceptionRecord(entity));
        }
        return new PipelineObjects(rootJobKey, jobs, slots, barriers, jobInstanceRecords, failureRecords);
    }

    private void deleteAll(final String kind, final Key rootJobKey) {
        String string = String.valueOf(String.valueOf(kind));
        String string2 = String.valueOf(String.valueOf(rootJobKey));
        logger.info(new StringBuilder(30 + string.length() + string2.length()).append("Deleting all ").append(string).append(" with rootJobKey=").append(string2).toString());
        int chunkSize = 100;
        final FetchOptions fetchOptions = FetchOptions.Builder.withChunkSize((int)100);
        final PreparedQuery preparedQuery = this.dataStore.prepare(new Query(kind).setKeysOnly().setFilter((Query.Filter)new Query.FilterPredicate("rootJobKey", Query.FilterOperator.EQUAL, (Object)rootJobKey)));
        this.tryFiveTimes(new Operation<Void>("delete"){

            @Override
            public Void call() {
                Iterator iter = preparedQuery.asIterator(fetchOptions);
                while (iter.hasNext()) {
                    ArrayList<Key> keys = new ArrayList<Key>(100);
                    for (int i = 0; i < 100 && iter.hasNext(); ++i) {
                        keys.add(((Entity)iter.next()).getKey());
                    }
                    int n = keys.size();
                    String string = String.valueOf(String.valueOf(kind));
                    String string2 = String.valueOf(String.valueOf(rootJobKey));
                    logger.info(new StringBuilder(40 + string.length() + string2.length()).append("Deleting  ").append(n).append(" ").append(string).append("s with rootJobKey=").append(string2).toString());
                    AppEngineBackEnd.this.dataStore.delete(null, keys);
                }
                return null;
            }
        });
    }

    @Override
    public void deletePipeline(Key rootJobKey, boolean force, boolean async) throws IllegalStateException {
        if (!force) {
            try {
                JobRecord rootJobRecord = this.queryJob(rootJobKey, JobRecord.InflationType.NONE);
                switch (rootJobRecord.getState()) {
                    case FINALIZED: 
                    case STOPPED: {
                        break;
                    }
                    default: {
                        String string = String.valueOf(String.valueOf(rootJobRecord));
                        throw new IllegalStateException(new StringBuilder(27 + string.length()).append("Pipeline is still running: ").append(string).toString());
                    }
                }
            }
            catch (NoSuchObjectException ex) {
                // empty catch block
            }
        }
        if (async) {
            DeletePipelineTask task = new DeletePipelineTask(rootJobKey, force, new QueueSettings());
            this.taskQueue.enqueue(task);
            return;
        }
        this.deleteAll("pipeline-job", rootJobKey);
        this.deleteAll("pipeline-slot", rootJobKey);
        this.deleteAll("pipeline-sharded-value", rootJobKey);
        this.deleteAll("pipeline-barrier", rootJobKey);
        this.deleteAll("pipeline-jobInstanceRecord", rootJobKey);
        this.deleteAll("pipeline-fanoutTask", rootJobKey);
    }

    private abstract class Operation<R>
    implements Callable<R> {
        private final String name;

        Operation(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

