/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.backend;

import com.google.appengine.api.backends.BackendServiceFactory;
import com.google.appengine.api.modules.ModulesException;
import com.google.appengine.api.modules.ModulesService;
import com.google.appengine.api.modules.ModulesServiceFactory;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueConstants;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskAlreadyExistsException;
import com.google.appengine.api.taskqueue.TaskHandle;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.tools.cloudstorage.ExceptionHandler;
import com.google.appengine.tools.cloudstorage.RetryHelper;
import com.google.appengine.tools.cloudstorage.RetryParams;
import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.backend.PipelineTaskQueue;
import com.google.appengine.tools.pipeline.impl.servlets.TaskHandler;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import com.google.apphosting.api.ApiProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;

public class AppEngineTaskQueue
implements PipelineTaskQueue {
    private static final Logger logger = Logger.getLogger(AppEngineTaskQueue.class.getName());
    static final int MAX_TASKS_PER_ENQUEUE = QueueConstants.maxTasksPerAdd();
    private static final ExceptionHandler MODULES_EXCEPTION_HANDLER = new ExceptionHandler.Builder().retryOn(new Class[]{ModulesException.class}).build();

    @Override
    public void enqueue(Task task) {
        String string = String.valueOf(String.valueOf(task));
        logger.finest(new StringBuilder(12 + string.length()).append("Enqueueing: ").append(string).toString());
        TaskOptions taskOptions = this.toTaskOptions(task);
        Queue queue = AppEngineTaskQueue.getQueue(task.getQueueSettings().getOnQueue());
        try {
            queue.add(taskOptions);
        }
        catch (TaskAlreadyExistsException ingore) {
            // empty catch block
        }
    }

    private static Queue getQueue(String queueName) {
        if (queueName == null) {
            Map attributes = ApiProxy.getCurrentEnvironment().getAttributes();
            queueName = (String)attributes.get("X-AppEngine-QueueName");
        }
        return queueName == null ? QueueFactory.getDefaultQueue() : QueueFactory.getQueue((String)queueName);
    }

    @Override
    public void enqueue(Collection<Task> tasks) {
        this.addToQueue(tasks);
    }

    List<TaskHandle> addToQueue(Collection<Task> tasks) {
        ArrayList<TaskHandle> handles = new ArrayList<TaskHandle>();
        HashMap<String, ArrayList<TaskOptions>> queueNameToTaskOptions = new HashMap<String, ArrayList<TaskOptions>>();
        for (Task task : tasks) {
            String string = String.valueOf(String.valueOf(task));
            logger.finest(new StringBuilder(12 + string.length()).append("Enqueueing: ").append(string).toString());
            String queueName = task.getQueueSettings().getOnQueue();
            TaskOptions taskOptions = this.toTaskOptions(task);
            ArrayList<TaskOptions> taskOptionsList = (ArrayList<TaskOptions>)queueNameToTaskOptions.get(queueName);
            if (taskOptionsList == null) {
                taskOptionsList = new ArrayList<TaskOptions>();
                queueNameToTaskOptions.put(queueName, taskOptionsList);
            }
            taskOptionsList.add(taskOptions);
        }
        for (Map.Entry entry : queueNameToTaskOptions.entrySet()) {
            Queue queue = AppEngineTaskQueue.getQueue((String)entry.getKey());
            handles.addAll(this.addToQueue(queue, (List)entry.getValue()));
        }
        return handles;
    }

    private List<TaskHandle> addToQueue(Queue queue, List<TaskOptions> tasks) {
        int limit = tasks.size();
        int start = 0;
        ArrayList<Future> futures = new ArrayList<Future>(limit / MAX_TASKS_PER_ENQUEUE + 1);
        while (start < limit) {
            int end = Math.min(limit, start + MAX_TASKS_PER_ENQUEUE);
            futures.add(queue.addAsync(tasks.subList(start, end)));
            start = end;
        }
        ArrayList<TaskHandle> taskHandles = new ArrayList<TaskHandle>(limit);
        for (Future future : futures) {
            try {
                taskHandles.addAll((Collection)future.get());
            }
            catch (InterruptedException e) {
                logger.throwing("AppEngineTaskQueue", "addToQueue", e);
                Thread.currentThread().interrupt();
                throw new RuntimeException("addToQueue failed", e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof TaskAlreadyExistsException) continue;
                throw new RuntimeException("addToQueue failed", e.getCause());
            }
        }
        return taskHandles;
    }

    private TaskOptions toTaskOptions(Task task) {
        final QueueSettings queueSettings = task.getQueueSettings();
        TaskOptions taskOptions = TaskOptions.Builder.withUrl((String)TaskHandler.handleTaskUrl());
        if (queueSettings.getOnBackend() != null) {
            taskOptions.header("Host", BackendServiceFactory.getBackendService().getBackendAddress(queueSettings.getOnBackend()));
        } else {
            String versionHostname = (String)RetryHelper.runWithRetries((Callable)new Callable<String>(){

                @Override
                public String call() {
                    ModulesService service = ModulesServiceFactory.getModulesService();
                    String module = queueSettings.getOnModule();
                    String version = queueSettings.getModuleVersion();
                    if (module == null) {
                        module = service.getCurrentModule();
                        version = service.getCurrentVersion();
                    }
                    return service.getVersionHostname(module, version);
                }
            }, (RetryParams)RetryParams.getDefaultInstance(), (ExceptionHandler)MODULES_EXCEPTION_HANDLER);
            taskOptions.header("Host", versionHostname);
        }
        Long delayInSeconds = queueSettings.getDelayInSeconds();
        if (null != delayInSeconds) {
            taskOptions.countdownMillis(delayInSeconds * 1000L);
            queueSettings.setDelayInSeconds(null);
        }
        AppEngineTaskQueue.addProperties(taskOptions, task.toProperties());
        String taskName = task.getName();
        if (null != taskName) {
            taskOptions.taskName(taskName);
        }
        return taskOptions;
    }

    private static void addProperties(TaskOptions taskOptions, Properties properties) {
        for (String paramName : properties.stringPropertyNames()) {
            String paramValue = properties.getProperty(paramName);
            taskOptions.param(paramName, paramValue);
        }
    }
}

