/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import com.google.appengine.tools.pipeline.impl.model.SlotDescriptor;
import com.google.appengine.tools.pipeline.impl.util.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Barrier
extends PipelineModelObject {
    public static final String DATA_STORE_KIND = "pipeline-barrier";
    private static final String TYPE_PROPERTY = "barrierType";
    private static final String JOB_KEY_PROPERTY = "jobKey";
    private static final String RELEASED_PROPERTY = "released";
    private static final String WAITING_ON_KEYS_PROPERTY = "waitingOnKeys";
    private static final String WAITING_ON_GROUP_SIZES_PROPERTY = "waitingOnGroupSizes";
    private final Type type;
    private final Key jobKey;
    private boolean released;
    private final List<Key> waitingOnKeys;
    private final List<Long> waitingOnGroupSizes;
    private List<SlotDescriptor> waitingOnInflated;

    private static Key getEgParentKey(Type type, Key jobKey) {
        switch (type) {
            case RUN: {
                return null;
            }
            case FINALIZE: {
                if (null != jobKey) break;
                throw new IllegalArgumentException("jobKey is null");
            }
        }
        return jobKey;
    }

    private Barrier(Type type, Key rootJobKey, Key jobKey, Key generatorJobKey, String graphGUID) {
        super(rootJobKey, Barrier.getEgParentKey(type, jobKey), null, generatorJobKey, graphGUID);
        this.jobKey = jobKey;
        this.type = type;
        this.waitingOnGroupSizes = new LinkedList<Long>();
        this.waitingOnInflated = new LinkedList<SlotDescriptor>();
        this.waitingOnKeys = new LinkedList<Key>();
    }

    public static Barrier dummyInstanceForTesting() {
        Key dummyKey = KeyFactory.createKey((String)"dummy", (String)"dummy");
        return new Barrier(Type.RUN, dummyKey, dummyKey, dummyKey, "abc");
    }

    public Barrier(Type type, JobRecord jobRecord) {
        this(type, jobRecord.getRootJobKey(), jobRecord.getKey(), jobRecord.getGeneratorJobKey(), jobRecord.getGraphGuid());
    }

    public Barrier(Entity entity) {
        super(entity);
        this.jobKey = (Key)entity.getProperty(JOB_KEY_PROPERTY);
        this.type = Type.valueOf((String)entity.getProperty(TYPE_PROPERTY));
        this.released = (Boolean)entity.getProperty(RELEASED_PROPERTY);
        this.waitingOnKeys = Barrier.getListProperty(WAITING_ON_KEYS_PROPERTY, entity);
        this.waitingOnGroupSizes = Barrier.getListProperty(WAITING_ON_GROUP_SIZES_PROPERTY, entity);
    }

    @Override
    public Entity toEntity() {
        Entity entity = this.toProtoEntity();
        entity.setProperty(JOB_KEY_PROPERTY, (Object)this.jobKey);
        entity.setUnindexedProperty(TYPE_PROPERTY, (Object)this.type.toString());
        entity.setUnindexedProperty(RELEASED_PROPERTY, (Object)this.released);
        entity.setUnindexedProperty(WAITING_ON_KEYS_PROPERTY, this.waitingOnKeys);
        entity.setUnindexedProperty(WAITING_ON_GROUP_SIZES_PROPERTY, this.waitingOnGroupSizes);
        return entity;
    }

    @Override
    protected String getDatastoreKind() {
        return DATA_STORE_KIND;
    }

    public void inflate(Map<Key, Slot> pool) {
        int numSlots = this.waitingOnKeys.size();
        this.waitingOnInflated = new ArrayList<SlotDescriptor>(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            Key key = this.waitingOnKeys.get(i);
            int groupSize = this.waitingOnGroupSizes.get(i).intValue();
            Slot slot = pool.get(key);
            if (null == slot) {
                String string = String.valueOf(String.valueOf(key));
                throw new RuntimeException(new StringBuilder(25 + string.length()).append("No slot in pool with key=").append(string).toString());
            }
            SlotDescriptor descriptor = new SlotDescriptor(slot, groupSize);
            this.waitingOnInflated.add(descriptor);
        }
    }

    public Key getJobKey() {
        return this.jobKey;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isReleased() {
        return this.released;
    }

    public void setReleased() {
        this.released = true;
    }

    public List<Key> getWaitingOnKeys() {
        return this.waitingOnKeys;
    }

    public List<SlotDescriptor> getWaitingOnInflated() {
        return this.waitingOnInflated;
    }

    public Object[] buildArgumentArray() {
        List<Object> argumentList = this.buildArgumentList();
        Object[] argumentArray = new Object[argumentList.size()];
        argumentList.toArray(argumentArray);
        return argumentArray;
    }

    public List<Object> buildArgumentList() {
        if (null == this.waitingOnInflated) {
            String string = String.valueOf(String.valueOf(this));
            throw new RuntimeException(new StringBuilder(23 + string.length()).append(string).append(" has not been inflated.").toString());
        }
        LinkedList<Object> argumentList = new LinkedList<Object>();
        ArrayList<Object> currentListArg = null;
        int currentListArgExpectedSize = -1;
        for (SlotDescriptor descriptor : this.waitingOnInflated) {
            if (!descriptor.slot.isFilled()) {
                String string = String.valueOf(String.valueOf(descriptor.slot));
                throw new RuntimeException(new StringBuilder(20 + string.length()).append("Slot is not filled: ").append(string).toString());
            }
            Object nextValue = descriptor.slot.getValue();
            if (currentListArg != null) {
                if (descriptor.groupSize != currentListArgExpectedSize + 1) {
                    int n = currentListArgExpectedSize;
                    int n2 = descriptor.groupSize;
                    String string = String.valueOf(String.valueOf(nextValue));
                    throw new RuntimeException(new StringBuilder(66 + string.length()).append("expectedGroupSize: ").append(n).append(", groupSize: ").append(n2).append("; nextValue=").append(string).toString());
                }
                currentListArg.add(nextValue);
            } else if (descriptor.groupSize > 0) {
                currentListArgExpectedSize = descriptor.groupSize - 1;
                currentListArg = new ArrayList<Object>(currentListArgExpectedSize);
                argumentList.add(currentListArg);
            } else if (descriptor.groupSize == 0) {
                argumentList.add(nextValue);
            }
            if (null == currentListArg || currentListArg.size() != currentListArgExpectedSize) continue;
            currentListArg = null;
            currentListArgExpectedSize = -1;
        }
        return argumentList;
    }

    private void addSlotDescriptor(SlotDescriptor slotDescr) {
        if (null == this.waitingOnInflated) {
            this.waitingOnInflated = new LinkedList<SlotDescriptor>();
        }
        this.waitingOnInflated.add(slotDescr);
        this.waitingOnGroupSizes.add(Long.valueOf(slotDescr.groupSize));
        Slot slot = slotDescr.slot;
        slot.addWaiter(this);
        this.waitingOnKeys.add(slotDescr.slot.getKey());
    }

    public void addRegularArgumentSlot(Slot slot) {
        this.verifyStateBeforAdd(slot);
        this.addSlotDescriptor(new SlotDescriptor(slot, 0));
    }

    public void addPhantomArgumentSlot(Slot slot) {
        this.verifyStateBeforAdd(slot);
        this.addSlotDescriptor(new SlotDescriptor(slot, -1));
    }

    private void verifyStateBeforAdd(Slot slot) {
        if (this.getType() == Type.FINALIZE && this.waitingOnInflated != null && !this.waitingOnInflated.isEmpty()) {
            String string = String.valueOf(String.valueOf(slot));
            String string2 = String.valueOf(String.valueOf(this));
            throw new IllegalStateException(new StringBuilder(67 + string.length() + string2.length()).append("Trying to add a slot, ").append(string).append(", to an already populated finalized barrier: ").append(string2).toString());
        }
    }

    public void addListArgumentSlots(Slot initialSlot, List<Slot> slotList) {
        if (!initialSlot.isFilled()) {
            throw new IllegalArgumentException("initialSlot must be filled");
        }
        this.verifyStateBeforAdd(initialSlot);
        int groupSize = slotList.size() + 1;
        this.addSlotDescriptor(new SlotDescriptor(initialSlot, groupSize));
        for (Slot slot : slotList) {
            this.addSlotDescriptor(new SlotDescriptor(slot, groupSize));
        }
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(Barrier.getKeyName(this.getKey())));
        String string2 = String.valueOf(String.valueOf((Object)this.type));
        boolean bl = this.released;
        String string3 = String.valueOf(String.valueOf(this.jobKey.getName()));
        String string4 = String.valueOf(String.valueOf(StringUtils.toStringParallel(this.waitingOnKeys, this.waitingOnGroupSizes)));
        String string5 = String.valueOf(String.valueOf(Barrier.getKeyName(this.getJobKey())));
        String string6 = String.valueOf(String.valueOf(Barrier.getKeyName(this.getGeneratorJobKey())));
        String string7 = String.valueOf(String.valueOf(this.getGraphGuid()));
        return new StringBuilder(63 + string.length() + string2.length() + string3.length() + string4.length() + string5.length() + string6.length() + string7.length()).append("Barrier[").append(string).append(", ").append(string2).append(", released=").append(bl).append(", ").append(string3).append(", waitingOn=").append(string4).append(", job=").append(string5).append(", parent=").append(string6).append(", guid=").append(string7).append("]").toString();
    }

    public static enum Type {
        RUN,
        FINALIZE;

    }
}

