/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;

public class FanoutTaskRecord
extends PipelineModelObject {
    public static final String DATA_STORE_KIND = "pipeline-fanoutTask";
    private static final String PAYLOAD_PROPERTY = "payload";
    private final byte[] payload;

    public FanoutTaskRecord(Key rootJobKey, byte[] payload) {
        super(rootJobKey, null, null);
        if (payload == null) {
            throw new RuntimeException("Payload must not be null");
        }
        this.payload = payload;
    }

    public FanoutTaskRecord(Entity entity) {
        super(entity);
        Blob payloadBlob = (Blob)entity.getProperty(PAYLOAD_PROPERTY);
        this.payload = payloadBlob.getBytes();
    }

    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    protected String getDatastoreKind() {
        return DATA_STORE_KIND;
    }

    @Override
    public Entity toEntity() {
        Entity entity = this.toProtoEntity();
        entity.setUnindexedProperty(PAYLOAD_PROPERTY, (Object)new Blob(this.payload));
        return entity;
    }
}

