/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.Job;
import com.google.appengine.tools.pipeline.impl.PipelineManager;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import java.io.IOException;

public class JobInstanceRecord
extends PipelineModelObject {
    public static final String DATA_STORE_KIND = "pipeline-jobInstanceRecord";
    private static final String JOB_KEY_PROPERTY = "jobKey";
    private static final String JOB_CLASS_NAME_PROPERTY = "jobClassName";
    public static final String JOB_DISPLAY_NAME_PROPERTY = "jobDisplayName";
    private static final String INSTANCE_BYTES_PROPERTY = "bytes";
    private static final String INSTANCE_VALUE_PROPERTY = "value";
    private final Key jobKey;
    private final String jobClassName;
    private final String jobDisplayName;
    private final Object value;
    private Job<?> jobInstance;

    public JobInstanceRecord(JobRecord job, Job<?> jobInstance) {
        super(job.getRootJobKey(), job.getGeneratorJobKey(), job.getGraphGuid());
        this.jobKey = job.getKey();
        this.jobClassName = jobInstance.getClass().getName();
        this.jobDisplayName = jobInstance.getJobDisplayName();
        try {
            this.value = PipelineManager.getBackEnd().serializeValue(this, jobInstance);
        }
        catch (IOException e) {
            String string = String.valueOf(String.valueOf(jobInstance));
            throw new RuntimeException(new StringBuilder(56 + string.length()).append("Exception while attempting to serialize the jobInstance ").append(string).toString(), e);
        }
    }

    public JobInstanceRecord(Entity entity) {
        super(entity);
        this.jobKey = (Key)entity.getProperty(JOB_KEY_PROPERTY);
        this.jobClassName = (String)entity.getProperty(JOB_CLASS_NAME_PROPERTY);
        this.jobDisplayName = entity.hasProperty(JOB_DISPLAY_NAME_PROPERTY) ? (String)entity.getProperty(JOB_DISPLAY_NAME_PROPERTY) : this.jobClassName;
        this.value = entity.hasProperty(INSTANCE_BYTES_PROPERTY) ? entity.getProperty(INSTANCE_BYTES_PROPERTY) : entity.getProperty(INSTANCE_VALUE_PROPERTY);
    }

    @Override
    public Entity toEntity() {
        Entity entity = this.toProtoEntity();
        entity.setProperty(JOB_KEY_PROPERTY, (Object)this.jobKey);
        entity.setProperty(JOB_CLASS_NAME_PROPERTY, (Object)this.jobClassName);
        entity.setUnindexedProperty(INSTANCE_VALUE_PROPERTY, this.value);
        entity.setUnindexedProperty(JOB_DISPLAY_NAME_PROPERTY, (Object)this.jobDisplayName);
        return entity;
    }

    @Override
    protected String getDatastoreKind() {
        return DATA_STORE_KIND;
    }

    public Key getJobKey() {
        return this.jobKey;
    }

    public String getJobDisplayName() {
        return this.jobDisplayName;
    }

    public String getClassName() {
        return this.jobClassName;
    }

    public synchronized Job<?> getJobInstanceDeserialized() {
        if (null == this.jobInstance) {
            try {
                this.jobInstance = (Job)PipelineManager.getBackEnd().deserializeValue(this, this.value);
            }
            catch (IOException e) {
                String string = String.valueOf(String.valueOf(this.jobKey));
                throw new RuntimeException(new StringBuilder(58 + string.length()).append("Exception while attempting to deserialize jobInstance for ").append(string).toString(), e);
            }
        }
        return this.jobInstance;
    }
}

