/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.backends.BackendService;
import com.google.appengine.api.backends.BackendServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.modules.ModulesService;
import com.google.appengine.api.modules.ModulesServiceFactory;
import com.google.appengine.tools.pipeline.Job;
import com.google.appengine.tools.pipeline.JobInfo;
import com.google.appengine.tools.pipeline.JobSetting;
import com.google.appengine.tools.pipeline.impl.FutureValueImpl;
import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.ExceptionRecord;
import com.google.appengine.tools.pipeline.impl.model.JobInstanceRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import com.google.appengine.tools.pipeline.impl.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class JobRecord
extends PipelineModelObject
implements JobInfo {
    public static final String EXCEPTION_HANDLER_METHOD_NAME = "handleException";
    public static final String DATA_STORE_KIND = "pipeline-job";
    private static final String JOB_INSTANCE_PROPERTY = "jobInstance";
    private static final String RUN_BARRIER_PROPERTY = "runBarrier";
    private static final String FINALIZE_BARRIER_PROPERTY = "finalizeBarrier";
    public static final String STATE_PROPERTY = "state";
    private static final String EXCEPTION_HANDLING_ANCESTOR_KEY_PROPERTY = "exceptionHandlingAncestorKey";
    private static final String EXCEPTION_HANDLER_SPECIFIED_PROPERTY = "hasExceptionHandler";
    private static final String EXCEPTION_HANDLER_JOB_KEY_PROPERTY = "exceptionHandlerJobKey";
    private static final String EXCEPTION_HANDLER_JOB_GRAPH_GUID_PROPERTY = "exceptionHandlerJobGraphGuid";
    private static final String CALL_EXCEPTION_HANDLER_PROPERTY = "callExceptionHandler";
    private static final String IGNORE_EXCEPTION_PROPERTY = "ignoreException";
    private static final String OUTPUT_SLOT_PROPERTY = "outputSlot";
    private static final String EXCEPTION_KEY_PROPERTY = "exceptionKey";
    public static final String START_TIME_PROPERTY = "startTime";
    private static final String END_TIME_PROPERTY = "endTime";
    private static final String CHILD_KEYS_PROPERTY = "childKeys";
    private static final String ATTEMPT_NUM_PROPERTY = "attemptNum";
    private static final String MAX_ATTEMPTS_PROPERTY = "maxAttempts";
    private static final String BACKOFF_SECONDS_PROPERTY = "backoffSeconds";
    private static final String BACKOFF_FACTOR_PROPERTY = "backoffFactor";
    private static final String ON_BACKEND_PROPERTY = "onBackend";
    private static final String ON_MODULE_PROPERTY = "onModule";
    private static final String ON_QUEUE_PROPERTY = "onQueue";
    private static final String MODULE_VERSION_PROPERTY = "moduleVersion";
    private static final String CHILD_GRAPH_GUID_PROPERTY = "childGraphGuid";
    private static final String STATUS_CONSOLE_URL = "statusConsoleUrl";
    public static final String ROOT_JOB_DISPLAY_NAME = "rootJobDisplayName";
    private final Key jobInstanceKey;
    private final Key runBarrierKey;
    private final Key finalizeBarrierKey;
    private Key outputSlotKey;
    private State state;
    private Key exceptionHandlingAncestorKey;
    private boolean exceptionHandlerSpecified;
    private Key exceptionHandlerJobKey;
    private String exceptionHandlerJobGraphGuid;
    private boolean callExceptionHandler;
    private boolean ignoreException;
    private Key exceptionKey;
    private Date startTime;
    private Date endTime;
    private String childGraphGuid;
    private List<Key> childKeys;
    private long attemptNumber;
    private long maxAttempts = 3L;
    private long backoffSeconds = 15L;
    private long backoffFactor = 2L;
    private final QueueSettings queueSettings = new QueueSettings();
    private String statusConsoleUrl;
    private String rootJobDisplayName;
    private Barrier runBarrierInflated;
    private Barrier finalizeBarrierInflated;
    private Slot outputSlotInflated;
    private JobInstanceRecord jobInstanceRecordInflated;
    private Throwable exceptionInflated;

    public JobRecord(Entity entity) {
        super(entity);
        Text childGraphGuidText;
        Object ignoreExceptionProperty;
        Object callExceptionHandlerProperty;
        this.jobInstanceKey = (Key)entity.getProperty(JOB_INSTANCE_PROPERTY);
        this.finalizeBarrierKey = (Key)entity.getProperty(FINALIZE_BARRIER_PROPERTY);
        this.runBarrierKey = (Key)entity.getProperty(RUN_BARRIER_PROPERTY);
        this.outputSlotKey = (Key)entity.getProperty(OUTPUT_SLOT_PROPERTY);
        this.state = State.valueOf((String)entity.getProperty(STATE_PROPERTY));
        this.exceptionHandlingAncestorKey = (Key)entity.getProperty(EXCEPTION_HANDLING_ANCESTOR_KEY_PROPERTY);
        Object exceptionHandlerSpecifiedProperty = entity.getProperty(EXCEPTION_HANDLER_SPECIFIED_PROPERTY);
        if (null != exceptionHandlerSpecifiedProperty) {
            this.exceptionHandlerSpecified = (Boolean)exceptionHandlerSpecifiedProperty;
        }
        this.exceptionHandlerJobKey = (Key)entity.getProperty(EXCEPTION_HANDLER_JOB_KEY_PROPERTY);
        Text exceptionHandlerGraphGuidText = (Text)entity.getProperty(EXCEPTION_HANDLER_JOB_GRAPH_GUID_PROPERTY);
        if (null != exceptionHandlerGraphGuidText) {
            this.exceptionHandlerJobGraphGuid = exceptionHandlerGraphGuidText.getValue();
        }
        if (null != (callExceptionHandlerProperty = entity.getProperty(CALL_EXCEPTION_HANDLER_PROPERTY))) {
            this.callExceptionHandler = (Boolean)callExceptionHandlerProperty;
        }
        if (null != (ignoreExceptionProperty = entity.getProperty(IGNORE_EXCEPTION_PROPERTY))) {
            this.ignoreException = (Boolean)ignoreExceptionProperty;
        }
        if (null != (childGraphGuidText = (Text)entity.getProperty(CHILD_GRAPH_GUID_PROPERTY))) {
            this.childGraphGuid = childGraphGuidText.getValue();
        }
        this.exceptionKey = (Key)entity.getProperty(EXCEPTION_KEY_PROPERTY);
        this.startTime = (Date)entity.getProperty(START_TIME_PROPERTY);
        this.endTime = (Date)entity.getProperty(END_TIME_PROPERTY);
        this.childKeys = (List)entity.getProperty(CHILD_KEYS_PROPERTY);
        if (null == this.childKeys) {
            this.childKeys = new LinkedList<Key>();
        }
        this.attemptNumber = (Long)entity.getProperty(ATTEMPT_NUM_PROPERTY);
        this.maxAttempts = (Long)entity.getProperty(MAX_ATTEMPTS_PROPERTY);
        this.backoffSeconds = (Long)entity.getProperty(BACKOFF_SECONDS_PROPERTY);
        this.backoffFactor = (Long)entity.getProperty(BACKOFF_FACTOR_PROPERTY);
        this.queueSettings.setOnBackend((String)entity.getProperty(ON_BACKEND_PROPERTY));
        this.queueSettings.setOnModule((String)entity.getProperty(ON_MODULE_PROPERTY));
        this.queueSettings.setModuleVersion((String)entity.getProperty(MODULE_VERSION_PROPERTY));
        this.queueSettings.setOnQueue((String)entity.getProperty(ON_QUEUE_PROPERTY));
        this.statusConsoleUrl = (String)entity.getProperty(STATUS_CONSOLE_URL);
        this.rootJobDisplayName = (String)entity.getProperty(ROOT_JOB_DISPLAY_NAME);
    }

    @Override
    public Entity toEntity() {
        Entity entity = this.toProtoEntity();
        entity.setProperty(JOB_INSTANCE_PROPERTY, (Object)this.jobInstanceKey);
        entity.setProperty(FINALIZE_BARRIER_PROPERTY, (Object)this.finalizeBarrierKey);
        entity.setProperty(RUN_BARRIER_PROPERTY, (Object)this.runBarrierKey);
        entity.setProperty(OUTPUT_SLOT_PROPERTY, (Object)this.outputSlotKey);
        entity.setProperty(STATE_PROPERTY, (Object)this.state.toString());
        if (null != this.exceptionHandlingAncestorKey) {
            entity.setProperty(EXCEPTION_HANDLING_ANCESTOR_KEY_PROPERTY, (Object)this.exceptionHandlingAncestorKey);
        }
        if (this.exceptionHandlerSpecified) {
            entity.setProperty(EXCEPTION_HANDLER_SPECIFIED_PROPERTY, (Object)Boolean.TRUE);
        }
        if (null != this.exceptionHandlerJobKey) {
            entity.setProperty(EXCEPTION_HANDLER_JOB_KEY_PROPERTY, (Object)this.exceptionHandlerJobKey);
        }
        if (null != this.exceptionKey) {
            entity.setProperty(EXCEPTION_KEY_PROPERTY, (Object)this.exceptionKey);
        }
        if (null != this.exceptionHandlerJobGraphGuid) {
            entity.setUnindexedProperty(EXCEPTION_HANDLER_JOB_GRAPH_GUID_PROPERTY, (Object)new Text(this.exceptionHandlerJobGraphGuid));
        }
        entity.setUnindexedProperty(CALL_EXCEPTION_HANDLER_PROPERTY, (Object)this.callExceptionHandler);
        entity.setUnindexedProperty(IGNORE_EXCEPTION_PROPERTY, (Object)this.ignoreException);
        if (this.childGraphGuid != null) {
            entity.setUnindexedProperty(CHILD_GRAPH_GUID_PROPERTY, (Object)new Text(this.childGraphGuid));
        }
        entity.setProperty(START_TIME_PROPERTY, (Object)this.startTime);
        entity.setUnindexedProperty(END_TIME_PROPERTY, (Object)this.endTime);
        entity.setProperty(CHILD_KEYS_PROPERTY, this.childKeys);
        entity.setUnindexedProperty(ATTEMPT_NUM_PROPERTY, (Object)this.attemptNumber);
        entity.setUnindexedProperty(MAX_ATTEMPTS_PROPERTY, (Object)this.maxAttempts);
        entity.setUnindexedProperty(BACKOFF_SECONDS_PROPERTY, (Object)this.backoffSeconds);
        entity.setUnindexedProperty(BACKOFF_FACTOR_PROPERTY, (Object)this.backoffFactor);
        entity.setUnindexedProperty(ON_BACKEND_PROPERTY, (Object)this.queueSettings.getOnBackend());
        entity.setUnindexedProperty(ON_MODULE_PROPERTY, (Object)this.queueSettings.getOnModule());
        entity.setUnindexedProperty(MODULE_VERSION_PROPERTY, (Object)this.queueSettings.getModuleVersion());
        entity.setUnindexedProperty(ON_QUEUE_PROPERTY, (Object)this.queueSettings.getOnQueue());
        entity.setUnindexedProperty(STATUS_CONSOLE_URL, (Object)this.statusConsoleUrl);
        if (this.rootJobDisplayName != null) {
            entity.setProperty(ROOT_JOB_DISPLAY_NAME, (Object)this.rootJobDisplayName);
        }
        return entity;
    }

    public JobRecord(JobRecord generatorJob, String graphGUIDParam, Job<?> jobInstance, boolean callExceptionHandler, JobSetting[] settings) {
        this(generatorJob.getRootJobKey(), null, generatorJob.getKey(), graphGUIDParam, jobInstance, callExceptionHandler, settings, generatorJob.getQueueSettings());
        this.exceptionHandlingAncestorKey = generatorJob.isExceptionHandlerSpecified() && !callExceptionHandler ? generatorJob.getKey() : generatorJob.getExceptionHandlingAncestorKey();
        HashMap settingsMap = new HashMap();
        for (JobSetting setting : settings) {
            settingsMap.put(setting.getClass(), setting);
        }
        if (!settingsMap.containsKey(JobSetting.StatusConsoleUrl.class)) {
            this.statusConsoleUrl = generatorJob.statusConsoleUrl;
        }
    }

    private JobRecord(Key rootJobKey, Key thisKey, Key generatorJobKey, String graphGUID, Job<?> jobInstance, boolean callExceptionHandler, JobSetting[] settings, QueueSettings parentQueueSettings) {
        super(rootJobKey, null, thisKey, generatorJobKey, graphGUID);
        this.jobInstanceRecordInflated = new JobInstanceRecord(this, jobInstance);
        this.jobInstanceKey = this.jobInstanceRecordInflated.getKey();
        this.exceptionHandlerSpecified = JobRecord.isExceptionHandlerSpecified(jobInstance);
        this.callExceptionHandler = callExceptionHandler;
        this.runBarrierInflated = new Barrier(Barrier.Type.RUN, this);
        this.runBarrierKey = this.runBarrierInflated.getKey();
        this.finalizeBarrierInflated = new Barrier(Barrier.Type.FINALIZE, this);
        this.finalizeBarrierKey = this.finalizeBarrierInflated.getKey();
        this.outputSlotInflated = new Slot(this.getRootJobKey(), this.getGeneratorJobKey(), this.getGraphGuid());
        this.outputSlotInflated.setSourceJobKey(this.getKey());
        this.outputSlotKey = this.outputSlotInflated.getKey();
        this.childKeys = new LinkedList<Key>();
        this.state = State.WAITING_TO_RUN;
        for (JobSetting setting : settings) {
            this.applySetting(setting);
        }
        if (parentQueueSettings != null) {
            this.queueSettings.merge(parentQueueSettings);
        }
        if (this.queueSettings.getOnBackend() == null) {
            String module = this.queueSettings.getOnModule();
            String moduleVersion = this.queueSettings.getModuleVersion();
            if (module == null) {
                String currentBackend = JobRecord.getCurrentBackend();
                if (currentBackend != null) {
                    this.queueSettings.setOnBackend(currentBackend);
                } else {
                    ModulesService modulesService = ModulesServiceFactory.getModulesService();
                    this.queueSettings.setOnModule(modulesService.getCurrentModule());
                    this.queueSettings.setModuleVersion(modulesService.getCurrentVersion());
                }
            } else if (moduleVersion == null) {
                ModulesService modulesService = ModulesServiceFactory.getModulesService();
                if (module.equals(modulesService.getCurrentModule())) {
                    this.queueSettings.setModuleVersion(modulesService.getCurrentVersion());
                } else {
                    this.queueSettings.setModuleVersion(modulesService.getDefaultVersion(module));
                }
            }
        }
    }

    private static String getCurrentBackend() {
        if (Boolean.parseBoolean(System.getenv("GAE_VM"))) {
            return null;
        }
        BackendService backendService = BackendServiceFactory.getBackendService();
        String currentBackend = backendService.getCurrentBackend();
        if (currentBackend != null && currentBackend.indexOf(58) != -1) {
            currentBackend = null;
        }
        return currentBackend;
    }

    private JobRecord(Key key, Job<?> jobInstance, JobSetting[] settings) {
        this(key, key, null, null, jobInstance, false, settings, null);
        this.rootJobDisplayName = jobInstance.getJobDisplayName();
    }

    public static JobRecord createRootJobRecord(Job<?> jobInstance, JobSetting[] settings) {
        Key key = JobRecord.generateKey(null, DATA_STORE_KIND);
        return new JobRecord(key, jobInstance, settings);
    }

    public static boolean isExceptionHandlerSpecified(Job<?> jobInstance) {
        boolean result = false;
        Class<?> clazz = jobInstance.getClass();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(EXCEPTION_HANDLER_METHOD_NAME)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || !Throwable.class.isAssignableFrom(parameterTypes[0])) {
                String string = String.valueOf(String.valueOf(method));
                throw new RuntimeException(new StringBuilder(101 + string.length()).append(string).append(" has invalid signature. It must have exactly one paramter of type ").append("Throwable or any of its descendants").toString());
            }
            result = true;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applySetting(JobSetting setting) {
        String string;
        if (setting instanceof JobSetting.WaitForSetting) {
            JobSetting.WaitForSetting wf = (JobSetting.WaitForSetting)setting;
            FutureValueImpl fv = (FutureValueImpl)wf.getValue();
            Slot slot = fv.getSlot();
            this.runBarrierInflated.addPhantomArgumentSlot(slot);
            return;
        }
        if (setting instanceof JobSetting.IntValuedSetting) {
            String string2;
            int value = ((JobSetting.IntValuedSetting)setting).getValue();
            if (setting instanceof JobSetting.BackoffSeconds) {
                this.backoffSeconds = value;
                return;
            }
            if (setting instanceof JobSetting.BackoffFactor) {
                this.backoffFactor = value;
                return;
            }
            if (setting instanceof JobSetting.MaxAttempts) {
                this.maxAttempts = value;
                return;
            }
            String string3 = String.valueOf(setting.getClass().getName());
            if (string3.length() != 0) {
                string2 = "Unrecognized JobOption class ".concat(string3);
                throw new RuntimeException(string2);
            }
            string2 = new String("Unrecognized JobOption class ");
            throw new RuntimeException(string2);
        }
        if (setting instanceof JobSetting.OnBackend) {
            this.queueSettings.setOnBackend(((JobSetting.OnBackend)setting).getValue());
            return;
        }
        if (setting instanceof JobSetting.OnModule) {
            this.queueSettings.setOnModule(((JobSetting.OnModule)setting).getValue());
            return;
        }
        if (setting instanceof JobSetting.OnModuleVersion) {
            this.queueSettings.setModuleVersion(((JobSetting.OnModuleVersion)setting).getValue());
            return;
        }
        if (setting instanceof JobSetting.OnQueue) {
            this.queueSettings.setOnQueue(((JobSetting.OnQueue)setting).getValue());
            return;
        }
        if (setting instanceof JobSetting.StatusConsoleUrl) {
            this.statusConsoleUrl = ((JobSetting.StatusConsoleUrl)setting).getValue();
            return;
        }
        String string4 = String.valueOf(setting.getClass().getName());
        if (string4.length() != 0) {
            string = "Unrecognized JobOption class ".concat(string4);
            throw new RuntimeException(string);
        }
        string = new String("Unrecognized JobOption class ");
        throw new RuntimeException(string);
    }

    @Override
    protected String getDatastoreKind() {
        return DATA_STORE_KIND;
    }

    private static boolean checkForInflate(PipelineModelObject obj, Key expectedGuid, String name) {
        if (null == obj) {
            return false;
        }
        if (!expectedGuid.equals((Object)obj.getKey())) {
            String string = String.valueOf(String.valueOf(name));
            String string2 = String.valueOf(String.valueOf(expectedGuid));
            String string3 = String.valueOf(String.valueOf(obj.getKey()));
            throw new IllegalArgumentException(new StringBuilder(35 + string.length() + string2.length() + string3.length()).append("Wrong guid for ").append(string).append(". Expected ").append(string2).append(" but was ").append(string3).toString());
        }
        return true;
    }

    public void inflate(Barrier runBarrier, Barrier finalizeBarrier, Slot outputSlot, JobInstanceRecord jobInstanceRecord, ExceptionRecord exceptionRecord) {
        if (JobRecord.checkForInflate(runBarrier, this.runBarrierKey, RUN_BARRIER_PROPERTY)) {
            this.runBarrierInflated = runBarrier;
        }
        if (JobRecord.checkForInflate(finalizeBarrier, this.finalizeBarrierKey, FINALIZE_BARRIER_PROPERTY)) {
            this.finalizeBarrierInflated = finalizeBarrier;
        }
        if (JobRecord.checkForInflate(outputSlot, this.outputSlotKey, OUTPUT_SLOT_PROPERTY)) {
            this.outputSlotInflated = outputSlot;
        }
        if (JobRecord.checkForInflate(jobInstanceRecord, this.jobInstanceKey, "jobInstanceRecord")) {
            this.jobInstanceRecordInflated = jobInstanceRecord;
        }
        if (JobRecord.checkForInflate(exceptionRecord, this.exceptionKey, "exception")) {
            this.exceptionInflated = exceptionRecord.getException();
        }
    }

    public Key getRunBarrierKey() {
        return this.runBarrierKey;
    }

    public Barrier getRunBarrierInflated() {
        return this.runBarrierInflated;
    }

    public Key getFinalizeBarrierKey() {
        return this.finalizeBarrierKey;
    }

    public Barrier getFinalizeBarrierInflated() {
        return this.finalizeBarrierInflated;
    }

    public Key getOutputSlotKey() {
        return this.outputSlotKey;
    }

    public void setOutputSlotInflated(Slot outputSlot) {
        this.outputSlotInflated = outputSlot;
        this.outputSlotKey = outputSlot.getKey();
    }

    public Slot getOutputSlotInflated() {
        return this.outputSlotInflated;
    }

    public Key getJobInstanceKey() {
        return this.jobInstanceKey;
    }

    public JobInstanceRecord getJobInstanceInflated() {
        return this.jobInstanceRecordInflated;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setChildGraphGuid(String guid) {
        this.childGraphGuid = guid;
    }

    public State getState() {
        return this.state;
    }

    public boolean isExceptionHandlerSpecified() {
        return this.exceptionHandlerSpecified && !this.isCallExceptionHandler();
    }

    public Key getExceptionHandlingAncestorKey() {
        return this.exceptionHandlingAncestorKey;
    }

    public Key getExceptionHandlerJobKey() {
        return this.exceptionHandlerJobKey;
    }

    public String getExceptionHandlerJobGraphGuid() {
        return this.exceptionHandlerJobGraphGuid;
    }

    public void setExceptionHandlerJobGraphGuid(String exceptionHandlerJobGraphGuid) {
        this.exceptionHandlerJobGraphGuid = exceptionHandlerJobGraphGuid;
    }

    public boolean isCallExceptionHandler() {
        return this.callExceptionHandler;
    }

    public boolean isIgnoreException() {
        return this.ignoreException;
    }

    public void setIgnoreException(boolean ignoreException) {
        this.ignoreException = ignoreException;
    }

    public int getAttemptNumber() {
        return (int)this.attemptNumber;
    }

    public void incrementAttemptNumber() {
        ++this.attemptNumber;
    }

    public int getBackoffSeconds() {
        return (int)this.backoffSeconds;
    }

    public int getBackoffFactor() {
        return (int)this.backoffFactor;
    }

    public int getMaxAttempts() {
        return (int)this.maxAttempts;
    }

    public QueueSettings getQueueSettings() {
        return this.queueSettings;
    }

    public String getStatusConsoleUrl() {
        return this.statusConsoleUrl;
    }

    public void setStatusConsoleUrl(String statusConsoleUrl) {
        this.statusConsoleUrl = statusConsoleUrl;
    }

    public void appendChildKey(Key key) {
        this.childKeys.add(key);
    }

    public List<Key> getChildKeys() {
        return this.childKeys;
    }

    public String getChildGraphGuid() {
        return this.childGraphGuid;
    }

    public void setExceptionKey(Key exceptionKey) {
        this.exceptionKey = exceptionKey;
    }

    @Override
    public JobInfo.State getJobState() {
        switch (this.state) {
            case WAITING_TO_RUN: 
            case WAITING_TO_FINALIZE: {
                return JobInfo.State.RUNNING;
            }
            case FINALIZED: {
                return JobInfo.State.COMPLETED_SUCCESSFULLY;
            }
            case CANCELED: {
                return JobInfo.State.CANCELED_BY_REQUEST;
            }
            case STOPPED: {
                if (null == this.exceptionKey) {
                    return JobInfo.State.STOPPED_BY_REQUEST;
                }
                return JobInfo.State.STOPPED_BY_ERROR;
            }
            case RETRY: {
                return JobInfo.State.WAITING_TO_RETRY;
            }
        }
        String string = String.valueOf(String.valueOf((Object)this.state));
        throw new RuntimeException(new StringBuilder(20 + string.length()).append("Unrecognized state: ").append(string).toString());
    }

    @Override
    public Object getOutput() {
        if (null == this.outputSlotInflated) {
            return null;
        }
        return this.outputSlotInflated.getValue();
    }

    @Override
    public String getError() {
        if (this.exceptionInflated == null) {
            return null;
        }
        return StringUtils.printStackTraceToString(this.exceptionInflated);
    }

    @Override
    public Throwable getException() {
        return this.exceptionInflated;
    }

    public Key getExceptionKey() {
        return this.exceptionKey;
    }

    public String getRootJobDisplayName() {
        return this.rootJobDisplayName;
    }

    private String getJobInstanceString() {
        if (null == this.jobInstanceRecordInflated) {
            String string = String.valueOf(String.valueOf(this.jobInstanceKey));
            return new StringBuilder(15 + string.length()).append("jobInstanceKey=").append(string).toString();
        }
        String jobClass = this.jobInstanceRecordInflated.getClassName();
        String string = String.valueOf(jobClass);
        String string2 = String.valueOf(this.callExceptionHandler ? ".handleException" : ".run");
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(JobRecord.getKeyName(this.getKey())));
        String string2 = String.valueOf(String.valueOf((Object)this.state));
        String string3 = String.valueOf(String.valueOf(this.getJobInstanceString()));
        boolean bl = this.callExceptionHandler;
        String string4 = String.valueOf(String.valueOf(this.runBarrierKey.getName()));
        String string5 = String.valueOf(String.valueOf(this.finalizeBarrierKey.getName()));
        String string6 = String.valueOf(String.valueOf(this.outputSlotKey.getName()));
        String string7 = String.valueOf(String.valueOf(this.rootJobDisplayName));
        String string8 = String.valueOf(String.valueOf(JobRecord.getKeyName(this.getGeneratorJobKey())));
        String string9 = String.valueOf(String.valueOf(this.getGraphGuid()));
        String string10 = String.valueOf(String.valueOf(this.childGraphGuid));
        return new StringBuilder(138 + string.length() + string2.length() + string3.length() + string4.length() + string5.length() + string6.length() + string7.length() + string8.length() + string9.length() + string10.length()).append("JobRecord [").append(string).append(", ").append(string2).append(", ").append(string3).append(", callExceptionJHandler=").append(bl).append(", runBarrier=").append(string4).append(", finalizeBarrier=").append(string5).append(", outputSlot=").append(string6).append(", rootJobDisplayName=").append(string7).append(", parent=").append(string8).append(", guid=").append(string9).append(", childGuid=").append(string10).append("]").toString();
    }

    public static enum InflationType {
        NONE,
        FOR_RUN,
        FOR_FINALIZE,
        FOR_OUTPUT;

    }

    public static enum State {
        WAITING_TO_RUN,
        WAITING_TO_FINALIZE,
        FINALIZED,
        STOPPED,
        CANCELED,
        RETRY;

    }
}

