/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.ExceptionRecord;
import com.google.appengine.tools.pipeline.impl.model.JobInstanceRecord;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class PipelineObjects {
    private static final Logger log = Logger.getLogger(PipelineObjects.class.getName());
    public JobRecord rootJob;
    public Map<Key, JobRecord> jobs;
    public Map<Key, Slot> slots;
    public Map<Key, Barrier> barriers;
    public Map<Key, JobInstanceRecord> jobInstanceRecords;

    public PipelineObjects(Key rootJobKey, Map<Key, JobRecord> jobs, Map<Key, Slot> slots, Map<Key, Barrier> barriers, Map<Key, JobInstanceRecord> jobInstanceRecords, Map<Key, ExceptionRecord> failureRecords) {
        String parentGuid;
        String string;
        String string2;
        Key parentKey;
        this.jobInstanceRecords = jobInstanceRecords;
        this.barriers = barriers;
        this.jobs = jobs;
        this.slots = slots;
        HashMap<Key, String> jobToChildGuid = new HashMap<Key, String>();
        for (JobRecord job : jobs.values()) {
            jobToChildGuid.put(job.getKey(), job.getChildGraphGuid());
            if (!job.getKey().equals((Object)rootJobKey)) continue;
            this.rootJob = job;
        }
        Iterator<Barrier> iter = jobs.values().iterator();
        while (iter.hasNext()) {
            JobRecord job;
            job = iter.next();
            if (job == this.rootJob) continue;
            parentKey = job.getGeneratorJobKey();
            String graphGuid = job.getGraphGuid();
            if (parentKey == null || graphGuid == null) {
                string2 = String.valueOf(String.valueOf(job));
                log.info(new StringBuilder(55 + string2.length()).append("Ignoring a non root job with no parent or graphGuid -> ").append(string2).toString());
                iter.remove();
                continue;
            }
            if (graphGuid.equals(jobToChildGuid.get(parentKey))) continue;
            string2 = String.valueOf(String.valueOf(job));
            string = String.valueOf(String.valueOf(jobs.get(parentKey)));
            log.info(new StringBuilder(34 + string2.length() + string.length()).append("Ignoring an orphand job ").append(string2).append(", parent: ").append(string).toString());
            iter.remove();
        }
        if (null == this.rootJob) {
            iter = String.valueOf(String.valueOf(rootJobKey));
            throw new IllegalArgumentException(new StringBuilder(44 + ((String)((Object)iter)).length()).append("None of the jobs were the root job with key ").append((String)((Object)iter)).toString());
        }
        iter = slots.values().iterator();
        while (iter.hasNext()) {
            Slot slot = (Slot)iter.next();
            parentKey = slot.getGeneratorJobKey();
            parentGuid = slot.getGraphGuid();
            if (parentKey == null && parentGuid == null || parentGuid != null && parentGuid.equals(jobToChildGuid.get(parentKey))) {
                slot.inflate(barriers);
                continue;
            }
            string2 = String.valueOf(String.valueOf(slot));
            string = String.valueOf(String.valueOf(jobs.get(parentKey)));
            log.info(new StringBuilder(35 + string2.length() + string.length()).append("Ignoring an orphand slot ").append(string2).append(", parent: ").append(string).toString());
            iter.remove();
        }
        iter = barriers.values().iterator();
        while (iter.hasNext()) {
            Barrier barrier = iter.next();
            parentKey = barrier.getGeneratorJobKey();
            parentGuid = barrier.getGraphGuid();
            if (parentKey == null && parentGuid == null || parentGuid != null && parentGuid.equals(jobToChildGuid.get(parentKey))) {
                barrier.inflate(slots);
                continue;
            }
            string2 = String.valueOf(String.valueOf(barrier));
            string = String.valueOf(String.valueOf(jobs.get(parentKey)));
            log.info(new StringBuilder(38 + string2.length() + string.length()).append("Ignoring an orphand Barrier ").append(string2).append(", parent: ").append(string).toString());
            iter.remove();
        }
        for (JobRecord jobRec : jobs.values()) {
            Barrier runBarrier = barriers.get(jobRec.getRunBarrierKey());
            Barrier finalizeBarrier = barriers.get(jobRec.getFinalizeBarrierKey());
            Slot outputSlot = slots.get(jobRec.getOutputSlotKey());
            JobInstanceRecord jobInstanceRecord = jobInstanceRecords.get(jobRec.getJobInstanceKey());
            ExceptionRecord failureRecord = null;
            Key failureKey = jobRec.getExceptionKey();
            if (null != failureKey) {
                failureRecord = failureRecords.get(failureKey);
            }
            jobRec.inflate(runBarrier, finalizeBarrier, outputSlot, jobInstanceRecord, failureRecord);
        }
    }
}

