/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.PipelineManager;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Slot
extends PipelineModelObject {
    public static final String DATA_STORE_KIND = "pipeline-slot";
    private static final String FILLED_PROPERTY = "filled";
    private static final String VALUE_PROPERTY = "value";
    private static final String WAITING_ON_ME_PROPERTY = "waitingOnMe";
    private static final String FILL_TIME_PROPERTY = "fillTime";
    private static final String SOURCE_JOB_KEY_PROPERTY = "sourceJob";
    private boolean filled;
    private Date fillTime;
    private Object value;
    private Key sourceJobKey;
    private final List<Key> waitingOnMeKeys;
    private List<Barrier> waitingOnMeInflated;
    private Object serializedVersion;

    public Slot(Key rootJobKey, Key generatorJobKey, String graphGUID) {
        super(rootJobKey, generatorJobKey, graphGUID);
        this.waitingOnMeKeys = new LinkedList<Key>();
    }

    public Slot(Entity entity) {
        this(entity, false);
    }

    public Slot(Entity entity, boolean lazy) {
        super(entity);
        this.filled = (Boolean)entity.getProperty(FILLED_PROPERTY);
        this.fillTime = (Date)entity.getProperty(FILL_TIME_PROPERTY);
        this.sourceJobKey = (Key)entity.getProperty(SOURCE_JOB_KEY_PROPERTY);
        this.waitingOnMeKeys = Slot.getListProperty(WAITING_ON_ME_PROPERTY, entity);
        if (lazy) {
            this.serializedVersion = entity.getProperty(VALUE_PROPERTY);
        } else {
            this.value = this.deserializeValue(entity.getProperty(VALUE_PROPERTY));
        }
    }

    private Object deserializeValue(Object serializedValue) {
        try {
            return PipelineManager.getBackEnd().deserializeValue(this, serializedValue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Entity toEntity() {
        Entity entity = this.toProtoEntity();
        entity.setUnindexedProperty(FILLED_PROPERTY, (Object)this.filled);
        if (null != this.fillTime) {
            entity.setUnindexedProperty(FILL_TIME_PROPERTY, (Object)this.fillTime);
        }
        if (null != this.sourceJobKey) {
            entity.setProperty(SOURCE_JOB_KEY_PROPERTY, (Object)this.sourceJobKey);
        }
        entity.setProperty(WAITING_ON_ME_PROPERTY, this.waitingOnMeKeys);
        if (this.serializedVersion != null) {
            entity.setUnindexedProperty(VALUE_PROPERTY, this.serializedVersion);
        } else {
            try {
                entity.setUnindexedProperty(VALUE_PROPERTY, PipelineManager.getBackEnd().serializeValue(this, this.value));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return entity;
    }

    @Override
    protected String getDatastoreKind() {
        return DATA_STORE_KIND;
    }

    public void inflate(Map<Key, Barrier> pool) {
        this.waitingOnMeInflated = Slot.buildInflated(this.waitingOnMeKeys, pool);
    }

    public void addWaiter(Barrier waiter) {
        this.waitingOnMeKeys.add(waiter.getKey());
        if (null == this.waitingOnMeInflated) {
            this.waitingOnMeInflated = new LinkedList<Barrier>();
        }
        this.waitingOnMeInflated.add(waiter);
    }

    public boolean isFilled() {
        return this.filled;
    }

    public Object getValue() {
        if (this.serializedVersion != null) {
            this.value = this.deserializeValue(this.serializedVersion);
            this.serializedVersion = null;
        }
        return this.value;
    }

    public Date getFillTime() {
        return this.fillTime;
    }

    public Key getSourceJobKey() {
        return this.sourceJobKey;
    }

    public void setSourceJobKey(Key key) {
        this.sourceJobKey = key;
    }

    public void fill(Object value) {
        this.filled = true;
        this.value = value;
        this.serializedVersion = null;
        this.fillTime = new Date();
    }

    public List<Key> getWaitingOnMeKeys() {
        return this.waitingOnMeKeys;
    }

    public List<Barrier> getWaitingOnMeInflated() {
        return this.waitingOnMeInflated;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(Slot.getKeyName(this.getKey())));
        String string2 = String.valueOf(String.valueOf(this.serializedVersion != null ? "..." : this.value));
        boolean bl = this.filled;
        String string3 = String.valueOf(String.valueOf(this.waitingOnMeKeys));
        String string4 = String.valueOf(String.valueOf(Slot.getKeyName(this.getGeneratorJobKey())));
        String string5 = String.valueOf(String.valueOf(this.getGraphGuid()));
        return new StringBuilder(58 + string.length() + string2.length() + string3.length() + string4.length() + string5.length()).append("Slot[").append(string).append(", value=").append(string2).append(", filled=").append(bl).append(", waitingOnMe=").append(string3).append(", parent=").append(string4).append(", guid=").append(string5).append("]").toString();
    }
}

