/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.servlets;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.JobInstanceRecord;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineObjects;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import com.google.appengine.tools.pipeline.impl.model.SlotDescriptor;
import com.google.appengine.tools.pipeline.impl.util.JsonUtils;
import com.google.appengine.tools.pipeline.util.Pair;
import com.google.common.base.Optional;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonGenerator {
    private static final String PIPELINE_ID = "pipelineId";
    private static final String ROOT_PIPELINE_ID = "rootPipelineId";
    private static final String SLOTS = "slots";
    private static final String PIPELINES = "pipelines";
    private static final String CURSOR = "cursor";
    private static final String SLOT_STATUS = "status";
    private static final String FILLED_STATUS = "filled";
    private static final String WAITING_STATUS = "waiting";
    private static final String SLOT_VALUE = "value";
    private static final String SLOT_FILL_TIME = "fillTimeMs";
    private static final String SLOT_SOURCE_JOB = "fillerPipelineId";
    private static final String JOB_CLASS = "classPath";
    private static final String JOB_STATUS = "status";
    private static final String RUN_STATUS = "run";
    private static final String DONE_STATUS = "done";
    private static final String ABORTED_STATUS = "aborted";
    private static final String RETRY_STATUS = "retry";
    private static final String CANCELED_STATUS = "canceled";
    private static final String JOB_START_TIME = "startTimeMs";
    private static final String JOB_END_TIME = "endTimeMs";
    private static final String JOB_CHILDREN = "children";
    private static final String JOB_ARGS = "args";
    private static final String JOB_OUTPUTS = "outputs";
    private static final String JOB_QUEUE_NAME = "queueName";
    private static final String JOB_AFTER_SLOT_KEYS = "afterSlotKeys";
    private static final String JOB_CURRENT_ATTEMPT = "currentAttempt";
    private static final String JOB_MAX_ATTEMPTS = "maxAttempts";
    private static final String JOB_BACKOFF_SECONDS = "backoffSeconds";
    private static final String JOB_BACKOFF_FACTOR = "backoffFactor";
    private static final String JOB_KWARGS = "kwargs";
    private static final String JOB_LAST_RETRY_MESSAGE = "lastRetryMessage";
    private static final String JOB_ABORT_MESSAGE = "abortMessage";
    private static final String DEFAULT_OUTPUT_NAME = "default";
    private static final String JOB_STATUS_CONSOLE_URL = "statusConsoleUrl";

    private static String toString(Key key) {
        return KeyFactory.keyToString((Key)key);
    }

    public static String pipelineRootsToJson(Pair<? extends Iterable<JobRecord>, String> pipelineRoots) {
        Map<String, Object> mapRepresentation = JsonGenerator.rootsToMapRepresentation(pipelineRoots);
        return JsonUtils.mapToJson(mapRepresentation);
    }

    public static String pipelineObjectsToJson(PipelineObjects pipelineObjects) {
        Map<String, Object> mapRepresentation = JsonGenerator.objectsToMapRepresentation(pipelineObjects);
        return JsonUtils.mapToJson(mapRepresentation);
    }

    private static Map<String, Object> objectsToMapRepresentation(PipelineObjects pipelineObjects) {
        HashMap<String, Map<String, Object>> slotMap = new HashMap<String, Map<String, Object>>(pipelineObjects.slots.size());
        HashMap<String, Map<String, Object>> jobMap = new HashMap<String, Map<String, Object>>(pipelineObjects.jobs.size());
        HashMap<String, Object> topLevel = new HashMap<String, Object>(4);
        topLevel.put(ROOT_PIPELINE_ID, pipelineObjects.rootJob.getKey().getName());
        topLevel.put(SLOTS, slotMap);
        topLevel.put(PIPELINES, jobMap);
        for (Slot slot : pipelineObjects.slots.values()) {
            slotMap.put(JsonGenerator.toString(slot.getKey()), JsonGenerator.buildMapRepresentation(slot));
        }
        for (JobRecord jobRecord : pipelineObjects.jobs.values()) {
            jobMap.put(jobRecord.getKey().getName(), JsonGenerator.buildMapRepresentation(jobRecord));
        }
        return topLevel;
    }

    private static Map<String, Object> rootsToMapRepresentation(Pair<? extends Iterable<JobRecord>, String> pipelineRoots) {
        LinkedList<Map<String, Object>> jobList = new LinkedList<Map<String, Object>>();
        HashMap<String, Object> topLevel = new HashMap<String, Object>(3);
        for (JobRecord rootRecord : pipelineRoots.getFirst()) {
            Map<String, Object> mapRepresentation = JsonGenerator.buildMapRepresentation(rootRecord);
            mapRepresentation.put(PIPELINE_ID, rootRecord.getKey().getName());
            jobList.add(mapRepresentation);
        }
        topLevel.put(PIPELINES, jobList);
        if (pipelineRoots.getSecond() != null) {
            topLevel.put(CURSOR, pipelineRoots.getSecond());
        }
        return topLevel;
    }

    private static Map<String, Object> buildMapRepresentation(Slot slot) {
        Key sourceJobKey;
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        String statusString = slot.isFilled() ? FILLED_STATUS : WAITING_STATUS;
        map.put("status", statusString);
        try {
            map.put(SLOT_VALUE, slot.getValue());
        }
        catch (RuntimeException ex) {
            map.put(SLOT_VALUE, ex);
        }
        Date fillTime = slot.getFillTime();
        if (null != fillTime) {
            map.put(SLOT_FILL_TIME, fillTime.getTime());
        }
        if (null != (sourceJobKey = slot.getSourceJobKey())) {
            map.put(SLOT_SOURCE_JOB, sourceJobKey.getName());
        }
        return map;
    }

    private static Map<String, Object> buildMapRepresentation(JobRecord jobRecord) {
        Date endTime;
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        String jobClass = jobRecord.getRootJobDisplayName();
        if (jobClass == null) {
            JobInstanceRecord jobInstanceInflated = jobRecord.getJobInstanceInflated();
            jobClass = null != jobInstanceInflated ? jobInstanceInflated.getJobDisplayName() : "";
        }
        map.put(JOB_CLASS, jobClass);
        String statusString = null;
        switch (jobRecord.getState()) {
            case WAITING_TO_RUN: {
                statusString = WAITING_STATUS;
                break;
            }
            case WAITING_TO_FINALIZE: {
                statusString = RUN_STATUS;
                break;
            }
            case FINALIZED: {
                statusString = DONE_STATUS;
                break;
            }
            case STOPPED: {
                statusString = ABORTED_STATUS;
                break;
            }
            case RETRY: {
                statusString = RETRY_STATUS;
                break;
            }
            case CANCELED: {
                statusString = CANCELED_STATUS;
                break;
            }
        }
        map.put("status", statusString);
        Date startTime = jobRecord.getStartTime();
        if (null != startTime) {
            map.put(JOB_START_TIME, startTime.getTime());
        }
        if (null != (endTime = jobRecord.getEndTime())) {
            map.put(JOB_END_TIME, endTime.getTime());
        }
        map.put(JOB_CHILDREN, JsonGenerator.buildArrayRepresentation(jobRecord.getChildKeys()));
        LinkedList<Map<String, Object>> argumentListRepresentation = new LinkedList<Map<String, Object>>();
        LinkedList<String> waitingOnRepresentation = new LinkedList<String>();
        Barrier runBarrierInflated = jobRecord.getRunBarrierInflated();
        if (runBarrierInflated != null) {
            JsonGenerator.populateJobArgumentRepresentation(argumentListRepresentation, waitingOnRepresentation, runBarrierInflated.getWaitingOnInflated());
        }
        map.put(JOB_ARGS, argumentListRepresentation);
        map.put(JOB_AFTER_SLOT_KEYS, waitingOnRepresentation);
        HashMap<String, String> allOutputs = new HashMap<String, String>();
        String outputSlotId = JsonGenerator.toString(jobRecord.getOutputSlotKey());
        allOutputs.put(DEFAULT_OUTPUT_NAME, outputSlotId);
        map.put(JOB_OUTPUTS, allOutputs);
        map.put(JOB_QUEUE_NAME, Optional.fromNullable((Object)jobRecord.getQueueSettings().getOnQueue()).or((Object)""));
        map.put(JOB_CURRENT_ATTEMPT, jobRecord.getAttemptNumber());
        map.put(JOB_MAX_ATTEMPTS, jobRecord.getMaxAttempts());
        map.put(JOB_BACKOFF_SECONDS, jobRecord.getBackoffSeconds());
        map.put(JOB_BACKOFF_FACTOR, jobRecord.getBackoffFactor());
        map.put(JOB_KWARGS, new HashMap());
        Throwable error = jobRecord.getException();
        if (error != null) {
            switch (jobRecord.getState()) {
                case STOPPED: 
                case CANCELED: {
                    map.put(JOB_ABORT_MESSAGE, error.getMessage());
                    break;
                }
                default: {
                    map.put(JOB_LAST_RETRY_MESSAGE, error.getMessage());
                }
            }
        }
        if (jobRecord.getStatusConsoleUrl() != null) {
            map.put(JOB_STATUS_CONSOLE_URL, jobRecord.getStatusConsoleUrl());
        }
        return map;
    }

    private static void populateJobArgumentRepresentation(List<Map<String, Object>> argumentListRepresentation, List<String> waitingOnRepresentation, List<SlotDescriptor> slotDescriptors) {
        for (SlotDescriptor slotDescriptor : slotDescriptors) {
            Slot slot = slotDescriptor.slot;
            String slotId = JsonGenerator.toString(slot.getKey());
            if (slotDescriptor.isPhantom()) {
                waitingOnRepresentation.add(slotId);
                continue;
            }
            argumentListRepresentation.add(JsonGenerator.buildArgumentRepresentation(slotDescriptor.slot));
        }
    }

    private static Map<String, Object> buildArgumentRepresentation(Slot slot) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (slot.isFilled()) {
            map.put("type", SLOT_VALUE);
            try {
                map.put(SLOT_VALUE, slot.getValue());
            }
            catch (RuntimeException ex) {
                map.put(SLOT_VALUE, ex);
            }
        } else {
            map.put("type", "slot");
            map.put("slot_key", JsonGenerator.toString(slot.getKey()));
        }
        return map;
    }

    private static String[] buildArrayRepresentation(List<Key> listOfKeys) {
        String[] arrayOfIds = new String[listOfKeys.size()];
        int i = 0;
        for (Key key : listOfKeys) {
            arrayOfIds[i++] = key.getName();
        }
        return arrayOfIds;
    }
}

