/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.servlets;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;

public class StaticContentHandler {
    private static Logger logger = Logger.getLogger(StaticContentHandler.class.getName());
    private static final int BUFFER_SIZE = 2048;
    private static final String UI_DIR = "ui/";
    private static final String INTERNAL_BUILD_UI_DIR = "/third_party/py/appengine_pipeline/src/pipeline/ui/";
    private static final String[][] RESOURCES = new String[][]{{"list", "root_list.html", "text/html"}, {"list.css", "root_list.css", "text/css"}, {"list.js", "root_list.js", "text/javascript"}, {"status.html", "status.html", "text/html"}, {"status", "status.html", "text/html"}, {"status.css", "status.css", "text/css"}, {"status.js", "status.js", "text/javascript"}, {"common.js", "common.js", "text/javascript"}, {"common.css", "common.css", "text/css"}, {"jquery-1.4.2.min.js", "jquery-1.4.2.min.js", "text/javascript"}, {"jquery.treeview.min.js", "jquery.treeview.min.js", "text/javascript"}, {"jquery.cookie.js", "jquery.cookie.js", "text/javascript"}, {"jquery.timeago.js", "jquery.timeago.js", "text/javascript"}, {"jquery.ba-hashchange.min.js", "jquery.ba-hashchange.min.js", "text/javascript"}, {"jquery.json.min.js", "jquery.json.min.js", "text/javascript"}, {"jquery.treeview.css", "jquery.treeview.css", "text/css"}, {"images/treeview-default.gif", "images/treeview-default.gif", "image/gif"}, {"images/treeview-default-line.gif", "images/treeview-default-line.gif", "image/gif"}, {"images/treeview-black.gif", "images/treeview-black.gif", "image/gif"}, {"images/treeview-black-line.gif", "images/treeview-black-line.gif", "image/gif"}};
    private static final Map<String, NameContentTypePair> RESOURCE_MAP;

    public static void doGet(HttpServletResponse resp, String path) throws ServletException {
        try {
            NameContentTypePair pair = RESOURCE_MAP.get(path);
            if (pair == null) {
                String string = String.valueOf(path);
                logger.warning(string.length() != 0 ? "Resource not found: ".concat(string) : new String("Resource not found: "));
                resp.setStatus(404);
                resp.getWriter().write("Resource not found.");
                resp.setContentType("text/plain");
                return;
            }
            String contentType = pair.contentType;
            resp.setContentType(contentType);
            resp.setStatus(200);
            resp.addHeader("Cache-Control", "public; max-age=300");
            try (InputStream in = StaticContentHandler.getResourceAsStream(pair.fileName);
                 ReadableByteChannel readChannel = Channels.newChannel(in);
                 WritableByteChannel writeChannel = Channels.newChannel((OutputStream)resp.getOutputStream());){
                ByteBuffer buffer = ByteBuffer.allocate(2048);
                while (true) {
                    buffer.clear();
                    if (-1 == readChannel.read(buffer)) {
                        break;
                    }
                    buffer.flip();
                    writeChannel.write(buffer);
                }
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static InputStream getResourceAsStream(String fileName) throws FileNotFoundException {
        String string = String.valueOf(UI_DIR);
        String string2 = String.valueOf(fileName);
        String localPath = string2.length() != 0 ? string.concat(string2) : new String(string);
        String string3 = String.valueOf(INTERNAL_BUILD_UI_DIR);
        String string4 = String.valueOf(fileName);
        String altLocalPath = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        InputStream in = StaticContentHandler.class.getResourceAsStream(localPath);
        if (in == null) {
            in = StaticContentHandler.class.getResourceAsStream(altLocalPath);
        }
        if (in == null) {
            String string5 = String.valueOf(String.valueOf(localPath));
            String string6 = String.valueOf(String.valueOf(altLocalPath));
            throw new FileNotFoundException(new StringBuilder(6 + string5.length() + string6.length()).append(string5).append(" <or> ").append(string6).toString());
        }
        return in;
    }

    static {
        HashMap<String, NameContentTypePair> map = new HashMap<String, NameContentTypePair>(RESOURCES.length + 1, 1.0f);
        for (String[] triple : RESOURCES) {
            String urlPath = triple[0];
            String fileName = triple[1];
            String contentType = triple[2];
            map.put(urlPath, new NameContentTypePair(fileName, contentType));
        }
        RESOURCE_MAP = Collections.unmodifiableMap(map);
    }

    private static class NameContentTypePair {
        public final String fileName;
        public final String contentType;

        public NameContentTypePair(String name, String type) {
            this.fileName = name;
            this.contentType = type;
        }
    }
}

