/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.servlets;

import com.google.appengine.tools.pipeline.impl.PipelineManager;
import com.google.appengine.tools.pipeline.impl.servlets.PipelineServlet;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import com.google.appengine.tools.pipeline.impl.util.StringUtils;
import com.google.apphosting.api.ApiProxy;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class TaskHandler {
    private static Logger logger = Logger.getLogger(TaskHandler.class.getName());
    public static final String PATH_COMPONENT = "handleTask";
    public static final String TASK_NAME_REQUEST_HEADER = "X-AppEngine-TaskName";
    public static final String TASK_RETRY_COUNT_HEADER = "X-AppEngine-TaskRetryCount";
    public static final String TASK_QUEUE_NAME_HEADER = "X-AppEngine-QueueName";

    public static String handleTaskUrl() {
        String string = String.valueOf(PipelineServlet.baseUrl());
        String string2 = String.valueOf(PATH_COMPONENT);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    public static void doPost(HttpServletRequest req) throws ServletException {
        int retryCount;
        Task task = TaskHandler.reconstructTask(req);
        try {
            retryCount = req.getIntHeader(TASK_RETRY_COUNT_HEADER);
        }
        catch (NumberFormatException e) {
            retryCount = -1;
        }
        try {
            PipelineManager.processTask(task);
        }
        catch (RuntimeException e) {
            StringUtils.logRetryMessage(logger, task, retryCount, e);
            throw new ServletException((Throwable)e);
        }
    }

    private static Task reconstructTask(HttpServletRequest request) {
        Properties properties = new Properties();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String paramValue = request.getParameter(paramName);
            properties.setProperty(paramName, paramValue);
        }
        String taskName = request.getHeader(TASK_NAME_REQUEST_HEADER);
        Task task = Task.fromProperties(taskName, properties);
        task.getQueueSettings().setDelayInSeconds(null);
        String queueName = request.getHeader(TASK_QUEUE_NAME_HEADER);
        if (queueName != null && !queueName.isEmpty()) {
            String onQueue = task.getQueueSettings().getOnQueue();
            if (onQueue == null || onQueue.isEmpty()) {
                task.getQueueSettings().setOnQueue(queueName);
            }
            Map attributes = ApiProxy.getCurrentEnvironment().getAttributes();
            attributes.put(TASK_QUEUE_NAME_HEADER, queueName);
        }
        return task;
    }
}

