/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.tasks;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import com.google.appengine.tools.pipeline.impl.tasks.ObjRefTask;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import java.util.Properties;

public class DelayedSlotFillTask
extends ObjRefTask {
    private static final String ROOT_JOB_KEY_PARAM = "rootJobKey";
    private final Key rootJobKey;

    public DelayedSlotFillTask(Slot slot, long delay, Key rootJobKey, QueueSettings queueSettings) {
        super(Task.Type.DELAYED_SLOT_FILL, "delayedSlotFillTask", slot.getKey(), queueSettings);
        this.getQueueSettings().setDelayInSeconds(delay);
        this.rootJobKey = rootJobKey;
    }

    protected DelayedSlotFillTask(Task.Type type, String taskName, Properties properties) {
        super(type, taskName, properties);
        this.rootJobKey = KeyFactory.stringToKey((String)properties.getProperty(ROOT_JOB_KEY_PARAM));
    }

    @Override
    protected void addProperties(Properties properties) {
        super.addProperties(properties);
        properties.setProperty(ROOT_JOB_KEY_PARAM, KeyFactory.keyToString((Key)this.rootJobKey));
    }

    @Override
    public String propertiesAsString() {
        String string = String.valueOf(String.valueOf(super.propertiesAsString()));
        String string2 = String.valueOf(String.valueOf(this.rootJobKey));
        return new StringBuilder(13 + string.length() + string2.length()).append(string).append(", rootJobKey=").append(string2).toString();
    }

    public Key getSlotKey() {
        return this.getKey();
    }

    public Key getRootJobKey() {
        return this.rootJobKey;
    }
}

