/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.tasks;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import com.google.appengine.tools.pipeline.impl.util.GUIDGenerator;
import com.google.appengine.tools.pipeline.impl.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class FanoutTask
extends Task {
    private static final String KEY_VALUE_SEPERATOR = "::";
    private static final String PROPERTY_SEPERATOR = ",,";
    private static final String TASK_NAME_DELIMITTER = "--";
    private static final String TASK_SEPERATOR = ";;";
    private static final String RECORD_KEY_PROPERTY = "recordKey";
    private final Key recordKey;

    public FanoutTask(Key recordKey, QueueSettings queueSettings) {
        super(Task.Type.FAN_OUT, null, queueSettings.clone());
        this.recordKey = recordKey;
    }

    public FanoutTask(Task.Type type, String taskName, Properties properties) {
        super(type, taskName, properties);
        this.recordKey = KeyFactory.stringToKey((String)properties.getProperty(RECORD_KEY_PROPERTY));
    }

    @Override
    protected void addProperties(Properties properties) {
        properties.setProperty(RECORD_KEY_PROPERTY, KeyFactory.keyToString((Key)this.recordKey));
    }

    public Key getRecordKey() {
        return this.recordKey;
    }

    public static byte[] encodeTasks(Collection<? extends Task> taskList) {
        if (taskList.isEmpty()) {
            return new byte[0];
        }
        StringBuilder builder = new StringBuilder(1024);
        for (Task task : taskList) {
            FanoutTask.encodeTask(builder, task);
            builder.append(TASK_SEPERATOR);
        }
        builder.setLength(builder.length() - TASK_SEPERATOR.length());
        return builder.toString().getBytes(StringUtils.UTF_8);
    }

    private static void encodeTask(StringBuilder builder, Task task) {
        String taskName = GUIDGenerator.nextGUID();
        builder.append(taskName);
        builder.append(TASK_NAME_DELIMITTER);
        Properties taskProps = task.toProperties();
        if (!taskProps.isEmpty()) {
            for (String propName : taskProps.stringPropertyNames()) {
                String value = taskProps.getProperty(propName);
                builder.append(propName).append(KEY_VALUE_SEPERATOR).append(value);
                builder.append(PROPERTY_SEPERATOR);
            }
            builder.setLength(builder.length() - PROPERTY_SEPERATOR.length());
        }
    }

    public static List<Task> decodeTasks(byte[] encodedBytes) {
        String encodedListOfTasks = new String(encodedBytes, StringUtils.UTF_8);
        String[] encodedTaskArray = encodedListOfTasks.split(TASK_SEPERATOR);
        ArrayList<Task> listOfTasks = new ArrayList<Task>(encodedTaskArray.length);
        for (String encodedTask : encodedTaskArray) {
            String[] nameAndProperties = encodedTask.split(TASK_NAME_DELIMITTER);
            String taskName = nameAndProperties[0];
            String encodedProperties = nameAndProperties[1];
            String[] encodedPropertyArray = encodedProperties.split(PROPERTY_SEPERATOR);
            Properties taskProperties = new Properties();
            for (String encodedProperty : encodedPropertyArray) {
                String[] keyValuePair = encodedProperty.split(KEY_VALUE_SEPERATOR);
                String key = keyValuePair[0];
                String value = keyValuePair[1];
                taskProperties.setProperty(key, value);
            }
            Task task = Task.fromProperties(taskName, taskProperties);
            listOfTasks.add(task);
        }
        return listOfTasks;
    }

    @Override
    public String propertiesAsString() {
        String string = String.valueOf(String.valueOf(this.recordKey));
        return new StringBuilder(4 + string.length()).append("key=").append(string).toString();
    }
}

