/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.tasks;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import java.util.Properties;

public abstract class ObjRefTask
extends Task {
    private static final String KEY_PARAM = "key";
    private final Key key;

    protected ObjRefTask(Task.Type type, String namePrefix, Key key, QueueSettings queueSettings) {
        super(type, ObjRefTask.createTaskName(namePrefix, key), queueSettings.clone());
        this.key = key;
    }

    private static String createTaskName(String namePrefix, Key key) {
        if (null == key) {
            throw new IllegalArgumentException("key is null.");
        }
        if (namePrefix == null) {
            throw new IllegalArgumentException("namePrix is null.");
        }
        String string = String.valueOf(namePrefix);
        String string2 = String.valueOf(KeyFactory.keyToString((Key)key));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    protected ObjRefTask(Task.Type type, String taskName, Properties properties) {
        super(type, taskName, properties);
        this.key = KeyFactory.stringToKey((String)properties.getProperty(KEY_PARAM));
    }

    public Key getKey() {
        return this.key;
    }

    @Override
    protected void addProperties(Properties properties) {
        String keyString = KeyFactory.keyToString((Key)this.key);
        properties.setProperty(KEY_PARAM, keyString);
    }

    @Override
    public String propertiesAsString() {
        String string = String.valueOf(String.valueOf(this.key));
        return new StringBuilder(4 + string.length()).append("key=").append(string).toString();
    }
}

