/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.tasks;

import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.tasks.CancelJobTask;
import com.google.appengine.tools.pipeline.impl.tasks.DelayedSlotFillTask;
import com.google.appengine.tools.pipeline.impl.tasks.DeletePipelineTask;
import com.google.appengine.tools.pipeline.impl.tasks.FanoutTask;
import com.google.appengine.tools.pipeline.impl.tasks.FinalizeJobTask;
import com.google.appengine.tools.pipeline.impl.tasks.HandleChildExceptionTask;
import com.google.appengine.tools.pipeline.impl.tasks.HandleSlotFilledTask;
import com.google.appengine.tools.pipeline.impl.tasks.RunJobTask;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;

public abstract class Task {
    protected static final String TASK_TYPE_PARAMETER = "taskType";
    private final Type type;
    private final String taskName;
    private final QueueSettings queueSettings;

    protected Task(Type type, String taskName, QueueSettings queueSettings) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (queueSettings == null) {
            throw new IllegalArgumentException("queueSettings must not be null");
        }
        this.type = type;
        this.taskName = taskName;
        this.queueSettings = queueSettings;
    }

    protected Task(Type type, String taskName, Properties properties) {
        this(type, taskName, new QueueSettings());
        for (TaskProperty taskProperty : TaskProperty.ALL) {
            taskProperty.applyFrom(this, properties);
        }
    }

    public static Task fromProperties(String taskName, Properties properties) {
        String taskTypeString = properties.getProperty(TASK_TYPE_PARAMETER);
        if (null == taskTypeString) {
            String string = String.valueOf("taskType property is missing: ");
            String string2 = String.valueOf(properties.toString());
            throw new IllegalArgumentException(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        Type type = Type.valueOf(taskTypeString);
        return type.createInstance(taskName, properties);
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.taskName;
    }

    public QueueSettings getQueueSettings() {
        return this.queueSettings;
    }

    public final Properties toProperties() {
        Properties properties = new Properties();
        properties.setProperty(TASK_TYPE_PARAMETER, this.type.toString());
        for (TaskProperty taskProperty : TaskProperty.ALL) {
            taskProperty.addTo(this, properties);
        }
        this.addProperties(properties);
        return properties;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf((Object)this.getType()));
        String string2 = String.valueOf(String.valueOf(this.getName()));
        String string3 = String.valueOf(String.valueOf(this.getQueueSettings()));
        String value = new StringBuilder(27 + string.length() + string2.length() + string3.length()).append(string).append("_TASK[name=").append(string2).append(", queueSettings=").append(string3).toString();
        String extraProperties = this.propertiesAsString();
        if (extraProperties != null && !extraProperties.isEmpty()) {
            String string4 = String.valueOf(value);
            String string5 = String.valueOf(String.valueOf(extraProperties));
            value = new StringBuilder(2 + string4.length() + string5.length()).append(string4).append(", ").append(string5).toString();
        }
        return String.valueOf(value).concat("]");
    }

    protected abstract String propertiesAsString();

    protected abstract void addProperties(Properties var1);

    public static enum Type {
        HANDLE_SLOT_FILLED(HandleSlotFilledTask.class),
        RUN_JOB(RunJobTask.class),
        HANDLE_CHILD_EXCEPTION(HandleChildExceptionTask.class),
        CANCEL_JOB(CancelJobTask.class),
        FINALIZE_JOB(FinalizeJobTask.class),
        FAN_OUT(FanoutTask.class),
        DELETE_PIPELINE(DeletePipelineTask.class),
        DELAYED_SLOT_FILL(DelayedSlotFillTask.class),
        FILL_SLOT_HANDLE_SLOT_FILLED(DelayedSlotFillTask.class);

        private final Constructor<? extends Task> taskConstructor;

        private Type(Class<? extends Task> taskClass) {
            try {
                this.taskConstructor = taskClass.getDeclaredConstructor(((Object)((Object)this)).getClass(), String.class, Properties.class);
                this.taskConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException e) {
                String string2 = String.valueOf(String.valueOf(taskClass));
                throw new RuntimeException(new StringBuilder(19 + string2.length()).append("Invalid Task class ").append(string2).toString(), e);
            }
        }

        public Task createInstance(String taskName, Properties properties) {
            try {
                return this.taskConstructor.newInstance(new Object[]{this, taskName, properties});
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                String string = String.valueOf(String.valueOf(this.taskConstructor.getDeclaringClass()));
                throw new RuntimeException(new StringBuilder(53 + string.length()).append("Unexpected exception while creating new instance for ").append(string).toString(), e);
            }
        }
    }

    private static enum TaskProperty {
        ON_BACKEND{

            @Override
            void setProperty(Task task, String value) {
                task.getQueueSettings().setOnBackend(value);
            }

            @Override
            String getProperty(Task task) {
                return task.getQueueSettings().getOnBackend();
            }
        }
        ,
        ON_MODULE{

            @Override
            void setProperty(Task task, String value) {
                task.getQueueSettings().setOnModule(value);
            }

            @Override
            String getProperty(Task task) {
                return task.getQueueSettings().getOnModule();
            }
        }
        ,
        MODULE_VERSION{

            @Override
            void setProperty(Task task, String value) {
                task.getQueueSettings().setModuleVersion(value);
            }

            @Override
            String getProperty(Task task) {
                return task.getQueueSettings().getModuleVersion();
            }
        }
        ,
        ON_QUEUE{

            @Override
            void setProperty(Task task, String value) {
                task.getQueueSettings().setOnQueue(value);
            }

            @Override
            String getProperty(Task task) {
                return task.getQueueSettings().getOnQueue();
            }
        }
        ,
        DELAY{

            @Override
            void setProperty(Task task, String value) {
                if (value != null) {
                    task.getQueueSettings().setDelayInSeconds(Long.parseLong(value));
                }
            }

            @Override
            String getProperty(Task task) {
                Long delay = task.getQueueSettings().getDelayInSeconds();
                return delay == null ? null : delay.toString();
            }
        };

        static final Set<TaskProperty> ALL;

        abstract void setProperty(Task var1, String var2);

        abstract String getProperty(Task var1);

        void applyFrom(Task task, Properties properties) {
            String value = properties.getProperty(this.name());
            if (value != null) {
                this.setProperty(task, value);
            }
        }

        void addTo(Task task, Properties properties) {
            String value = this.getProperty(task);
            if (value != null) {
                properties.setProperty(this.name(), value);
            }
        }

        static {
            ALL = EnumSet.allOf(TaskProperty.class);
        }
    }
}

