/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    public static String mapToJson(Map<?, ?> map) {
        try {
            return new JSONObject(map).toString(2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String toJson(Object x) {
        try {
            if (x == null || x instanceof String || x instanceof Number || x instanceof Character || x.getClass().isArray() || x instanceof Iterable) {
                return new JSONObject().put("JSON", x).toString(2);
            }
            if (x instanceof Map) {
                return new JSONObject((Map)x).toString(2);
            }
            if (x instanceof JSONObject) {
                return ((JSONObject)x).toString(2);
            }
            return new JSONObject(x).toString(2);
        }
        catch (Exception e) {
            String string = String.valueOf(String.valueOf(x));
            throw new RuntimeException(new StringBuilder(2 + string.length()).append("x=").append(string).toString(), e);
        }
    }

    public static Object fromJson(String json) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("JSON")) {
                return JsonUtils.convert(jsonObject.get("JSON"));
            }
            return JsonUtils.convert(jsonObject);
        }
        catch (Exception e) {
            String string = String.valueOf(json);
            throw new RuntimeException(string.length() != 0 ? "json=".concat(string) : new String("json="), e);
        }
    }

    private static Object convert(Object x) throws JSONException {
        if (x instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)x;
            String[] names = JSONObject.getNames((JSONObject)jsonObject);
            if (names == null || names.length == 0) {
                return new HashMap(0);
            }
            HashMap<String, Object> map = new HashMap<String, Object>(names.length);
            for (String name : names) {
                Object value = jsonObject.get(name);
                map.put(name, JsonUtils.convert(value));
            }
            return map;
        }
        if (x instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)x;
            int length = jsonArray.length();
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(JsonUtils.convert(jsonArray.get(i)));
            }
            return list;
        }
        return x;
    }

    private static String recursiveToString(Object y) {
        StringBuilder builder = new StringBuilder(512);
        if (null == y) {
            builder.append("null");
        } else if (y instanceof List) {
            List list = (List)y;
            builder.append("(");
            boolean first = true;
            for (Object x : list) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(JsonUtils.recursiveToString(x));
                first = false;
            }
            builder.append(")");
        } else if (y instanceof Map) {
            Map map = (Map)y;
            builder.append("{");
            boolean first = true;
            for (Object key : map.keySet()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(key);
                builder.append("=");
                builder.append(JsonUtils.recursiveToString(map.get(key)));
                first = false;
            }
            builder.append("}");
        } else if (y instanceof String) {
            builder.append('\"');
            builder.append(y);
            builder.append('\"');
        } else {
            builder.append(y);
        }
        return builder.toString();
    }

    private static void debugPrint(Object x) {
        System.out.println();
        String json = JsonUtils.toJson(x);
        Object y = JsonUtils.fromJson(json);
        String string = String.valueOf(String.valueOf(x));
        String string2 = String.valueOf(String.valueOf(json));
        String string3 = String.valueOf(String.valueOf(JsonUtils.recursiveToString(y)));
        System.out.println(new StringBuilder(10 + string.length() + string2.length() + string3.length()).append(string).append(" --> ").append(string2).append(" --> ").append(string3).toString());
    }

    public static void main(String[] args) throws Exception {
        JSONObject x = new JSONObject();
        x.put("first", 5);
        x.put("second", 7);
        JsonUtils.debugPrint("hello");
        JsonUtils.debugPrint(7);
        JsonUtils.debugPrint(3.14159);
        JsonUtils.debugPrint("");
        JsonUtils.debugPrint(Character.valueOf('x'));
        JsonUtils.debugPrint(x);
        JsonUtils.debugPrint(null);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("first", 5);
        map.put("second", 7);
        JsonUtils.debugPrint(map);
        int[] array = new int[]{5, 7};
        JsonUtils.debugPrint(array);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(5);
        arrayList.add(7);
        JsonUtils.debugPrint(arrayList);
        HashSet<Integer> collection = new HashSet<Integer>(2);
        collection.add(5);
        collection.add(7);
        JsonUtils.debugPrint(collection);
        Object object = new Object();
        JsonUtils.debugPrint(object);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("a", "hello");
        map1.put("b", "goodbye");
        Object[] array2 = new Object[]{17, "yes", "no", map1};
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("first", 5.4);
        map2.put("second", array2);
        map2.put("third", map1);
        JsonUtils.debugPrint(map2);
        class MyBean {
            MyBean() {
            }

            public int getX() {
                return 11;
            }

            public boolean isHot() {
                return true;
            }

            public String getName() {
                return "yellow";
            }
        }
        JsonUtils.debugPrint(new MyBean());
    }
}

