/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class SerializationUtils {
    private static final int MAX_UNCOMPRESSED_BYTE_SIZE = 1000000;
    private static final int ZLIB_COMPRESSION = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object x) throws IOException {
        InternalByteArrayOutputStream bytes = new InternalByteArrayOutputStream(512);
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(x);
        }
        if (bytes.size() <= 1000000) {
            return bytes.toByteArray();
        }
        ByteArrayOutputStream compressedBytes = new ByteArrayOutputStream(bytes.size() / 4);
        compressedBytes.write(0);
        compressedBytes.write(1);
        Deflater deflater = new Deflater(9, true);
        try (DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)compressedBytes, deflater);){
            out.write(bytes.getInternalBuffer(), 0, bytes.size());
        }
        finally {
            deflater.end();
        }
        return compressedBytes.toByteArray();
    }

    public static Object deserialize(byte[] bytes) throws IOException {
        if (bytes.length < 2) {
            throw new IOException("Invalid bytes content");
        }
        InputStream in = new ByteArrayInputStream(bytes);
        if (bytes[0] == 0) {
            ((InputStream)in).read();
            if (((InputStream)in).read() != 1) {
                throw new IOException("Unknown compression type");
            }
            final Inflater inflater = new Inflater(true);
            in = new InflaterInputStream(in, inflater){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        inflater.end();
                    }
                }
            };
        }
        Throwable throwable = null;
        try (ObjectInputStream oin = new ObjectInputStream(in);){
            Object object = oin.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            try {
                throw new IOException("Exception while deserilaizing.", e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static class InternalByteArrayOutputStream
    extends ByteArrayOutputStream {
        public InternalByteArrayOutputStream(int size) {
            super(size);
        }

        private byte[] getInternalBuffer() {
            return this.buf;
        }
    }
}

