/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.util;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static String printStackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static String toString(Object x) {
        if (x instanceof Key) {
            return ((Key)x).getName();
        }
        return x == null ? "null" : x.toString();
    }

    public static String toString(Object[] array) {
        StringBuilder builder = new StringBuilder(1024);
        builder.append('[');
        for (Object x : array) {
            builder.append(StringUtils.toString(x));
            builder.append(", ");
        }
        if (array.length > 0) {
            builder.setLength(builder.length() - 2);
        }
        builder.append(']');
        return builder.toString();
    }

    public static <E, F> String toStringParallel(List<E> listA, List<F> listB) {
        if (listA.size() != listB.size()) {
            throw new IllegalArgumentException("The two lists must have the same length.");
        }
        StringBuilder builder = new StringBuilder(1024);
        builder.append('<');
        int i = 0;
        for (E x : listA) {
            F y = listB.get(i++);
            if (i > 1) {
                builder.append(", ");
            }
            builder.append('(').append(StringUtils.toString(x)).append(',').append(StringUtils.toString(y)).append(')');
        }
        builder.append('>');
        return builder.toString();
    }

    public static void logRetryMessage(Logger logger, Task task, int retryCount, Exception e) {
        String string = String.valueOf(String.valueOf(task));
        int n = retryCount;
        String message = new StringBuilder(41 + string.length()).append("Will retry task: ").append(string).append(". retryCount=").append(n).toString();
        if (e instanceof ConcurrentModificationException) {
            String string2 = String.valueOf(String.valueOf(message));
            String string3 = String.valueOf(String.valueOf(e.getMessage()));
            logger.log(Level.INFO, new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(" ").append(string3).toString());
        } else {
            logger.log(Level.INFO, message, e);
        }
    }
}

