/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.taskqueue.TaskAlreadyExistsException;
import com.google.appengine.tools.pipeline.FutureList;
import com.google.appengine.tools.pipeline.ImmediateValue;
import com.google.appengine.tools.pipeline.Job;
import com.google.appengine.tools.pipeline.Job0;
import com.google.appengine.tools.pipeline.JobSetting;
import com.google.appengine.tools.pipeline.NoSuchObjectException;
import com.google.appengine.tools.pipeline.OrphanedObjectException;
import com.google.appengine.tools.pipeline.Value;
import com.google.appengine.tools.pipeline.impl.FutureValueImpl;
import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.backend.AppEngineBackEnd;
import com.google.appengine.tools.pipeline.impl.backend.PipelineBackEnd;
import com.google.appengine.tools.pipeline.impl.backend.UpdateSpec;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.ExceptionRecord;
import com.google.appengine.tools.pipeline.impl.model.JobInstanceRecord;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import com.google.appengine.tools.pipeline.impl.model.PipelineObjects;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import com.google.appengine.tools.pipeline.impl.model.SlotDescriptor;
import com.google.appengine.tools.pipeline.impl.servlets.PipelineServlet;
import com.google.appengine.tools.pipeline.impl.tasks.CancelJobTask;
import com.google.appengine.tools.pipeline.impl.tasks.DeletePipelineTask;
import com.google.appengine.tools.pipeline.impl.tasks.FanoutTask;
import com.google.appengine.tools.pipeline.impl.tasks.FillSlotHandleSlotFilledTask;
import com.google.appengine.tools.pipeline.impl.tasks.FinalizeJobTask;
import com.google.appengine.tools.pipeline.impl.tasks.HandleChildExceptionTask;
import com.google.appengine.tools.pipeline.impl.tasks.HandleSlotFilledTask;
import com.google.appengine.tools.pipeline.impl.tasks.ObjRefTask;
import com.google.appengine.tools.pipeline.impl.tasks.RunJobTask;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import com.google.appengine.tools.pipeline.impl.util.GUIDGenerator;
import com.google.appengine.tools.pipeline.impl.util.StringUtils;
import com.google.appengine.tools.pipeline.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PipelineManager {
    private static final Logger logger = Logger.getLogger(PipelineManager.class.getName());
    private static PipelineBackEnd backEnd = new AppEngineBackEnd();

    public static String startNewPipeline(JobSetting[] settings, Job<?> jobInstance, Object ... params) {
        UpdateSpec updateSpec = new UpdateSpec(null);
        RootJobInstance rootJobInstance = jobInstance;
        if (JobRecord.isExceptionHandlerSpecified(jobInstance)) {
            rootJobInstance = new RootJobInstance(jobInstance, settings, params);
            params = new Object[]{};
        }
        JobRecord jobRecord = PipelineManager.registerNewJobRecord(updateSpec, settings, null, null, rootJobInstance, params);
        updateSpec.setRootJobKey(jobRecord.getRootJobKey());
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
        return jobRecord.getKey().getName();
    }

    public static JobRecord registerNewJobRecord(UpdateSpec updateSpec, JobSetting[] settings, JobRecord generatorJob, String graphGUID, Job<?> jobInstance, Object[] params) {
        JobRecord jobRecord;
        if (generatorJob == null) {
            if (graphGUID != null) {
                throw new IllegalArgumentException("graphGUID must be null for root jobs");
            }
            jobRecord = JobRecord.createRootJobRecord(jobInstance, settings);
        } else {
            jobRecord = new JobRecord(generatorJob, graphGUID, jobInstance, false, settings);
        }
        return PipelineManager.registerNewJobRecord(updateSpec, jobRecord, params);
    }

    public static JobRecord registerNewJobRecord(UpdateSpec updateSpec, JobRecord jobRecord, Object[] params) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("registerNewJobRecord job(\"" + jobRecord + "\")");
        }
        updateSpec.setRootJobKey(jobRecord.getRootJobKey());
        Key generatorKey = jobRecord.getGeneratorJobKey();
        String graphGuid = jobRecord.getGraphGuid();
        for (Object param : params) {
            Value<Object> value = null != param && param instanceof Value ? (Value)param : new ImmediateValue<Object>(param);
            PipelineManager.registerSlotsWithBarrier(updateSpec, value, jobRecord.getRootJobKey(), generatorKey, jobRecord.getQueueSettings(), graphGuid, jobRecord.getRunBarrierInflated());
        }
        if (0 == jobRecord.getRunBarrierInflated().getWaitingOnKeys().size()) {
            Slot slot = new Slot(jobRecord.getRootJobKey(), generatorKey, graphGuid);
            jobRecord.getRunBarrierInflated().addPhantomArgumentSlot(slot);
            PipelineManager.registerSlotFilled(updateSpec, jobRecord.getQueueSettings(), slot, null);
        }
        UpdateSpec.Group updateGroup = updateSpec.getNonTransactionalGroup();
        updateGroup.includeBarrier(jobRecord.getRunBarrierInflated());
        updateGroup.includeBarrier(jobRecord.getFinalizeBarrierInflated());
        updateGroup.includeSlot(jobRecord.getOutputSlotInflated());
        updateGroup.includeJob(jobRecord);
        updateGroup.includeJobInstanceRecord(jobRecord.getJobInstanceInflated());
        return jobRecord;
    }

    private static void registerSlotsWithBarrier(UpdateSpec updateSpec, Value<?> value, Key rootJobKey, Key generatorJobKey, QueueSettings queueSettings, String graphGUID, Barrier barrier) {
        if (null == value || value instanceof ImmediateValue) {
            Object concreteValue = null;
            if (null != value) {
                ImmediateValue iv = (ImmediateValue)value;
                concreteValue = iv.getValue();
            }
            Slot slot = new Slot(rootJobKey, generatorJobKey, graphGUID);
            PipelineManager.registerSlotFilled(updateSpec, queueSettings, slot, concreteValue);
            barrier.addRegularArgumentSlot(slot);
        } else if (value instanceof FutureValueImpl) {
            FutureValueImpl futureValue = (FutureValueImpl)value;
            Slot slot = futureValue.getSlot();
            barrier.addRegularArgumentSlot(slot);
            updateSpec.getNonTransactionalGroup().includeSlot(slot);
        } else if (value instanceof FutureList) {
            FutureList futureList = (FutureList)value;
            ArrayList<Slot> slotList = new ArrayList<Slot>(futureList.getListOfValues().size());
            Slot dummyListSlot = new Slot(rootJobKey, generatorJobKey, graphGUID);
            PipelineManager.registerSlotFilled(updateSpec, queueSettings, dummyListSlot, null);
            for (Value valFromList : futureList.getListOfValues()) {
                Slot slot = null;
                if (valFromList instanceof ImmediateValue) {
                    ImmediateValue ivFromList = (ImmediateValue)valFromList;
                    slot = new Slot(rootJobKey, generatorJobKey, graphGUID);
                    PipelineManager.registerSlotFilled(updateSpec, queueSettings, slot, ivFromList.getValue());
                } else if (valFromList instanceof FutureValueImpl) {
                    FutureValueImpl futureValFromList = (FutureValueImpl)valFromList;
                    slot = futureValFromList.getSlot();
                } else {
                    if (value instanceof FutureList) {
                        throw new IllegalArgumentException("The Pipeline framework does not currently support FutureLists of FutureLists");
                    }
                    PipelineManager.throwUnrecognizedValueException(valFromList);
                }
                slotList.add(slot);
                updateSpec.getNonTransactionalGroup().includeSlot(slot);
            }
            barrier.addListArgumentSlots(dummyListSlot, slotList);
        } else {
            PipelineManager.throwUnrecognizedValueException(value);
        }
    }

    private static void throwUnrecognizedValueException(Value<?> value) {
        throw new RuntimeException("Internal logic error: Unrecognized implementation of Value interface: " + value.getClass().getName());
    }

    private static void registerSlotFilled(UpdateSpec updateSpec, QueueSettings queueSettings, Slot slot, Object value) {
        slot.fill(value);
        updateSpec.getNonTransactionalGroup().includeSlot(slot);
        HandleSlotFilledTask task = new HandleSlotFilledTask(slot.getKey(), queueSettings);
        updateSpec.getFinalTransaction().registerTask(task);
    }

    public static PipelineObjects queryFullPipeline(String rootJobHandle) {
        Key rootJobKey = KeyFactory.createKey((String)"pipeline-job", (String)rootJobHandle);
        return backEnd.queryFullPipeline(rootJobKey);
    }

    public static Pair<? extends Iterable<JobRecord>, String> queryRootPipelines(String classFilter, String cursor, int limit) {
        return backEnd.queryRootPipelines(classFilter, cursor, limit);
    }

    public static Set<String> getRootPipelinesDisplayName() {
        return backEnd.getRootPipelinesDisplayName();
    }

    private static void checkNonEmpty(String s, String name) {
        if (null == s || s.trim().length() == 0) {
            throw new IllegalArgumentException(name + " is empty.");
        }
    }

    public static JobRecord getJob(String jobHandle) throws NoSuchObjectException {
        PipelineManager.checkNonEmpty(jobHandle, "jobHandle");
        Key key = KeyFactory.createKey((String)"pipeline-job", (String)jobHandle);
        logger.finest("getJob: " + key.getName());
        return backEnd.queryJob(key, JobRecord.InflationType.FOR_OUTPUT);
    }

    public static void stopJob(String jobHandle) throws NoSuchObjectException {
        PipelineManager.checkNonEmpty(jobHandle, "jobHandle");
        Key key = KeyFactory.createKey((String)"pipeline-job", (String)jobHandle);
        JobRecord jobRecord = backEnd.queryJob(key, JobRecord.InflationType.NONE);
        jobRecord.setState(JobRecord.State.STOPPED);
        UpdateSpec updateSpec = new UpdateSpec(jobRecord.getRootJobKey());
        updateSpec.getOrCreateTransaction("stopJob").includeJob(jobRecord);
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
    }

    public static void cancelJob(String jobHandle) throws NoSuchObjectException {
        PipelineManager.checkNonEmpty(jobHandle, "jobHandle");
        Key key = KeyFactory.createKey((String)"pipeline-job", (String)jobHandle);
        JobRecord jobRecord = backEnd.queryJob(key, JobRecord.InflationType.NONE);
        CancelJobTask cancelJobTask = new CancelJobTask(key, jobRecord.getQueueSettings());
        try {
            backEnd.enqueue(cancelJobTask);
        }
        catch (TaskAlreadyExistsException e) {
            // empty catch block
        }
    }

    public static void deletePipelineRecords(String pipelineHandle, boolean force, boolean async) throws NoSuchObjectException, IllegalStateException {
        PipelineManager.checkNonEmpty(pipelineHandle, "pipelineHandle");
        Key key = KeyFactory.createKey((String)"pipeline-job", (String)pipelineHandle);
        backEnd.deletePipeline(key, force, async);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void acceptPromisedValue(String promiseHandle, Object value) throws NoSuchObjectException, OrphanedObjectException {
        PipelineManager.checkNonEmpty(promiseHandle, "promiseHandle");
        Key key = KeyFactory.stringToKey((String)promiseHandle);
        PipelineModelObject slot = null;
        int attempts = 0;
        boolean interrupted = false;
        try {
            while (slot == null) {
                ++attempts;
                try {
                    slot = backEnd.querySlot(key, false);
                }
                catch (NoSuchObjectException e) {
                    if (attempts >= 5) {
                        throw new NoSuchObjectException("There is no promise with handle " + promiseHandle);
                    }
                    try {
                        Thread.sleep((long)Math.pow(2.0, attempts - 1) * 1000L);
                    }
                    catch (InterruptedException f) {
                        interrupted = true;
                    }
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        Key generatorJobKey = slot.getGeneratorJobKey();
        if (null == generatorJobKey) {
            throw new RuntimeException("Pipeline is fatally corrupted. Slot for promised value has no generatorJobKey: " + slot);
        }
        JobRecord generatorJob = backEnd.queryJob(generatorJobKey, JobRecord.InflationType.NONE);
        if (null == generatorJob) {
            throw new RuntimeException("Pipeline is fatally corrupted. The generator job for a promised value slot was not found: " + generatorJobKey);
        }
        String childGraphGuid = generatorJob.getChildGraphGuid();
        if (null == childGraphGuid) {
            throw new NoSuchObjectException("The framework is not ready to accept the promised value yet. Please try again after the job that generated the promis handle has completed.");
        }
        if (!childGraphGuid.equals(slot.getGraphGuid())) {
            throw new OrphanedObjectException(promiseHandle);
        }
        UpdateSpec updateSpec = new UpdateSpec(slot.getRootJobKey());
        PipelineManager.registerSlotFilled(updateSpec, generatorJob.getQueueSettings(), (Slot)slot, value);
        backEnd.save(updateSpec, generatorJob.getQueueSettings());
    }

    public static void processTask(Task task) {
        logger.finest("Processing task " + task);
        try {
            switch (task.getType()) {
                case RUN_JOB: {
                    RunJobTask runJobTask = (RunJobTask)task;
                    PipelineManager.runJob(runJobTask.getJobKey());
                    break;
                }
                case HANDLE_SLOT_FILLED: {
                    HandleSlotFilledTask hsfTask = (HandleSlotFilledTask)task;
                    PipelineManager.handleSlotFilled(hsfTask.getSlotKey());
                    break;
                }
                case FINALIZE_JOB: {
                    FinalizeJobTask finalizeJobTask = (FinalizeJobTask)task;
                    PipelineManager.finalizeJob(finalizeJobTask.getJobKey());
                    break;
                }
                case FAN_OUT: {
                    FanoutTask fanoutTask = (FanoutTask)task;
                    PipelineManager.handleFanoutTaskOrAbandonTask(fanoutTask);
                    break;
                }
                case CANCEL_JOB: {
                    CancelJobTask cancelJobTask = (CancelJobTask)task;
                    PipelineManager.cancelJob(cancelJobTask.getJobKey());
                    break;
                }
                case DELETE_PIPELINE: {
                    DeletePipelineTask deletePipelineTask = (DeletePipelineTask)task;
                    try {
                        backEnd.deletePipeline(deletePipelineTask.getRootJobKey(), deletePipelineTask.shouldForce(), false);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "DeletePipeline operation failed.", e);
                    }
                    break;
                }
                case HANDLE_CHILD_EXCEPTION: {
                    HandleChildExceptionTask handleChildExceptionTask = (HandleChildExceptionTask)task;
                    PipelineManager.handleChildException(handleChildExceptionTask.getKey(), handleChildExceptionTask.getFailedChildKey());
                    break;
                }
                case FILL_SLOT_HANDLE_SLOT_FILLED: {
                    FillSlotHandleSlotFilledTask fillSlotHandleSlotFilledTask = (FillSlotHandleSlotFilledTask)task;
                    PipelineManager.handleFillSlotHandleFilled(fillSlotHandleSlotFilledTask);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized task type: " + (Object)((Object)task.getType()));
                }
            }
        }
        catch (AbandonTaskException abandonTaskException) {
            // empty catch block
        }
    }

    public static PipelineBackEnd getBackEnd() {
        return backEnd;
    }

    private static void invokePrivateJobMethod(String methodName, Job<?> job, Object ... params) {
        Class[] signature = new Class[params.length];
        int i = 0;
        for (Object param : params) {
            signature[i++] = param.getClass();
        }
        PipelineManager.invokePrivateJobMethod(methodName, job, signature, params);
    }

    private static void invokePrivateJobMethod(String methodName, Job<?> job, Class<?>[] signature, Object ... params) {
        try {
            Method method = Job.class.getDeclaredMethod(methodName, signature);
            method.setAccessible(true);
            method.invoke(job, params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method findJobMethodToInvoke(Class<?> klass, boolean callErrorHandler, Object[] params) {
        Method runMethod = null;
        if (callErrorHandler) {
            if (params.length != 1) {
                throw new RuntimeException("Invalid number of parameters passed to handleException:" + params.length);
            }
            Object parameter = params[0];
            if (parameter == null) {
                throw new RuntimeException("Null parameters passed to handleException:" + params.length);
            }
            Class<?> parameterClass = parameter.getClass();
            if (!Throwable.class.isAssignableFrom(parameterClass)) {
                throw new RuntimeException("Parameter that is not an exception passed to handleException:" + parameterClass.getName());
            }
            Class<?> exceptionClass = parameterClass;
            while (true) {
                try {
                    runMethod = klass.getMethod("handleException", exceptionClass);
                }
                catch (NoSuchMethodException e) {
                    if ((exceptionClass = exceptionClass.getSuperclass()) != null) continue;
                }
                break;
            }
        }
        for (Method method : klass.getMethods()) {
            if (!"run".equals(method.getName())) continue;
            runMethod = method;
            break;
        }
        return runMethod;
    }

    private static void setJobRecord(Job<?> job, JobRecord jobRecord) {
        PipelineManager.invokePrivateJobMethod("setJobRecord", job, jobRecord);
    }

    private static void setCurrentRunGuid(Job<?> job, String guid) {
        PipelineManager.invokePrivateJobMethod("setCurrentRunGuid", job, guid);
    }

    private static void setUpdateSpec(Job<?> job, UpdateSpec updateSpec) {
        PipelineManager.invokePrivateJobMethod("setUpdateSpec", job, updateSpec);
    }

    private static void runJob(Key jobKey) {
        JobRecord jobRecord = null;
        jobRecord = PipelineManager.queryJobOrAbandonTask(jobKey, JobRecord.InflationType.FOR_RUN);
        Key rootJobKey = jobRecord.getRootJobKey();
        logger.info("Running pipeline job " + jobKey.getName() + "; UI at " + PipelineServlet.makeViewerUrl(rootJobKey, jobKey));
        JobRecord rootJobRecord = jobRecord;
        if (!rootJobKey.equals((Object)jobKey)) {
            rootJobRecord = PipelineManager.queryJobOrAbandonTask(rootJobKey, JobRecord.InflationType.NONE);
        }
        if (rootJobRecord.getState() == JobRecord.State.STOPPED) {
            logger.warning("The pipeline has been stopped: " + rootJobRecord);
            throw new AbandonTaskException();
        }
        Barrier runBarrier = jobRecord.getRunBarrierInflated();
        if (null == runBarrier) {
            throw new RuntimeException("Internal logic error: " + jobRecord + " has not been inflated.");
        }
        Barrier finalizeBarrier = jobRecord.getFinalizeBarrierInflated();
        if (null == finalizeBarrier) {
            throw new RuntimeException("Internal logic error: finalize barrier not inflated in " + jobRecord);
        }
        runBarrier.setReleased();
        UpdateSpec tempSpec = new UpdateSpec(rootJobKey);
        tempSpec.getOrCreateTransaction("releaseRunBarrier").includeBarrier(runBarrier);
        backEnd.save(tempSpec, jobRecord.getQueueSettings());
        JobRecord.State jobState = jobRecord.getState();
        switch (jobState) {
            case WAITING_TO_RUN: 
            case RETRY: {
                break;
            }
            case WAITING_TO_FINALIZE: {
                logger.info("This job has already been run " + jobRecord);
                return;
            }
            case STOPPED: {
                logger.info("This job has been stoped " + jobRecord);
                return;
            }
            case CANCELED: {
                logger.info("This job has already been canceled " + jobRecord);
                return;
            }
            case FINALIZED: {
                logger.info("This job has already been run " + jobRecord);
                return;
            }
        }
        JobInstanceRecord record = jobRecord.getJobInstanceInflated();
        if (null == record) {
            throw new RuntimeException("Internal logic error:" + jobRecord + " does not have jobInstanceInflated.");
        }
        Job<?> job = record.getJobInstanceDeserialized();
        UpdateSpec updateSpec = new UpdateSpec(rootJobKey);
        PipelineManager.setJobRecord(job, jobRecord);
        String currentRunGUID = GUIDGenerator.nextGUID();
        PipelineManager.setCurrentRunGuid(job, currentRunGUID);
        PipelineManager.setUpdateSpec(job, updateSpec);
        Object[] params = runBarrier.buildArgumentArray();
        boolean callExceptionHandler = jobRecord.isCallExceptionHandler();
        Method methodToExecute = PipelineManager.findJobMethodToInvoke(job.getClass(), callExceptionHandler, params);
        if (callExceptionHandler && methodToExecute == null) {
            Throwable exceptionToHandle = (Throwable)params[0];
            PipelineManager.handleExceptionDuringRun(jobRecord, rootJobRecord, currentRunGUID, exceptionToHandle);
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("Running " + jobRecord + " with params: ");
            builder.append(StringUtils.toString(params));
            logger.finest(builder.toString());
        }
        jobRecord.incrementAttemptNumber();
        jobRecord.setStartTime(new Date());
        tempSpec = new UpdateSpec(jobRecord.getRootJobKey());
        tempSpec.getNonTransactionalGroup().includeJob(jobRecord);
        backEnd.save(tempSpec, jobRecord.getQueueSettings());
        Value returnValue = null;
        Throwable caughtException = null;
        try {
            methodToExecute.setAccessible(true);
            returnValue = (Value)methodToExecute.invoke(job, params);
        }
        catch (InvocationTargetException e) {
            caughtException = e.getCause();
        }
        catch (Throwable e) {
            caughtException = e;
        }
        if (null != caughtException) {
            PipelineManager.handleExceptionDuringRun(jobRecord, rootJobRecord, currentRunGUID, caughtException);
            return;
        }
        logger.finest("Job returned: " + returnValue);
        PipelineManager.registerSlotsWithBarrier(updateSpec, returnValue, rootJobKey, jobRecord.getKey(), jobRecord.getQueueSettings(), currentRunGUID, finalizeBarrier);
        jobRecord.setState(JobRecord.State.WAITING_TO_FINALIZE);
        jobRecord.setChildGraphGuid(currentRunGUID);
        updateSpec.getFinalTransaction().includeJob(jobRecord);
        updateSpec.getFinalTransaction().includeBarrier(finalizeBarrier);
        backEnd.saveWithJobStateCheck(updateSpec, jobRecord.getQueueSettings(), jobKey, JobRecord.State.WAITING_TO_RUN, JobRecord.State.RETRY);
    }

    private static void cancelJob(Key jobKey) {
        JobRecord jobRecord = null;
        jobRecord = PipelineManager.queryJobOrAbandonTask(jobKey, JobRecord.InflationType.FOR_RUN);
        Key rootJobKey = jobRecord.getRootJobKey();
        logger.info("Cancelling pipeline job " + jobKey.getName());
        JobRecord rootJobRecord = jobRecord;
        if (!rootJobKey.equals((Object)jobKey)) {
            rootJobRecord = PipelineManager.queryJobOrAbandonTask(rootJobKey, JobRecord.InflationType.NONE);
        }
        if (rootJobRecord.getState() == JobRecord.State.STOPPED) {
            logger.warning("The pipeline has been stopped: " + rootJobRecord);
            throw new AbandonTaskException();
        }
        switch (jobRecord.getState()) {
            case WAITING_TO_RUN: 
            case RETRY: 
            case WAITING_TO_FINALIZE: {
                break;
            }
            case STOPPED: {
                logger.info("This job has been stoped " + jobRecord);
                return;
            }
            case CANCELED: {
                logger.info("This job has already been canceled " + jobRecord);
                return;
            }
            case FINALIZED: {
                logger.info("This job has already been run " + jobRecord);
                return;
            }
        }
        if (jobRecord.getChildKeys().size() > 0) {
            PipelineManager.cancelChildren(jobRecord, null);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Marking " + jobRecord + " as CANCELED");
        }
        jobRecord.setState(JobRecord.State.CANCELED);
        UpdateSpec updateSpec = new UpdateSpec(jobRecord.getRootJobKey());
        updateSpec.getNonTransactionalGroup().includeJob(jobRecord);
        if (jobRecord.isExceptionHandlerSpecified()) {
            PipelineManager.executeExceptionHandler(updateSpec, jobRecord, new CancellationException(), true);
        }
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
    }

    private static void handleExceptionDuringRun(JobRecord jobRecord, JobRecord rootJobRecord, String currentRunGUID, Throwable caughtException) {
        int attemptNumber = jobRecord.getAttemptNumber();
        int maxAttempts = jobRecord.getMaxAttempts();
        if (jobRecord.isCallExceptionHandler()) {
            logger.log(Level.INFO, "An exception occurred when attempting to execute exception hander job " + jobRecord + ". ", caughtException);
        } else {
            logger.log(Level.INFO, "An exception occurred when attempting to run " + jobRecord + ". " + "This was attempt number " + attemptNumber + " of " + maxAttempts + ".", caughtException);
        }
        if (jobRecord.isIgnoreException()) {
            return;
        }
        UpdateSpec updateSpec = new UpdateSpec(jobRecord.getRootJobKey());
        ExceptionRecord exceptionRecord = new ExceptionRecord(jobRecord.getRootJobKey(), jobRecord.getKey(), currentRunGUID, caughtException);
        updateSpec.getNonTransactionalGroup().includeException(exceptionRecord);
        Key exceptionKey = exceptionRecord.getKey();
        jobRecord.setExceptionKey(exceptionKey);
        updateSpec.getNonTransactionalGroup().includeJob(jobRecord);
        if (jobRecord.isCallExceptionHandler() || attemptNumber >= maxAttempts) {
            jobRecord.setState(JobRecord.State.STOPPED);
            if (jobRecord.isExceptionHandlerSpecified()) {
                PipelineManager.cancelChildren(jobRecord, null);
                PipelineManager.executeExceptionHandler(updateSpec, jobRecord, caughtException, false);
            } else if (null != jobRecord.getExceptionHandlingAncestorKey()) {
                PipelineManager.cancelChildren(jobRecord, null);
                HandleChildExceptionTask handleChildExceptionTask = new HandleChildExceptionTask(jobRecord.getExceptionHandlingAncestorKey(), jobRecord.getKey(), jobRecord.getQueueSettings());
                updateSpec.getFinalTransaction().registerTask(handleChildExceptionTask);
            } else {
                rootJobRecord.setState(JobRecord.State.STOPPED);
                rootJobRecord.setExceptionKey(exceptionKey);
                updateSpec.getNonTransactionalGroup().includeJob(rootJobRecord);
            }
            backEnd.save(updateSpec, jobRecord.getQueueSettings());
        } else {
            jobRecord.setState(JobRecord.State.RETRY);
            updateSpec.getNonTransactionalGroup().includeJob(jobRecord);
            updateSpec.getNonTransactionalGroup().includeJob(rootJobRecord);
            backEnd.save(updateSpec, jobRecord.getQueueSettings());
            int backoffFactor = jobRecord.getBackoffFactor();
            int backoffSeconds = jobRecord.getBackoffSeconds();
            RunJobTask task = new RunJobTask(jobRecord.getKey(), attemptNumber, jobRecord.getQueueSettings());
            task.getQueueSettings().setDelayInSeconds((long)backoffSeconds * (long)Math.pow(backoffFactor, attemptNumber));
            backEnd.enqueue(task);
        }
    }

    private static void executeExceptionHandler(UpdateSpec updateSpec, JobRecord jobRecord, Throwable caughtException, boolean ignoreException) {
        updateSpec.getNonTransactionalGroup().includeJob(jobRecord);
        String errorHandlingGraphGuid = GUIDGenerator.nextGUID();
        Job<?> jobInstance = jobRecord.getJobInstanceInflated().getJobInstanceDeserialized();
        JobRecord errorHandlingJobRecord = new JobRecord(jobRecord, errorHandlingGraphGuid, jobInstance, true, new JobSetting[0]);
        errorHandlingJobRecord.setOutputSlotInflated(jobRecord.getOutputSlotInflated());
        errorHandlingJobRecord.setIgnoreException(ignoreException);
        PipelineManager.registerNewJobRecord(updateSpec, errorHandlingJobRecord, new Object[]{new ImmediateValue<Throwable>(caughtException)});
    }

    private static void cancelChildren(JobRecord jobRecord, Key failedChildKey) {
        for (Key childKey : jobRecord.getChildKeys()) {
            if (childKey.equals((Object)failedChildKey)) continue;
            CancelJobTask cancelJobTask = new CancelJobTask(childKey, jobRecord.getQueueSettings());
            try {
                backEnd.enqueue(cancelJobTask);
            }
            catch (TaskAlreadyExistsException e) {}
        }
    }

    private static void handleChildException(Key jobKey, Key failedChildKey) {
        JobRecord jobRecord = PipelineManager.queryJobOrAbandonTask(jobKey, JobRecord.InflationType.FOR_RUN);
        Key rootJobKey = jobRecord.getRootJobKey();
        logger.info("Running pipeline job " + jobKey.getName() + "; UI at " + PipelineServlet.makeViewerUrl(rootJobKey, jobKey));
        JobRecord rootJobRecord = jobRecord;
        if (!rootJobKey.equals((Object)jobKey)) {
            rootJobRecord = PipelineManager.queryJobOrAbandonTask(rootJobKey, JobRecord.InflationType.NONE);
        }
        if (rootJobRecord.getState() == JobRecord.State.STOPPED) {
            logger.warning("The pipeline has been stopped: " + rootJobRecord);
            throw new AbandonTaskException();
        }
        JobRecord failedJobRecord = PipelineManager.queryJobOrAbandonTask(failedChildKey, JobRecord.InflationType.FOR_OUTPUT);
        UpdateSpec updateSpec = new UpdateSpec(rootJobKey);
        PipelineManager.cancelChildren(jobRecord, failedChildKey);
        PipelineManager.executeExceptionHandler(updateSpec, jobRecord, failedJobRecord.getException(), false);
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
    }

    private static void finalizeJob(Key jobKey) {
        JobRecord jobRecord = PipelineManager.queryJobOrAbandonTask(jobKey, JobRecord.InflationType.FOR_FINALIZE);
        switch (jobRecord.getState()) {
            case WAITING_TO_FINALIZE: {
                break;
            }
            case WAITING_TO_RUN: 
            case RETRY: {
                throw new RuntimeException("" + jobRecord + " is in RETRY state");
            }
            case STOPPED: {
                logger.info("This job has been stoped " + jobRecord);
                return;
            }
            case CANCELED: {
                logger.info("This job has already been canceled " + jobRecord);
                return;
            }
            case FINALIZED: {
                logger.info("This job has already been run " + jobRecord);
                return;
            }
        }
        Barrier finalizeBarrier = jobRecord.getFinalizeBarrierInflated();
        if (null == finalizeBarrier) {
            throw new RuntimeException("" + jobRecord + " has not been inflated");
        }
        Slot outputSlot = jobRecord.getOutputSlotInflated();
        if (null == outputSlot) {
            throw new RuntimeException("" + jobRecord + " has not been inflated.");
        }
        finalizeBarrier.setReleased();
        UpdateSpec updateSpec = new UpdateSpec(jobRecord.getRootJobKey());
        updateSpec.getOrCreateTransaction("releaseFinalizeBarrier").includeBarrier(finalizeBarrier);
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
        updateSpec = new UpdateSpec(jobRecord.getRootJobKey());
        List<Object> finalizeArguments = finalizeBarrier.buildArgumentList();
        int numFinalizeArguments = finalizeArguments.size();
        if (1 != numFinalizeArguments) {
            throw new RuntimeException("Internal logic error: numFinalizeArguments=" + numFinalizeArguments);
        }
        Object finalizeValue = finalizeArguments.get(0);
        logger.finest("Finalizing " + jobRecord + " with value=" + finalizeValue);
        outputSlot.fill(finalizeValue);
        jobRecord.setState(JobRecord.State.FINALIZED);
        jobRecord.setEndTime(new Date());
        Key fillerJobKey = PipelineManager.getFinalizeSlotFiller(finalizeBarrier);
        if (null == fillerJobKey) {
            fillerJobKey = jobKey;
        }
        outputSlot.setSourceJobKey(fillerJobKey);
        updateSpec.getNonTransactionalGroup().includeJob(jobRecord);
        updateSpec.getNonTransactionalGroup().includeSlot(outputSlot);
        backEnd.save(updateSpec, jobRecord.getQueueSettings());
        HandleSlotFilledTask task = new HandleSlotFilledTask(outputSlot.getKey(), jobRecord.getQueueSettings());
        backEnd.enqueue(task);
    }

    private static Key getFinalizeSlotFiller(Barrier finalizeBarrier) {
        Key fillerJobKey = null;
        for (SlotDescriptor slotDescriptor : finalizeBarrier.getWaitingOnInflated()) {
            Key key = slotDescriptor.slot.getSourceJobKey();
            if (null == key) continue;
            if (null == fillerJobKey) {
                fillerJobKey = key;
                continue;
            }
            if (fillerJobKey.toString().equals(key.toString())) continue;
            return null;
        }
        return fillerJobKey;
    }

    private static void handleSlotFilled(Key slotKey) {
        Slot slot = null;
        slot = PipelineManager.querySlotOrAbandonTask(slotKey, true);
        List<Barrier> waitingList = slot.getWaitingOnMeInflated();
        if (null == waitingList) {
            throw new RuntimeException("Internal logic error: " + slot + " is not inflated");
        }
        for (Barrier barrier : waitingList) {
            ObjRefTask task;
            logger.finest("Checking " + barrier);
            if (barrier.isReleased()) continue;
            boolean shouldBeReleased = true;
            if (null == barrier.getWaitingOnInflated()) {
                throw new RuntimeException("Internal logic error: " + barrier + " is not inflated.");
            }
            for (SlotDescriptor sd : barrier.getWaitingOnInflated()) {
                if (sd.slot.isFilled()) continue;
                logger.finest("Not filled: " + sd.slot);
                shouldBeReleased = false;
                break;
            }
            if (!shouldBeReleased) continue;
            Key jobKey = barrier.getJobKey();
            JobRecord jobRecord = PipelineManager.queryJobOrAbandonTask(jobKey, JobRecord.InflationType.NONE);
            switch (barrier.getType()) {
                case RUN: {
                    task = new RunJobTask(jobKey, jobRecord.getQueueSettings());
                    break;
                }
                case FINALIZE: {
                    task = new FinalizeJobTask(jobKey, jobRecord.getQueueSettings());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown barrier type " + (Object)((Object)barrier.getType()));
                }
            }
            try {
                backEnd.enqueue(task);
            }
            catch (TaskAlreadyExistsException e) {}
        }
    }

    private static void handleFillSlotHandleFilled(FillSlotHandleSlotFilledTask fillSlotHandleFilledTask) {
        Key slotKey = fillSlotHandleFilledTask.getSlotKey();
        Slot slot = PipelineManager.querySlotOrAbandonTask(slotKey, true);
        Key rootJobKey = fillSlotHandleFilledTask.getRootJobKey();
        UpdateSpec updateSpec = new UpdateSpec(rootJobKey);
        slot.fill(null);
        updateSpec.getNonTransactionalGroup().includeSlot(slot);
        backEnd.save(updateSpec, fillSlotHandleFilledTask.getQueueSettings());
        PipelineManager.handleSlotFilled(slotKey);
    }

    private static JobRecord queryJobOrAbandonTask(Key key, JobRecord.InflationType inflationType) {
        try {
            return backEnd.queryJob(key, inflationType);
        }
        catch (NoSuchObjectException e) {
            logger.log(Level.SEVERE, "Cannot find some part of the job: " + key + ". Aborting the pipeline.", e);
            throw new AbandonTaskException();
        }
    }

    private static Slot querySlotOrAbandonTask(Key key, boolean inflate) {
        try {
            return backEnd.querySlot(key, inflate);
        }
        catch (NoSuchObjectException e) {
            logger.log(Level.SEVERE, "Cannot find the slot: " + key + ". Aborting the pipeline.", e);
            throw new AbandonTaskException();
        }
    }

    private static void handleFanoutTaskOrAbandonTask(FanoutTask fanoutTask) {
        try {
            backEnd.handleFanoutTask(fanoutTask);
        }
        catch (NoSuchObjectException e) {
            logger.log(Level.SEVERE, "Pipeline is fatally corrupted. Fanout task record not found", e);
            throw new AbandonTaskException();
        }
    }

    public static void registerDelayedValue(UpdateSpec spec, JobRecord generatorJobRecord, long delaySec, Slot slot) {
        FillSlotHandleSlotFilledTask task = new FillSlotHandleSlotFilledTask(slot.getKey(), generatorJobRecord.getRootJobKey(), generatorJobRecord.getQueueSettings());
        task.getQueueSettings().setDelayInSeconds(delaySec);
        spec.getFinalTransaction().registerTask(task);
    }

    private static class AbandonTaskException
    extends RuntimeException {
        private static final long serialVersionUID = 358437646006972459L;

        private AbandonTaskException() {
        }
    }

    private static final class RootJobInstance
    extends Job0<Object> {
        private static final long serialVersionUID = -2162670129577469245L;
        private final Job<?> jobInstance;
        private final JobSetting[] settings;
        private final Object[] params;

        public RootJobInstance(Job<?> jobInstance, JobSetting[] settings, Object[] params) {
            this.jobInstance = jobInstance;
            this.settings = settings;
            this.params = params;
        }

        @Override
        public Value<Object> run() throws Exception {
            return this.futureCallUnchecked(this.settings, this.jobInstance, this.params);
        }

        @Override
        public String getJobDisplayName() {
            return this.jobInstance.getClass().getName();
        }
    }
}

