/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.backend;

import com.google.appengine.api.backends.BackendServiceFactory;
import com.google.appengine.api.labs.modules.ModulesService;
import com.google.appengine.api.labs.modules.ModulesServiceFactory;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueConstants;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskAlreadyExistsException;
import com.google.appengine.api.taskqueue.TaskHandle;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.backend.PipelineTaskQueue;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;

public class AppEngineTaskQueue
implements PipelineTaskQueue {
    private static final Logger logger = Logger.getLogger(AppEngineTaskQueue.class.getName());
    static final int MAX_TASKS_PER_ENQUEUE = QueueConstants.maxTasksPerAdd();

    @Override
    public void enqueue(Task task) {
        logger.finest("Enqueueing: " + task);
        TaskOptions taskOptions = this.toTaskOptions(task);
        AppEngineTaskQueue.getQueue(task.getQueueSettings().getOnQueue()).add(taskOptions);
    }

    private static Queue getQueue(String queueName) {
        return queueName == null ? QueueFactory.getDefaultQueue() : QueueFactory.getQueue((String)queueName);
    }

    @Override
    public void enqueue(Collection<Task> tasks) {
        this.addToQueue(tasks);
    }

    List<TaskHandle> addToQueue(Collection<Task> tasks) {
        ArrayList<TaskHandle> handles = new ArrayList<TaskHandle>();
        HashMap<String, ArrayList<TaskOptions>> queueNameToTaskOptions = new HashMap<String, ArrayList<TaskOptions>>();
        for (Task task : tasks) {
            logger.finest("Enqueueing: " + task);
            String queueName = task.getQueueSettings().getOnQueue();
            TaskOptions taskOptions = this.toTaskOptions(task);
            ArrayList<TaskOptions> taskOptionsList = (ArrayList<TaskOptions>)queueNameToTaskOptions.get(queueName);
            if (taskOptionsList == null) {
                taskOptionsList = new ArrayList<TaskOptions>();
                queueNameToTaskOptions.put(queueName, taskOptionsList);
            }
            taskOptionsList.add(taskOptions);
        }
        for (Map.Entry entry : queueNameToTaskOptions.entrySet()) {
            Queue queue = AppEngineTaskQueue.getQueue((String)entry.getKey());
            handles.addAll(this.addToQueue(queue, (List)entry.getValue()));
        }
        return handles;
    }

    private List<TaskHandle> addToQueue(Queue queue, List<TaskOptions> tasks) {
        int limit = tasks.size();
        int start = 0;
        ArrayList<Future> futures = new ArrayList<Future>(limit / MAX_TASKS_PER_ENQUEUE + 1);
        while (start < limit) {
            int end = Math.min(limit, start + MAX_TASKS_PER_ENQUEUE);
            futures.add(queue.addAsync(tasks.subList(start, end)));
            start = end;
        }
        ArrayList<TaskHandle> taskHandles = new ArrayList<TaskHandle>(limit);
        for (Future future : futures) {
            try {
                taskHandles.addAll((Collection)future.get());
            }
            catch (InterruptedException e) {
                logger.throwing("AppEngineTaskQueue", "addToQueue", e);
                Thread.currentThread().interrupt();
                throw new RuntimeException("addToQueue failed", e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof TaskAlreadyExistsException) continue;
                throw new RuntimeException("addToQueue failed", e.getCause());
            }
        }
        return taskHandles;
    }

    private TaskOptions toTaskOptions(Task task) {
        QueueSettings queueSettings = task.getQueueSettings();
        TaskOptions taskOptions = TaskOptions.Builder.withUrl((String)"/_ah/pipeline/handleTask");
        if (queueSettings.getOnBackend() != null) {
            taskOptions.header("Host", BackendServiceFactory.getBackendService().getBackendAddress(queueSettings.getOnBackend()));
        } else {
            ModulesService service = ModulesServiceFactory.getModulesService();
            String module = queueSettings.getOnModule();
            String version = queueSettings.getModuleVersion();
            if (module == null) {
                module = service.getCurrentModule();
                version = service.getCurrentVersion();
            }
            taskOptions.header("Host", service.getModuleHostname(module, version));
        }
        Long delayInSeconds = queueSettings.getDelayInSeconds();
        if (null != delayInSeconds) {
            taskOptions.countdownMillis(delayInSeconds * 1000L);
            queueSettings.setDelayInSeconds(null);
        }
        AppEngineTaskQueue.addProperties(taskOptions, task.toProperties());
        String taskName = task.getName();
        if (null != taskName) {
            taskOptions.taskName(taskName);
        }
        return taskOptions;
    }

    private static void addProperties(TaskOptions taskOptions, Properties properties) {
        for (String paramName : properties.stringPropertyNames()) {
            String paramValue = properties.getProperty(paramName);
            taskOptions.param(paramName, paramValue);
        }
    }
}

