/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import com.google.appengine.tools.pipeline.impl.util.SerializationUtils;
import java.io.IOException;

public class ExceptionRecord
extends PipelineModelObject {
    public static final String DATA_STORE_KIND = "pipeline-exception";
    private static final String EXCEPTION_PROPERTY = "exception";
    private final Throwable exception;

    public ExceptionRecord(Key rootJobKey, Key generatorJobKey, String graphGUID, Throwable exception) {
        super(rootJobKey, generatorJobKey, graphGUID);
        this.exception = exception;
    }

    public ExceptionRecord(Entity entity) {
        super(entity);
        Blob serializedExceptionBlob = (Blob)entity.getProperty(EXCEPTION_PROPERTY);
        byte[] serializedException = serializedExceptionBlob.getBytes();
        try {
            this.exception = (Throwable)SerializationUtils.deserialize(serializedException);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize exception for " + this.getKey(), e);
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    protected String getDatastoreKind() {
        return DATA_STORE_KIND;
    }

    @Override
    public Entity toEntity() {
        try {
            Entity entity = this.toProtoEntity();
            byte[] serializedException = SerializationUtils.serialize(this.exception);
            entity.setUnindexedProperty(EXCEPTION_PROPERTY, (Object)new Blob(serializedException));
            return entity;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize exception for " + this.getKey(), e);
        }
    }
}

