/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.ExceptionRecord;
import com.google.appengine.tools.pipeline.impl.model.JobInstanceRecord;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import java.util.Map;

public class PipelineObjects {
    public JobRecord rootJob;
    public Map<Key, JobRecord> jobs;
    public Map<Key, Slot> slots;
    public Map<Key, Barrier> barriers;
    public Map<Key, JobInstanceRecord> jobInstanceRecords;

    public PipelineObjects(Key rootJobKey, Map<Key, JobRecord> jobs, Map<Key, Slot> slots, Map<Key, Barrier> barriers, Map<Key, JobInstanceRecord> jobInstanceRecords, Map<Key, ExceptionRecord> failureRecords) {
        this.jobInstanceRecords = jobInstanceRecords;
        this.barriers = barriers;
        this.jobs = jobs;
        this.slots = slots;
        for (JobRecord job : jobs.values()) {
            if (!job.getKey().equals((Object)rootJobKey)) continue;
            this.rootJob = job;
        }
        if (null == this.rootJob) {
            throw new IllegalArgumentException("None of the jobs were the root job with key " + rootJobKey);
        }
        for (Slot slot : slots.values()) {
            slot.inflate(barriers);
        }
        for (Barrier barrier : barriers.values()) {
            barrier.inflate(slots);
        }
        for (JobRecord jobRec : jobs.values()) {
            Barrier runBarrier = barriers.get(jobRec.getRunBarrierKey());
            Barrier finalizeBarrier = barriers.get(jobRec.getFinalizeBarrierKey());
            Slot outputSlot = slots.get(jobRec.getOutputSlotKey());
            JobInstanceRecord jobInstanceRecord = jobInstanceRecords.get(jobRec.getJobInstanceKey());
            ExceptionRecord failureRecord = null;
            Key failureKey = jobRec.getExceptionKey();
            if (null != failureKey) {
                failureRecord = failureRecords.get(failureKey);
            }
            jobRec.inflate(runBarrier, finalizeBarrier, outputSlot, jobInstanceRecord, failureRecord);
        }
    }
}

