/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;

public class ShardedValue
extends PipelineModelObject {
    public static final String DATA_STORE_KIND = "pipeline-sharded-value";
    private static final String SHARD_ID_PROPERTY = "shard-id";
    private static final String VALUE_PROPERTY = "value";
    private final long shardId;
    private final byte[] value;

    public ShardedValue(PipelineModelObject parent, long shardId, byte[] value) {
        super(parent.getRootJobKey(), parent.getKey(), null, parent.getGeneratorJobKey(), parent.getGraphGuid());
        this.shardId = shardId;
        this.value = value;
    }

    public ShardedValue(Entity entity) {
        super(entity);
        this.shardId = (Long)entity.getProperty(SHARD_ID_PROPERTY);
        this.value = ((Blob)entity.getProperty(VALUE_PROPERTY)).getBytes();
    }

    @Override
    public Entity toEntity() {
        Entity entity = this.toProtoEntity();
        entity.setUnindexedProperty(SHARD_ID_PROPERTY, (Object)this.shardId);
        entity.setUnindexedProperty(VALUE_PROPERTY, (Object)new Blob(this.value));
        return entity;
    }

    @Override
    public String getDatastoreKind() {
        return DATA_STORE_KIND;
    }

    public long getShardId() {
        return this.shardId;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        return "ShardedValue[" + this.getKey().getName() + ", shardId=" + this.shardId + ", value=" + this.getValueForDisplay() + "]";
    }

    private String getValueForDisplay() {
        int count = 0;
        StringBuilder stBuilder = new StringBuilder(103);
        for (byte b : this.value) {
            if (++count == 100) {
                stBuilder.append("...");
                break;
            }
            stBuilder.append(String.format("%02x", b & 0xFF));
        }
        return stBuilder.toString();
    }
}

