/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.PipelineManager;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Slot
extends PipelineModelObject {
    public static final String DATA_STORE_KIND = "pipeline-slot";
    private static final String FILLED_PROPERTY = "filled";
    private static final String VALUE_PROPERTY = "value";
    private static final String WAITING_ON_ME_PROPERTY = "waitingOnMe";
    private static final String FILL_TIME_PROPERTY = "fillTime";
    private static final String SOURCE_JOB_KEY_PROPERTY = "sourceJob";
    private boolean filled;
    private Date fillTime;
    private Object value;
    private Key sourceJobKey;
    private final List<Key> waitingOnMeKeys;
    private List<Barrier> waitingOnMeInflated;

    public Slot(Key rootJobKey, Key generatorJobKey, String graphGUID) {
        super(rootJobKey, generatorJobKey, graphGUID);
        this.waitingOnMeKeys = new LinkedList<Key>();
    }

    public Slot(Entity entity) {
        super(entity);
        this.filled = (Boolean)entity.getProperty(FILLED_PROPERTY);
        this.fillTime = (Date)entity.getProperty(FILL_TIME_PROPERTY);
        this.sourceJobKey = (Key)entity.getProperty(SOURCE_JOB_KEY_PROPERTY);
        Object serializedVersion = entity.getProperty(VALUE_PROPERTY);
        try {
            this.value = PipelineManager.getBackEnd().deserializeValue(this, serializedVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.waitingOnMeKeys = Slot.getListProperty(WAITING_ON_ME_PROPERTY, entity);
    }

    @Override
    public Entity toEntity() {
        Entity entity = this.toProtoEntity();
        entity.setUnindexedProperty(FILLED_PROPERTY, (Object)this.filled);
        if (null != this.fillTime) {
            entity.setUnindexedProperty(FILL_TIME_PROPERTY, (Object)this.fillTime);
        }
        if (null != this.sourceJobKey) {
            entity.setProperty(SOURCE_JOB_KEY_PROPERTY, (Object)this.sourceJobKey);
        }
        try {
            entity.setUnindexedProperty(VALUE_PROPERTY, PipelineManager.getBackEnd().serializeValue(this, this.value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        entity.setProperty(WAITING_ON_ME_PROPERTY, this.waitingOnMeKeys);
        return entity;
    }

    @Override
    protected String getDatastoreKind() {
        return DATA_STORE_KIND;
    }

    public void inflate(Map<Key, Barrier> pool) {
        this.waitingOnMeInflated = Slot.buildInflated(this.waitingOnMeKeys, pool);
    }

    public void addWaiter(Barrier waiter) {
        this.waitingOnMeKeys.add(waiter.getKey());
        if (null == this.waitingOnMeInflated) {
            this.waitingOnMeInflated = new LinkedList<Barrier>();
        }
        this.waitingOnMeInflated.add(waiter);
    }

    public boolean isFilled() {
        return this.filled;
    }

    public Object getValue() {
        return this.value;
    }

    public Date getFillTime() {
        return this.fillTime;
    }

    public Key getSourceJobKey() {
        return this.sourceJobKey;
    }

    public void setSourceJobKey(Key key) {
        this.sourceJobKey = key;
    }

    public void fill(Object value) {
        this.filled = true;
        this.value = value;
        this.fillTime = new Date();
    }

    public List<Key> getWaitingOnMeKeys() {
        return this.waitingOnMeKeys;
    }

    public List<Barrier> getWaitingOnMeInflated() {
        return this.waitingOnMeInflated;
    }

    public String toString() {
        return "Slot[" + this.getKey().getName() + ", value=" + this.value + ", filled=" + this.filled + ", waitingOnMe=" + this.waitingOnMeKeys + "]";
    }
}

