/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.servlets;

import com.google.appengine.tools.pipeline.impl.PipelineManager;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.servlets.JsonGenerator;
import com.google.appengine.tools.pipeline.util.Pair;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JsonListHandler {
    public static final String PATH_COMPONENT = "rpc/list";
    private static final String CLASS_FILTER_PARAMETER = "class_path";
    private static final String CURSOR_PARAMETER = "cursor";
    private static final String LIMIT_PARAMETER = "limit";

    public static void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String classFilter = JsonListHandler.getParam(req, CLASS_FILTER_PARAMETER);
        String cursor = JsonListHandler.getParam(req, CURSOR_PARAMETER);
        String limit = JsonListHandler.getParam(req, LIMIT_PARAMETER);
        Pair<? extends Iterable<JobRecord>, String> pipelineRoots = PipelineManager.queryRootPipelines(classFilter, cursor, limit == null ? 100 : Integer.parseInt(limit));
        String asJson = JsonGenerator.pipelineRootsToJson(pipelineRoots);
        try {
            resp.getWriter().write(asJson);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static String getParam(HttpServletRequest req, String name) {
        String value = req.getParameter(name);
        if (value != null && (value = value.trim()).isEmpty()) {
            value = null;
        }
        return value;
    }
}

