/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.servlets;

import com.google.appengine.tools.pipeline.NoSuchObjectException;
import com.google.appengine.tools.pipeline.impl.PipelineManager;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineObjects;
import com.google.appengine.tools.pipeline.impl.servlets.JsonGenerator;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JsonTreeHandler {
    public static final String PATH_COMPONENT = "rpc/tree";
    private static final String ROOT_PIPELINE_ID = "root_pipeline_id";

    public static void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String rootJobHandle = req.getParameter(ROOT_PIPELINE_ID);
        if (null == rootJobHandle) {
            throw new ServletException("root_pipeline_id parameter not found.");
        }
        try {
            JobRecord jobInfo;
            try {
                jobInfo = PipelineManager.getJob(rootJobHandle);
            }
            catch (NoSuchObjectException nsoe) {
                resp.sendError(404);
                return;
            }
            String rootJobKey = jobInfo.getRootJobKey().getName();
            if (!rootJobKey.equals(rootJobHandle)) {
                resp.sendError(449, rootJobKey);
                return;
            }
            PipelineObjects pipelineObjects = PipelineManager.queryFullPipeline(rootJobKey);
            String asJson = JsonGenerator.pipelineObjectsToJson(pipelineObjects);
            resp.getWriter().write(asJson);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

