/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.servlets;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.servlets.JsonClassFilterHandler;
import com.google.appengine.tools.pipeline.impl.servlets.JsonListHandler;
import com.google.appengine.tools.pipeline.impl.servlets.JsonTreeHandler;
import com.google.appengine.tools.pipeline.impl.servlets.StaticContentHandler;
import com.google.appengine.tools.pipeline.impl.servlets.TaskHandler;
import com.google.appengine.tools.pipeline.util.Pair;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PipelineServlet
extends HttpServlet {
    public static final String BASE_URL = "/_ah/pipeline/";

    public static String makeViewerUrl(Key rootJobKey, Key jobKey) {
        return "/_ah/pipeline/status.html?root=" + rootJobKey.getName() + "#pipeline-" + jobKey.getName();
    }

    private Pair<String, RequestType> parseRequestType(HttpServletRequest req) {
        String path = req.getPathInfo();
        path = path == null ? "" : path.substring(1);
        RequestType requestType = RequestType.HANDLE_STATIC;
        for (RequestType rt : RequestType.values()) {
            if (!rt.matches(path)) continue;
            requestType = rt;
            break;
        }
        return Pair.of(path, requestType);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Pair<String, RequestType> pair = this.parseRequestType(req);
        RequestType requestType = pair.getSecond();
        String path = pair.getFirst();
        switch (requestType) {
            case HANDLE_TASK: {
                TaskHandler.doPost(req);
                break;
            }
            case GET_JSON: {
                JsonTreeHandler.doGet(req, resp);
                break;
            }
            case GET_JSON_LIST: {
                JsonListHandler.doGet(req, resp);
                break;
            }
            case GET_JSON_CLASS_FILTER: {
                JsonClassFilterHandler.doGet(req, resp);
                break;
            }
            case HANDLE_STATIC: {
                StaticContentHandler.doGet(resp, path);
                break;
            }
            default: {
                throw new ServletException("Unknown request type: " + (Object)((Object)requestType));
            }
        }
    }

    private static enum RequestType {
        HANDLE_TASK("handleTask"),
        GET_JSON("rpc/tree"),
        GET_JSON_LIST("rpc/list"),
        GET_JSON_CLASS_FILTER("rpc/class_paths"),
        HANDLE_STATIC("");

        private final String pathComponent;

        private RequestType(String pathComponent) {
            this.pathComponent = pathComponent;
        }

        public boolean matches(String path) {
            return this.pathComponent.equals(path);
        }
    }
}

