/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.tasks;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.QueueSettings;
import com.google.appengine.tools.pipeline.impl.tasks.ObjRefTask;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import java.util.Properties;

public class RunJobTask
extends ObjRefTask {
    private final Integer attemptNumber;

    public RunJobTask(Key jobKey, Integer attemptNumber, QueueSettings queueSettings) {
        super(Task.Type.RUN_JOB, "runJob", jobKey, queueSettings);
        this.attemptNumber = attemptNumber;
    }

    public RunJobTask(Key jobKey, QueueSettings queueSettings) {
        this(jobKey, null, queueSettings);
    }

    protected RunJobTask(Task.Type type, String taskName, Properties properties) {
        super(type, taskName, properties);
        this.attemptNumber = null;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (null != this.attemptNumber) {
            name = name + "-attemptNumber-" + this.attemptNumber;
        }
        return name;
    }

    public Key getJobKey() {
        return this.getKey();
    }
}

