/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth;

import com.google.auth.ServiceAccountSigner;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class SigningExceptionTest {
    private static final String EXPECTED_MESSAGE = "message";
    private static final RuntimeException EXPECTED_CAUSE = new RuntimeException();

    @Test
    public void constructor() {
        ServiceAccountSigner.SigningException signingException = new ServiceAccountSigner.SigningException(EXPECTED_MESSAGE, (Exception)EXPECTED_CAUSE);
        Assert.assertEquals((Object)EXPECTED_MESSAGE, (Object)signingException.getMessage());
        Assert.assertSame((Object)EXPECTED_CAUSE, (Object)signingException.getCause());
    }

    @Test
    public void equals_true() throws IOException {
        ServiceAccountSigner.SigningException signingException = new ServiceAccountSigner.SigningException(EXPECTED_MESSAGE, (Exception)EXPECTED_CAUSE);
        ServiceAccountSigner.SigningException otherSigningException = new ServiceAccountSigner.SigningException(EXPECTED_MESSAGE, (Exception)EXPECTED_CAUSE);
        Assert.assertTrue((boolean)signingException.equals((Object)otherSigningException));
        Assert.assertTrue((boolean)otherSigningException.equals((Object)signingException));
    }

    @Test
    public void equals_false_message() throws IOException {
        ServiceAccountSigner.SigningException signingException = new ServiceAccountSigner.SigningException(EXPECTED_MESSAGE, (Exception)EXPECTED_CAUSE);
        ServiceAccountSigner.SigningException otherSigningException = new ServiceAccountSigner.SigningException("otherMessage", (Exception)EXPECTED_CAUSE);
        Assert.assertFalse((boolean)signingException.equals((Object)otherSigningException));
        Assert.assertFalse((boolean)otherSigningException.equals((Object)signingException));
    }

    @Test
    public void equals_false_cause() throws IOException {
        ServiceAccountSigner.SigningException signingException = new ServiceAccountSigner.SigningException(EXPECTED_MESSAGE, (Exception)EXPECTED_CAUSE);
        ServiceAccountSigner.SigningException otherSigningException = new ServiceAccountSigner.SigningException("otherMessage", (Exception)new RuntimeException());
        Assert.assertFalse((boolean)signingException.equals((Object)otherSigningException));
        Assert.assertFalse((boolean)otherSigningException.equals((Object)signingException));
    }

    @Test
    public void hashCode_equals() throws IOException {
        ServiceAccountSigner.SigningException signingException = new ServiceAccountSigner.SigningException(EXPECTED_MESSAGE, (Exception)EXPECTED_CAUSE);
        ServiceAccountSigner.SigningException otherSigningException = new ServiceAccountSigner.SigningException(EXPECTED_MESSAGE, (Exception)EXPECTED_CAUSE);
        Assert.assertEquals((long)signingException.hashCode(), (long)otherSigningException.hashCode());
    }
}

