/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth;

import com.google.auth.ApiKeyCredentials;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApiKeyCredentialsTest {
    private static final String TEST_API_KEY = "testApiKey";

    @Test
    public void testGetAuthenticationType() {
        ApiKeyCredentials credentials = ApiKeyCredentials.create((String)TEST_API_KEY);
        Assert.assertEquals((Object)"API-Key", (Object)credentials.getAuthenticationType());
    }

    @Test
    public void testGetRequestMetadata() throws IOException, URISyntaxException {
        ApiKeyCredentials credentials = ApiKeyCredentials.create((String)TEST_API_KEY);
        Map metadata = credentials.getRequestMetadata(new URI("http://test.com"));
        Assert.assertEquals((long)1L, (long)metadata.size());
        Assert.assertTrue((boolean)metadata.containsKey("x-goog-api-key"));
        Assert.assertEquals((long)1L, (long)((List)metadata.get("x-goog-api-key")).size());
        Assert.assertEquals((Object)TEST_API_KEY, ((List)metadata.get("x-goog-api-key")).get(0));
    }

    @Test
    public void testHasRequestMetadata() {
        ApiKeyCredentials credentials = ApiKeyCredentials.create((String)TEST_API_KEY);
        Assert.assertTrue((boolean)credentials.hasRequestMetadata());
    }

    @Test
    public void testHasRequestMetadataOnly() {
        ApiKeyCredentials credentials = ApiKeyCredentials.create((String)TEST_API_KEY);
        Assert.assertTrue((boolean)credentials.hasRequestMetadataOnly());
    }

    @Test
    public void testNullApiKey_ThrowsException() {
        Assert.assertThrows(IllegalArgumentException.class, () -> ApiKeyCredentials.create(null));
    }

    @Test
    public void testBlankApiKey_ThrowsException() {
        Assert.assertThrows(IllegalArgumentException.class, () -> ApiKeyCredentials.create((String)""));
    }
}

