/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpTransport;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

class DefaultCredentialsProvider {
    static final String CREDENTIAL_ENV_VAR = "GOOGLE_APPLICATION_CREDENTIALS";
    static final String WELL_KNOWN_CREDENTIALS_FILE = "application_default_credentials.json";
    static final String CLOUDSDK_CONFIG_DIRECTORY = "gcloud";
    static final String HELP_PERMALINK = "https://developers.google.com/accounts/docs/application-default-credentials";
    private GoogleCredentials cachedCredentials = null;
    private boolean checkedComputeEngine = false;

    DefaultCredentialsProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final GoogleCredentials getDefaultCredentials(HttpTransport transport) throws IOException {
        DefaultCredentialsProvider defaultCredentialsProvider = this;
        synchronized (defaultCredentialsProvider) {
            if (this.cachedCredentials == null) {
                this.cachedCredentials = this.getDefaultCredentialsUnsynchronized(transport);
            }
            if (this.cachedCredentials != null) {
                return this.cachedCredentials;
            }
        }
        throw new IOException(String.format("The Application Default Credentials are not available. They are available if running in Google Compute Engine. Otherwise, the environment variable %s must be defined pointing to a file defining the credentials. See %s for more information.", CREDENTIAL_ENV_VAR, HELP_PERMALINK));
    }

    private final GoogleCredentials getDefaultCredentialsUnsynchronized(HttpTransport transport) throws IOException {
        File wellKnownFileLocation;
        GoogleCredentials credentials = null;
        String credentialsPath = this.getEnv(CREDENTIAL_ENV_VAR);
        if (credentialsPath != null && credentialsPath.length() > 0) {
            InputStream credentialsStream = null;
            try {
                File credentialsFile = new File(credentialsPath);
                if (!this.isFile(credentialsFile)) {
                    throw new IOException("File does not exist.");
                }
                credentialsStream = this.readStream(credentialsFile);
                credentials = GoogleCredentials.fromStream(credentialsStream, transport);
            }
            catch (IOException e) {
                throw OAuth2Utils.exceptionWithCause(new IOException(String.format("Error reading credential file from environment variable %s, value '%s': %s", CREDENTIAL_ENV_VAR, credentialsPath, e.getMessage())), e);
            }
            finally {
                if (credentialsStream != null) {
                    credentialsStream.close();
                }
            }
        }
        if (credentials == null && this.isFile(wellKnownFileLocation = this.getWellKnownCredentialsFile())) {
            InputStream credentialsStream = null;
            try {
                credentialsStream = this.readStream(wellKnownFileLocation);
                credentials = GoogleCredentials.fromStream(credentialsStream, transport);
            }
            catch (IOException e) {
                throw new IOException(String.format("Error reading credential file from location %s: %s", wellKnownFileLocation, e.getMessage()));
            }
            finally {
                if (credentialsStream != null) {
                    credentialsStream.close();
                }
            }
        }
        if (credentials == null) {
            credentials = this.tryGetComputeCredentials(transport);
        }
        return credentials;
    }

    private final File getWellKnownCredentialsFile() {
        File cloudConfigPath = null;
        String os = this.getProperty("os.name", "").toLowerCase(Locale.US);
        if (os.indexOf("windows") >= 0) {
            File appDataPath = new File(this.getEnv("APPDATA"));
            cloudConfigPath = new File(appDataPath, CLOUDSDK_CONFIG_DIRECTORY);
        } else {
            File configPath = new File(this.getProperty("user.home", ""), ".config");
            cloudConfigPath = new File(configPath, CLOUDSDK_CONFIG_DIRECTORY);
        }
        File credentialFilePath = new File(cloudConfigPath, WELL_KNOWN_CREDENTIALS_FILE);
        return credentialFilePath;
    }

    private final GoogleCredentials tryGetComputeCredentials(HttpTransport transport) {
        if (this.checkedComputeEngine) {
            return null;
        }
        boolean runningOnComputeEngine = ComputeEngineCredentials.runningOnComputeEngine(transport);
        this.checkedComputeEngine = true;
        if (runningOnComputeEngine) {
            return new ComputeEngineCredentials(transport);
        }
        return null;
    }

    String getEnv(String name) {
        return System.getenv(name);
    }

    String getProperty(String property, String def) {
        return System.getProperty(property, def);
    }

    boolean isFile(File file) {
        return file.isFile();
    }

    InputStream readStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }
}

