/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.GenericData;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OAuth2Utils {
    static final String TOKEN_SERVER_URL = "https://accounts.google.com/o/oauth2/token";
    static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private static String VALUE_NOT_FOUND_MESSAGE = "%sExpected value %s not found.";
    private static String VALUE_WRONG_TYPE_MESSAGE = "%sExpected %s value %s of wrong type.";

    static boolean headersContainValue(HttpHeaders headers, String headerName, String value) {
        Object values = headers.get((Object)headerName);
        if (values instanceof Collection) {
            Collection valuesCollection = (Collection)values;
            return valuesCollection.contains(value);
        }
        return false;
    }

    static <T extends Throwable> T exceptionWithCause(T exception, Throwable cause) {
        exception.initCause(cause);
        return exception;
    }

    static String validateString(GenericData map, String key, String errorPrefix) throws IOException {
        Object value = map.get((Object)key);
        if (value == null) {
            throw new IOException(String.format(VALUE_NOT_FOUND_MESSAGE, errorPrefix, key));
        }
        if (!(value instanceof String)) {
            throw new IOException(String.format(VALUE_WRONG_TYPE_MESSAGE, errorPrefix, "string", key));
        }
        return (String)value;
    }

    static int validateInt32(GenericData map, String key, String errorPrefix) throws IOException {
        Object value = map.get((Object)key);
        if (value == null) {
            throw new IOException(String.format(VALUE_NOT_FOUND_MESSAGE, errorPrefix, key));
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            return bigDecimalValue.intValueExact();
        }
        if (!(value instanceof Integer)) {
            throw new IOException(String.format(VALUE_WRONG_TYPE_MESSAGE, errorPrefix, "integer", key));
        }
        return (Integer)value;
    }

    private OAuth2Utils() {
    }
}

