package com.google.auth.oauth2;

import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_JwtClaims extends JwtClaims {

  private final String audience;

  private final String issuer;

  private final String subject;

  private final Map<String, String> additionalClaims;

  private AutoValue_JwtClaims(
      @Nullable String audience,
      @Nullable String issuer,
      @Nullable String subject,
      Map<String, String> additionalClaims) {
    this.audience = audience;
    this.issuer = issuer;
    this.subject = subject;
    this.additionalClaims = additionalClaims;
  }

  @Nullable
  @Override
  String getAudience() {
    return audience;
  }

  @Nullable
  @Override
  String getIssuer() {
    return issuer;
  }

  @Nullable
  @Override
  String getSubject() {
    return subject;
  }

  @Override
  Map<String, String> getAdditionalClaims() {
    return additionalClaims;
  }

  @Override
  public String toString() {
    return "JwtClaims{"
         + "audience=" + audience + ", "
         + "issuer=" + issuer + ", "
         + "subject=" + subject + ", "
         + "additionalClaims=" + additionalClaims
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof JwtClaims) {
      JwtClaims that = (JwtClaims) o;
      return (this.audience == null ? that.getAudience() == null : this.audience.equals(that.getAudience()))
          && (this.issuer == null ? that.getIssuer() == null : this.issuer.equals(that.getIssuer()))
          && (this.subject == null ? that.getSubject() == null : this.subject.equals(that.getSubject()))
          && this.additionalClaims.equals(that.getAdditionalClaims());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (audience == null) ? 0 : audience.hashCode();
    h$ *= 1000003;
    h$ ^= (issuer == null) ? 0 : issuer.hashCode();
    h$ *= 1000003;
    h$ ^= (subject == null) ? 0 : subject.hashCode();
    h$ *= 1000003;
    h$ ^= additionalClaims.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 4974444151019426702L;

  static final class Builder extends JwtClaims.Builder {
    private String audience;
    private String issuer;
    private String subject;
    private Map<String, String> additionalClaims;
    Builder() {
    }
    @Override
    JwtClaims.Builder setAudience(String audience) {
      this.audience = audience;
      return this;
    }
    @Override
    JwtClaims.Builder setIssuer(String issuer) {
      this.issuer = issuer;
      return this;
    }
    @Override
    JwtClaims.Builder setSubject(String subject) {
      this.subject = subject;
      return this;
    }
    @Override
    JwtClaims.Builder setAdditionalClaims(Map<String, String> additionalClaims) {
      if (additionalClaims == null) {
        throw new NullPointerException("Null additionalClaims");
      }
      this.additionalClaims = additionalClaims;
      return this;
    }
    @Override
    JwtClaims build() {
      String missing = "";
      if (this.additionalClaims == null) {
        missing += " additionalClaims";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_JwtClaims(
          this.audience,
          this.issuer,
          this.subject,
          this.additionalClaims);
    }
  }

}
