/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.util.Clock;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OAuth2Credentials
extends Credentials {
    private static final int MINIMUM_TOKEN_MILLISECONDS = 60000;
    private final Object lock = new Object();
    private Map<String, List<String>> requestMetadata;
    private AccessToken temporaryAccess;
    Clock clock = Clock.SYSTEM;

    public OAuth2Credentials() {
        this(null);
    }

    public OAuth2Credentials(AccessToken accessToken) {
        this.temporaryAccess = accessToken;
    }

    public String getAuthenticationType() {
        return "OAuth2";
    }

    public boolean hasRequestMetadata() {
        return true;
    }

    public boolean hasRequestMetadataOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Long expiresIn = this.getExpiresInMilliseconds();
            if (this.temporaryAccess == null || expiresIn != null && expiresIn <= 60000L) {
                this.refresh();
            }
            assert (this.temporaryAccess != null);
            if (this.requestMetadata == null) {
                HashMap<String, List<String>> newRequestMetadata = new HashMap<String, List<String>>();
                ArrayList<String> newAuthorizationHeaders = new ArrayList<String>();
                String string = String.valueOf("Bearer ");
                String string2 = String.valueOf(this.temporaryAccess.getTokenValue());
                String authorizationHeader = string2.length() != 0 ? string.concat(string2) : new String(string);
                newAuthorizationHeaders.add(authorizationHeader);
                newRequestMetadata.put("Authorization", newAuthorizationHeaders);
                this.requestMetadata = newRequestMetadata;
            }
            return this.requestMetadata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.requestMetadata = null;
            this.temporaryAccess = null;
            this.temporaryAccess = this.refreshAccessToken();
        }
    }

    public abstract AccessToken refreshAccessToken() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Long getExpiresInMilliseconds() {
        Object object = this.lock;
        synchronized (object) {
            if (this.temporaryAccess == null) {
                return null;
            }
            Date expirationTime = this.temporaryAccess.getExpirationTime();
            if (expirationTime == null) {
                return null;
            }
            return expirationTime.getTime() - this.clock.currentTimeMillis();
        }
    }
}

