/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class TestUtils {
    public static final String UTF_8 = "UTF-8";
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();

    public static void assertContainsBearerToken(Map<String, List<String>> metadata, String token) {
        Assert.assertNotNull(metadata);
        Assert.assertNotNull((Object)token);
        Assert.assertTrue((String)"Bearer token not found", (boolean)TestUtils.hasBearerToken(metadata, token));
    }

    public static void assertNotContainsBearerToken(Map<String, List<String>> metadata, String token) {
        Assert.assertNotNull(metadata);
        Assert.assertNotNull((Object)token);
        Assert.assertTrue((String)"Bearer token found", (!TestUtils.hasBearerToken(metadata, token) ? 1 : 0) != 0);
    }

    private static boolean hasBearerToken(Map<String, List<String>> metadata, String token) {
        String expectedValue = "Bearer " + token;
        List<String> authorizations = metadata.get("Authorization");
        Assert.assertNotNull((String)"Authorization headers not found", authorizations);
        for (String authorization : authorizations) {
            if (!expectedValue.equals(authorization)) continue;
            return true;
        }
        return false;
    }

    public static InputStream jsonToInputStream(GenericJson json) throws IOException {
        json.setFactory(JSON_FACTORY);
        String text = json.toPrettyString();
        return new ByteArrayInputStream(text.getBytes(UTF_8));
    }

    public static InputStream stringToInputStream(String text) {
        try {
            return new ByteArrayInputStream(text.getBytes(UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected encoding exception", e);
        }
    }

    public static Map<String, String> parseQuery(String query) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterable entries = Splitter.on((char)'&').split((CharSequence)query);
        for (String entry : entries) {
            ArrayList sides = Lists.newArrayList((Iterable)Splitter.on((char)'=').split((CharSequence)entry));
            if (sides.size() != 2) {
                throw new IOException("Invalid Query String");
            }
            String key = URLDecoder.decode((String)sides.get(0), UTF_8);
            String value = URLDecoder.decode((String)sides.get(1), UTF_8);
            map.put(key, value);
        }
        return map;
    }

    public static String errorJson(String message) throws IOException {
        GenericJson errorResponse = new GenericJson();
        errorResponse.setFactory(JSON_FACTORY);
        GenericJson errorObject = new GenericJson();
        errorObject.put("message", (Object)message);
        errorResponse.put("error", (Object)errorObject);
        return errorResponse.toPrettyString();
    }

    private TestUtils() {
    }
}

