/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.MockTokenCheckingTransport;
import com.google.auth.oauth2.UserCredentials;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HttpCredentialsAdapterTest {
    private static final String CLIENT_SECRET = "jakuaL9YyieakhECKL2SwZcu";
    private static final String CLIENT_ID = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
    private static final String REFRESH_TOKEN = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";

    @Test
    public void initialize_populatesOAuth2Credentials() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String expectedAuthorization = "Bearer 1/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter((Credentials)credentials);
        HttpRequestFactory requestFactory = transportFactory.transport.createRequestFactory();
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl("http://foo"));
        adapter.initialize(request);
        HttpHeaders requestHeaders = request.getHeaders();
        String authorizationHeader = requestHeaders.getAuthorization();
        Assert.assertEquals((Object)authorizationHeader, (Object)"Bearer 1/MkSJoj1xsli0AccessToken_NKPY2");
    }

    @Test
    public void initialize_populatesOAuth2Credentials_handle401() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory tokenServerTransportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        tokenServerTransportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        tokenServerTransportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)tokenServerTransportFactory).build();
        credentials.refresh();
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter((Credentials)credentials);
        MockTokenCheckingTransport primaryHttpTransport = new MockTokenCheckingTransport(tokenServerTransportFactory.transport, REFRESH_TOKEN);
        HttpRequestFactory requestFactory = primaryHttpTransport.createRequestFactory();
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl("http://foo"));
        adapter.initialize(request);
        tokenServerTransportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        HttpResponse response = request.execute();
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"{\"key\":\"value\"}", (Object)response.parseAsString());
    }

    @Test
    public void initialize_noURI() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String expectedAuthorization = "Bearer 1/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory tokenServerTransportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        tokenServerTransportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        tokenServerTransportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)tokenServerTransportFactory).build();
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter((Credentials)credentials);
        HttpRequestFactory requestFactory = tokenServerTransportFactory.transport.createRequestFactory();
        HttpRequest request = requestFactory.buildGetRequest(null);
        adapter.initialize(request);
        HttpHeaders requestHeaders = request.getHeaders();
        String authorizationHeader = requestHeaders.getAuthorization();
        Assert.assertEquals((Object)authorizationHeader, (Object)"Bearer 1/MkSJoj1xsli0AccessToken_NKPY2");
    }
}

