/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.BaseSerializationTest;
import java.io.IOException;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AccessTokenTest
extends BaseSerializationTest {
    private static final String TOKEN = "AccessToken";
    private static final Date EXPIRATION_DATE = new Date();

    @Test
    public void constructor() {
        AccessToken accessToken = new AccessToken(TOKEN, EXPIRATION_DATE);
        Assert.assertEquals((Object)TOKEN, (Object)accessToken.getTokenValue());
        Assert.assertEquals((Object)EXPIRATION_DATE, (Object)accessToken.getExpirationTime());
        Assert.assertEquals((long)EXPIRATION_DATE.getTime(), (long)accessToken.getExpirationTimeMillis());
    }

    @Test
    public void equals_true() throws IOException {
        AccessToken accessToken = new AccessToken(TOKEN, EXPIRATION_DATE);
        AccessToken otherAccessToken = new AccessToken(TOKEN, EXPIRATION_DATE);
        Assert.assertTrue((boolean)accessToken.equals((Object)otherAccessToken));
        Assert.assertTrue((boolean)otherAccessToken.equals((Object)accessToken));
    }

    @Test
    public void equals_false_token() throws IOException {
        AccessToken accessToken = new AccessToken(TOKEN, EXPIRATION_DATE);
        AccessToken otherAccessToken = new AccessToken("otherToken", EXPIRATION_DATE);
        Assert.assertFalse((boolean)accessToken.equals((Object)otherAccessToken));
        Assert.assertFalse((boolean)otherAccessToken.equals((Object)accessToken));
    }

    @Test
    public void equals_false_expirationDate() throws IOException {
        AccessToken accessToken = new AccessToken(TOKEN, EXPIRATION_DATE);
        AccessToken otherAccessToken = new AccessToken(TOKEN, new Date(EXPIRATION_DATE.getTime() + 42L));
        Assert.assertFalse((boolean)accessToken.equals((Object)otherAccessToken));
        Assert.assertFalse((boolean)otherAccessToken.equals((Object)accessToken));
    }

    @Test
    public void toString_containsFields() {
        AccessToken accessToken = new AccessToken(TOKEN, EXPIRATION_DATE);
        String expectedToString = String.format("AccessToken{tokenValue=%s, expirationTimeMillis=%d}", TOKEN, EXPIRATION_DATE.getTime());
        Assert.assertEquals((Object)expectedToString, (Object)accessToken.toString());
    }

    @Test
    public void hashCode_equals() throws IOException {
        AccessToken accessToken = new AccessToken(TOKEN, EXPIRATION_DATE);
        AccessToken otherAccessToken = new AccessToken(TOKEN, EXPIRATION_DATE);
        Assert.assertEquals((long)accessToken.hashCode(), (long)otherAccessToken.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        AccessToken accessToken = new AccessToken(TOKEN, EXPIRATION_DATE);
        AccessToken deserializedAccessToken = this.serializeAndDeserialize(accessToken);
        Assert.assertEquals((Object)accessToken, (Object)deserializedAccessToken);
        Assert.assertEquals((long)accessToken.hashCode(), (long)deserializedAccessToken.hashCode());
        Assert.assertEquals((Object)accessToken.toString(), (Object)deserializedAccessToken.toString());
    }
}

