/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.AppEngineCredentials;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class AppEngineCredentialsTest
extends BaseSerializationTest {
    private static final String EXPECTED_ACCESS_TOKEN = "ExpectedAccessToken";
    private static final Date EXPECTED_EXPIRATION_DATE = new Date(System.currentTimeMillis() + 360000L);
    private static final byte[] EXPECTED_SIGNATURE = new byte[]{13, 14, 10, 13};
    private static final String EXPECTED_ACCOUNT = "serviceAccount";
    private static final Collection<String> SCOPES = Collections.unmodifiableCollection(Arrays.asList("scope1", "scope2"));

    @Test
    public void constructor_usesAppIdentityService() throws IOException {
        Set<String> scopes = Collections.singleton("SomeScope");
        TestAppEngineCredentials credentials = new TestAppEngineCredentials(scopes);
        List<String> forNameArgs = credentials.getForNameArgs();
        Assert.assertEquals((long)4L, (long)forNameArgs.size());
        Assert.assertEquals((Object)"com.google.appengine.api.appidentity.AppIdentityServiceFactory", (Object)forNameArgs.get(0));
        Assert.assertEquals((Object)"com.google.appengine.api.appidentity.AppIdentityService", (Object)forNameArgs.get(1));
        Assert.assertEquals((Object)"com.google.appengine.api.appidentity.AppIdentityService$GetAccessTokenResult", (Object)forNameArgs.get(2));
        Assert.assertEquals((Object)"com.google.appengine.api.appidentity.AppIdentityService$SigningResult", (Object)forNameArgs.get(3));
    }

    @Test
    public void constructor_noAppEngineRuntime_throwsHelpfulLoadError() throws IOException {
        try {
            new TestAppEngineCredentialsNoSdk();
            Assert.fail((String)"Credential expected to fail to load if credential class not present.");
        }
        catch (IOException e) {
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.contains("Check that the App Engine SDK is deployed."));
            Assert.assertTrue((boolean)(e.getCause() instanceof ClassNotFoundException));
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("com.google.appengine.api.appidentity.AppIdentityServiceFactory"));
        }
    }

    @Test
    public void refreshAccessToken_sameAs() throws IOException {
        TestAppEngineCredentials credentials = new TestAppEngineCredentials(SCOPES);
        AccessToken accessToken = credentials.refreshAccessToken();
        Assert.assertEquals((Object)EXPECTED_ACCESS_TOKEN, (Object)accessToken.getTokenValue());
        Assert.assertEquals((Object)EXPECTED_EXPIRATION_DATE, (Object)accessToken.getExpirationTime());
    }

    @Test
    public void getAccount_sameAs() throws IOException {
        TestAppEngineCredentials credentials = new TestAppEngineCredentials(SCOPES);
        Assert.assertEquals((Object)EXPECTED_ACCOUNT, (Object)credentials.getAccount());
    }

    @Test
    public void sign_sameAs() throws IOException {
        TestAppEngineCredentials credentials = new TestAppEngineCredentials(SCOPES);
        Assert.assertArrayEquals((byte[])EXPECTED_SIGNATURE, (byte[])credentials.sign("Bytes to sign".getBytes()));
    }

    @Test
    public void createScoped_clonesWithScopes() throws IOException {
        TestAppEngineCredentials credentials = new TestAppEngineCredentials(null);
        Assert.assertTrue((boolean)credentials.createScopedRequired());
        try {
            credentials.refreshAccessToken();
            Assert.fail((String)"Should not be able to use credential without scopes.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        GoogleCredentials scopedCredentials = credentials.createScoped(SCOPES);
        Assert.assertNotSame((Object)((Object)credentials), (Object)scopedCredentials);
        AccessToken accessToken = scopedCredentials.refreshAccessToken();
        Assert.assertEquals((Object)EXPECTED_ACCESS_TOKEN, (Object)accessToken.getTokenValue());
        Assert.assertEquals((Object)EXPECTED_EXPIRATION_DATE, (Object)accessToken.getExpirationTime());
    }

    @Test
    public void equals_true() throws IOException {
        TestAppEngineCredentials credentials = new TestAppEngineCredentials(SCOPES);
        TestAppEngineCredentials otherCredentials = new TestAppEngineCredentials(SCOPES);
        Assert.assertTrue((boolean)credentials.equals((Object)credentials));
        Assert.assertTrue((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertTrue((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_scopes() throws IOException {
        List<String> emptyScopes = Collections.emptyList();
        Set<String> scopes = Collections.singleton("SomeScope");
        TestAppEngineCredentials credentials = new TestAppEngineCredentials(emptyScopes);
        TestAppEngineCredentials otherCredentials = new TestAppEngineCredentials(scopes);
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void toString_containsFields() throws IOException {
        String expectedToString = String.format("TestAppEngineCredentials{scopes=[%s], scopesRequired=%b}", "SomeScope", false);
        Set<String> scopes = Collections.singleton("SomeScope");
        TestAppEngineCredentials credentials = new TestAppEngineCredentials(scopes);
        Assert.assertEquals((Object)expectedToString, (Object)credentials.toString());
    }

    @Test
    public void hashCode_equals() throws IOException {
        TestAppEngineCredentials credentials = new TestAppEngineCredentials(SCOPES);
        Assert.assertEquals((long)credentials.hashCode(), (long)credentials.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        Set<String> scopes = Collections.singleton("SomeScope");
        TestAppEngineCredentials credentials = new TestAppEngineCredentials(scopes);
        GoogleCredentials deserializedCredentials = (GoogleCredentials)this.serializeAndDeserialize(credentials);
        Assert.assertEquals((Object)((Object)credentials), (Object)deserializedCredentials);
        Assert.assertEquals((long)credentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)credentials.toString(), (Object)deserializedCredentials.toString());
    }

    private static class TestAppEngineCredentialsNoSdk
    extends AppEngineCredentials {
        private static final long serialVersionUID = -8987103249265111274L;

        TestAppEngineCredentialsNoSdk() throws IOException {
            super(null);
        }

        Class<?> forName(String className) throws ClassNotFoundException {
            throw new ClassNotFoundException(className);
        }
    }

    private static class TestAppEngineCredentials
    extends AppEngineCredentials {
        private static final long serialVersionUID = -5191475572296306231L;
        private static final Map<String, Class<?>> TYPES = ImmutableMap.of((Object)"com.google.appengine.api.appidentity.AppIdentityServiceFactory", TestAppIdentityServiceFactory.class, (Object)"com.google.appengine.api.appidentity.AppIdentityService", TestAppIdentityService.class, (Object)"com.google.appengine.api.appidentity.AppIdentityService$GetAccessTokenResult", TestGetAccessTokenResult.class, (Object)"com.google.appengine.api.appidentity.AppIdentityService$SigningResult", TestSigningResult.class);
        private List<String> forNameArgs;

        TestAppEngineCredentials(Collection<String> scopes) throws IOException {
            super(scopes);
        }

        Class<?> forName(String className) throws ClassNotFoundException {
            if (this.forNameArgs == null) {
                this.forNameArgs = new ArrayList<String>();
            }
            this.forNameArgs.add(className);
            Class<?> lookup = TYPES.get(className);
            if (lookup != null) {
                return lookup;
            }
            throw new ClassNotFoundException(className);
        }

        List<String> getForNameArgs() {
            return this.forNameArgs;
        }
    }

    private static class TestGetAccessTokenResult {
        private final String accessToken;
        private final Date expirationTime;

        TestGetAccessTokenResult(String accessToken, Date expirationTime) {
            this.accessToken = accessToken;
            this.expirationTime = expirationTime;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Date getExpirationTime() {
            return this.expirationTime;
        }
    }

    private static class TestAppIdentityService {
        private TestAppIdentityService() {
        }

        public TestGetAccessTokenResult getAccessToken(Iterable<String> scopes) {
            return new TestGetAccessTokenResult(AppEngineCredentialsTest.EXPECTED_ACCESS_TOKEN, EXPECTED_EXPIRATION_DATE);
        }

        public String getServiceAccountName() {
            return AppEngineCredentialsTest.EXPECTED_ACCOUNT;
        }

        public TestSigningResult signForApp(byte[] toSign) {
            return new TestSigningResult(EXPECTED_SIGNATURE);
        }
    }

    private static class TestAppIdentityServiceFactory {
        private TestAppIdentityServiceFactory() {
        }

        public static TestAppIdentityService getAppIdentityService() {
            return new TestAppIdentityService();
        }
    }

    private static class TestSigningResult {
        private final byte[] signature;

        TestSigningResult(byte[] signature) {
            this.signature = signature;
        }

        public byte[] getSignature() {
            return this.signature;
        }
    }
}

