/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.auth.TestUtils;
import com.google.auth.oauth2.ClientId;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ClientIdTest {
    private static final String CLIENT_ID = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
    private static final String CLIENT_SECRET = "jakuaL9YyieakhECKL2SwZcu";

    @Test
    public void constructor() {
        ClientId clientId = ClientId.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).build();
        Assert.assertEquals((Object)CLIENT_ID, (Object)clientId.getClientId());
        Assert.assertEquals((Object)CLIENT_SECRET, (Object)clientId.getClientSecret());
    }

    @Test(expected=NullPointerException.class)
    public void constructor_nullClientId_throws() {
        ClientId.newBuilder().setClientSecret(CLIENT_SECRET).build();
    }

    @Test
    public void constructor_nullClientSecret() {
        ClientId clientId = ClientId.newBuilder().setClientId(CLIENT_ID).build();
        Assert.assertEquals((Object)CLIENT_ID, (Object)clientId.getClientId());
        Assert.assertNull((Object)clientId.getClientSecret());
    }

    @Test
    public void fromJson_web() throws IOException {
        GenericJson json = this.writeClientIdJson("web", CLIENT_ID, CLIENT_SECRET);
        ClientId clientId = ClientId.fromJson((Map)json);
        Assert.assertEquals((Object)CLIENT_ID, (Object)clientId.getClientId());
        Assert.assertEquals((Object)CLIENT_SECRET, (Object)clientId.getClientSecret());
    }

    @Test
    public void fromJson_installed() throws IOException {
        GenericJson json = this.writeClientIdJson("installed", CLIENT_ID, CLIENT_SECRET);
        ClientId clientId = ClientId.fromJson((Map)json);
        Assert.assertEquals((Object)CLIENT_ID, (Object)clientId.getClientId());
        Assert.assertEquals((Object)CLIENT_SECRET, (Object)clientId.getClientSecret());
    }

    @Test
    public void fromJson_installedNoSecret() throws IOException {
        GenericJson json = this.writeClientIdJson("installed", CLIENT_ID, null);
        ClientId clientId = ClientId.fromJson((Map)json);
        Assert.assertEquals((Object)CLIENT_ID, (Object)clientId.getClientId());
        Assert.assertNull((Object)clientId.getClientSecret());
    }

    @Test(expected=IOException.class)
    public void fromJson_invalidType_throws() throws IOException {
        GenericJson json = this.writeClientIdJson("invalid", CLIENT_ID, null);
        ClientId.fromJson((Map)json);
    }

    @Test(expected=IOException.class)
    public void fromJson_noClientId_throws() throws IOException {
        GenericJson json = this.writeClientIdJson("web", null, null);
        ClientId.fromJson((Map)json);
    }

    @Test(expected=IOException.class)
    public void fromJson_zeroLengthClientId_throws() throws IOException {
        GenericJson json = this.writeClientIdJson("web", "", null);
        ClientId.fromJson((Map)json);
    }

    @Test
    public void fromResource() throws IOException {
        ClientId clientId = ClientId.fromResource(ClientIdTest.class, (String)"/client_secret.json");
        Assert.assertEquals((Object)CLIENT_ID, (Object)clientId.getClientId());
        Assert.assertEquals((Object)CLIENT_SECRET, (Object)clientId.getClientSecret());
    }

    @Test(expected=NullPointerException.class)
    public void fromResource_badResource() throws IOException {
        ClientId.fromResource(ClientIdTest.class, (String)"invalid.json");
    }

    @Test
    public void fromStream() throws IOException {
        String text = "{\"web\": {\"client_id\" : \"ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws\",\"client_secret\" : \"jakuaL9YyieakhECKL2SwZcu\"}}";
        InputStream stream = TestUtils.stringToInputStream(text);
        ClientId clientId = ClientId.fromStream((InputStream)stream);
        Assert.assertEquals((Object)CLIENT_ID, (Object)clientId.getClientId());
        Assert.assertEquals((Object)CLIENT_SECRET, (Object)clientId.getClientSecret());
    }

    @Test
    public void fromStream_invalidJson_throws() {
        String invalidJson = "{\"web\": {\"client_id\" : \"ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws\",\"client_secret\" : \"jakuaL9YyieakhECKL2SwZcu\"}";
        InputStream stream = TestUtils.stringToInputStream(invalidJson);
        try {
            ClientId.fromStream((InputStream)stream);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private GenericJson writeClientIdJson(String type, String clientId, String clientSecret) {
        GenericJson json = new GenericJson();
        GenericJson details = new GenericJson();
        if (clientId != null) {
            details.put("client_id", (Object)clientId);
        }
        if (clientSecret != null) {
            details.put("client_secret", (Object)clientSecret);
        }
        json.put(type, (Object)details);
        return json;
    }
}

