/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CloudShellCredentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.ComputeEngineCredentialsTest;
import com.google.auth.oauth2.DefaultCredentialsProvider;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.ServiceAccountCredentialsTest;
import com.google.auth.oauth2.UserCredentialsTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DefaultCredentialsProviderTest {
    private static final String USER_CLIENT_SECRET = "jakuaL9YyieakhECKL2SwZcu";
    private static final String USER_CLIENT_ID = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
    private static final String GCLOUDSDK_CLIENT_ID = "764086051850-6qr4p6gpi6hn506pt8ejuq83di341hur.apps.googleusercontent.com";
    private static final String REFRESH_TOKEN = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
    private static final String ACCESS_TOKEN = "1/MkSJoj1xsli0AccessToken_NKPY2";
    private static final String SA_CLIENT_EMAIL = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr@developer.gserviceaccount.com";
    private static final String SA_CLIENT_ID = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com";
    private static final String SA_PRIVATE_KEY_ID = "d84a4fefcf50791d4a90f2d7af17469d6282df9d";
    private static final String SA_PRIVATE_KEY_PKCS8 = "-----BEGIN PRIVATE KEY-----\nMIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALX0PQoe1igW12ikv1bN/r9lN749y2ijmbc/mFHPyS3hNTyOCjDvBbXYbDhQJzWVUikh4mvGBA07qTj79Xc3yBDfKP2IeyYQIFe0t0zkd7R9Zdn98Y2rIQC47aAbDfubtkU1U72t4zL11kHvoa0/RuFZjncvlr42X7be7lYh4p3NAgMBAAECgYASk5wDw4Az2ZkmeuN6Fk/y9H+Lcb2pskJIXjrL533vrDWGOC48LrsThMQPv8cxBky8HFSEklPpkfTF95tpD43iVwJRB/GrCtGTw65IfJ4/tI09h6zGc4yqvIo1cHX/LQ+SxKLGyir/dQM925rGt/VojxY5ryJR7GLbCzxPnJm/oQJBANwOCO6D2hy1LQYJhXh7O+RLtA/tSnT1xyMQsGT+uUCMiKS2bSKx2wxo9k7h3OegNJIu1q6nZ6AbxDK8H3+d0dUCQQDTrPSXagBxzp8PecbaCHjzNRSQE2in81qYnrAFNB4o3DpHyMMY6s5ALLeHKscEWnqP8Ur6X4PvzZecCWU9BKAZAkAutLPknAuxSCsUOvUfS1i87ex77Ot+w6POp34pEX+UWb+u5iFn2cQacDTHLV1LtE80L8jVLSbrbrlH43H0DjU5AkEAgidhycxS86dxpEljnOMCw8CKoUBd5I880IUahEiUltk7OLJYS/Ts1wbn3kPOVX3wyJs8WBDtBkFrDHW2ezth2QJADj3e1YhMVdjJW5jqwlD/VNddGjgzyunmiZg0uOXsHXbytYmsA545S8KRQFaJKFXYYFo2kOjqOiC1T2cAzMDjCQ==\n-----END PRIVATE KEY-----\n";
    private static final Collection<String> SCOPES = Collections.singletonList("dummy.scope");
    private static final URI CALL_URI = URI.create("http://googleapis.com/testapi/v1/foo");
    private static final String QUOTA_PROJECT = "sample-quota-project-id";

    @Test
    public void getDefaultCredentials_noCredentials_throws() throws Exception {
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        try {
            testProvider.getDefaultCredentials(transportFactory);
            Assert.fail((String)"No credential expected.");
        }
        catch (IOException e) {
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.contains("https://developers.google.com/accounts/docs/application-default-credentials"));
        }
    }

    @Test
    public void getDefaultCredentials_noCredentialsSandbox_throwsNonSecurity() throws Exception {
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setFileSandbox(true);
        try {
            testProvider.getDefaultCredentials(transportFactory);
            Assert.fail((String)"No credential expected.");
        }
        catch (IOException e) {
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.contains("https://developers.google.com/accounts/docs/application-default-credentials"));
        }
    }

    @Test
    public void getDefaultCredentials_envValidSandbox_throwsNonSecurity() throws Exception {
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        InputStream userStream = UserCredentialsTest.writeUserStream(USER_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setFileSandbox(true);
        String userPath = this.tempFilePath("user.json");
        testProvider.addFile(userPath, userStream);
        testProvider.setEnv("GOOGLE_APPLICATION_CREDENTIALS", userPath);
        try {
            testProvider.getDefaultCredentials(transportFactory);
            Assert.fail((String)"No credential expected.");
        }
        catch (IOException e) {
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.contains("https://developers.google.com/accounts/docs/application-default-credentials"));
        }
    }

    @Test
    public void getDefaultCredentials_noCredentials_singleGceTestRequest() {
        MockRequestCountingTransportFactory transportFactory = new MockRequestCountingTransportFactory();
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        try {
            testProvider.getDefaultCredentials(transportFactory);
            Assert.fail((String)"No credential expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((long)transportFactory.transport.getRequestCount(), (long)3L);
        try {
            testProvider.getDefaultCredentials(transportFactory);
            Assert.fail((String)"No credential expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((long)transportFactory.transport.getRequestCount(), (long)3L);
    }

    @Test
    public void getDefaultCredentials_caches() throws IOException {
        ComputeEngineCredentialsTest.MockMetadataServerTransportFactory transportFactory = new ComputeEngineCredentialsTest.MockMetadataServerTransportFactory();
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        GoogleCredentials firstCall = testProvider.getDefaultCredentials(transportFactory);
        GoogleCredentials secondCall = testProvider.getDefaultCredentials(transportFactory);
        Assert.assertNotNull((Object)firstCall);
        Assert.assertSame((Object)firstCall, (Object)secondCall);
    }

    @Test
    public void getDefaultCredentials_appEngineClassWithoutRuntime_NotFoundError() {
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.addType("com.google.appengine.api.utils.SystemProperty", MockOffAppEngineSystemProperty.class);
        testProvider.setProperty("isOnGAEStandard7", "true");
        try {
            testProvider.getDefaultCredentials(transportFactory);
            Assert.fail((String)"No credential expected when not on App Engine.");
        }
        catch (IOException e) {
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.contains("https://developers.google.com/accounts/docs/application-default-credentials"));
        }
    }

    @Test
    public void getDefaultCredentials_appEngineRuntimeWithoutClass_throwsHelpfulLoadError() {
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.addType("com.google.appengine.api.utils.SystemProperty", MockAppEngineSystemProperty.class);
        testProvider.setProperty("isOnGAEStandard7", "true");
        try {
            testProvider.getDefaultCredentials(transportFactory);
            Assert.fail((String)"Credential expected to fail to load if credential class not present.");
        }
        catch (IOException e) {
            String message = e.getMessage();
            Assert.assertFalse((boolean)message.contains("https://developers.google.com/accounts/docs/application-default-credentials"));
            Assert.assertTrue((boolean)message.contains("Check that the App Engine SDK is deployed."));
        }
    }

    @Test
    public void getDefaultCredentials_appEngineSkipWorks_retrievesCloudShellCredential() throws IOException {
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.addType("com.google.appengine.api.utils.SystemProperty", MockOffAppEngineSystemProperty.class);
        testProvider.setEnv("DEVSHELL_CLIENT_PORT", "9090");
        testProvider.setEnv("GOOGLE_APPLICATION_CREDENTIALS_SKIP_APP_ENGINE", "true");
        testProvider.setProperty("isOnGAEStanadard7", "true");
        GoogleCredentials credentials = testProvider.getDefaultCredentials(transportFactory);
        Assert.assertNotNull((Object)credentials);
        Assert.assertTrue((boolean)(credentials instanceof CloudShellCredentials));
    }

    @Test
    public void getDefaultCredentials_compute_providesToken() throws IOException {
        ComputeEngineCredentialsTest.MockMetadataServerTransportFactory transportFactory = new ComputeEngineCredentialsTest.MockMetadataServerTransportFactory();
        transportFactory.transport.setAccessToken(ACCESS_TOKEN);
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        GoogleCredentials defaultCredentials = testProvider.getDefaultCredentials(transportFactory);
        Assert.assertNotNull((Object)defaultCredentials);
        Map metadata = defaultCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void getDefaultCredentials_cloudshell() throws IOException {
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setEnv("DEVSHELL_CLIENT_PORT", "4");
        GoogleCredentials defaultCredentials = testProvider.getDefaultCredentials(transportFactory);
        Assert.assertTrue((boolean)(defaultCredentials instanceof CloudShellCredentials));
        Assert.assertEquals((long)((CloudShellCredentials)defaultCredentials).getAuthPort(), (long)4L);
    }

    @Test
    public void getDefaultCredentials_cloudshell_withComputCredentialsPresent() throws IOException {
        ComputeEngineCredentialsTest.MockMetadataServerTransportFactory transportFactory = new ComputeEngineCredentialsTest.MockMetadataServerTransportFactory();
        transportFactory.transport.setAccessToken(ACCESS_TOKEN);
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setEnv("DEVSHELL_CLIENT_PORT", "4");
        GoogleCredentials defaultCredentials = testProvider.getDefaultCredentials(transportFactory);
        Assert.assertTrue((boolean)(defaultCredentials instanceof CloudShellCredentials));
        Assert.assertEquals((long)((CloudShellCredentials)defaultCredentials).getAuthPort(), (long)4L);
    }

    @Test
    public void getDefaultCredentials_envMissingFile_throws() {
        String invalidPath = "/invalid/path";
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setEnv("GOOGLE_APPLICATION_CREDENTIALS", "/invalid/path");
        try {
            testProvider.getDefaultCredentials(transportFactory);
            Assert.fail((String)"Non existent credential should throw exception");
        }
        catch (IOException e) {
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.contains("GOOGLE_APPLICATION_CREDENTIALS"));
            Assert.assertTrue((boolean)message.contains("/invalid/path"));
        }
    }

    @Test
    public void getDefaultCredentials_envServiceAccount_providesToken() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addServiceAccount(SA_CLIENT_EMAIL, ACCESS_TOKEN);
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(SA_CLIENT_ID, SA_CLIENT_EMAIL, SA_PRIVATE_KEY_PKCS8, SA_PRIVATE_KEY_ID);
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        String serviceAccountPath = this.tempFilePath("service_account.json");
        testProvider.addFile(serviceAccountPath, serviceAccountStream);
        testProvider.setEnv("GOOGLE_APPLICATION_CREDENTIALS", serviceAccountPath);
        GoogleCredentials defaultCredentials = testProvider.getDefaultCredentials(transportFactory);
        Assert.assertNotNull((Object)defaultCredentials);
        defaultCredentials = defaultCredentials.createScoped(SCOPES);
        Map metadata = defaultCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void getDefaultCredentials_envUser_providesToken() throws IOException {
        InputStream userStream = UserCredentialsTest.writeUserStream(USER_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        String userPath = this.tempFilePath("user.json");
        testProvider.addFile(userPath, userStream);
        testProvider.setEnv("GOOGLE_APPLICATION_CREDENTIALS", userPath);
        this.testUserProvidesToken(testProvider, USER_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN);
    }

    @Test
    public void getDefaultCredentials_envNoGceCheck_noGceRequest() throws IOException {
        MockRequestCountingTransportFactory transportFactory = new MockRequestCountingTransportFactory();
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setEnv("NO_GCE_CHECK", "true");
        try {
            testProvider.getDefaultCredentials(transportFactory);
            Assert.fail((String)"No credential expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((long)transportFactory.transport.getRequestCount(), (long)0L);
    }

    @Test
    public void getDefaultCredentials_envGceMetadataHost_setsMetadataServerUrl() {
        String testUrl = "192.0.2.0";
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setEnv("GCE_METADATA_HOST", testUrl);
        Assert.assertEquals((Object)ComputeEngineCredentials.getMetadataServerUrl((DefaultCredentialsProvider)testProvider), (Object)("http://" + testUrl));
    }

    @Test
    public void getDefaultCredentials_envGceMetadataHost_setsTokenServerUrl() {
        String testUrl = "192.0.2.0";
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setEnv("GCE_METADATA_HOST", testUrl);
        Assert.assertEquals((Object)ComputeEngineCredentials.getTokenServerEncodedUrl((DefaultCredentialsProvider)testProvider), (Object)("http://" + testUrl + "/computeMetadata/v1/instance/service-accounts/default/token"));
    }

    @Test
    public void getDefaultCredentials_wellKnownFileEnv_providesToken() throws IOException {
        File cloudConfigDir = DefaultCredentialsProviderTest.getTempDirectory();
        InputStream userStream = UserCredentialsTest.writeUserStream(USER_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        File wellKnownFile = new File(cloudConfigDir, "application_default_credentials.json");
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setEnv("CLOUDSDK_CONFIG", cloudConfigDir.getAbsolutePath());
        testProvider.addFile(wellKnownFile.getAbsolutePath(), userStream);
        this.testUserProvidesToken(testProvider, USER_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN);
    }

    @Test
    public void getDefaultCredentials_wellKnownFileNonWindows_providesToken() throws IOException {
        File homeDir = DefaultCredentialsProviderTest.getTempDirectory();
        File configDir = new File(homeDir, ".config");
        File cloudConfigDir = new File(configDir, "gcloud");
        InputStream userStream = UserCredentialsTest.writeUserStream(USER_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        File wellKnownFile = new File(cloudConfigDir, "application_default_credentials.json");
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setProperty("os.name", "linux");
        testProvider.setProperty("user.home", homeDir.getAbsolutePath());
        testProvider.addFile(wellKnownFile.getAbsolutePath(), userStream);
        this.testUserProvidesToken(testProvider, USER_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN);
    }

    @Test
    public void getDefaultCredentials_wellKnownFileWindows_providesToken() throws IOException {
        File homeDir = DefaultCredentialsProviderTest.getTempDirectory();
        File cloudConfigDir = new File(homeDir, "gcloud");
        InputStream userStream = UserCredentialsTest.writeUserStream(USER_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        File wellKnownFile = new File(cloudConfigDir, "application_default_credentials.json");
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setProperty("os.name", "windows");
        testProvider.setEnv("APPDATA", homeDir.getAbsolutePath());
        testProvider.addFile(wellKnownFile.getAbsolutePath(), userStream);
        this.testUserProvidesToken(testProvider, USER_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN);
    }

    @Test
    public void getDefaultCredentials_envAndWellKnownFile_envPrecedence() throws IOException {
        String refreshTokenEnv = "2/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        String accessTokenEnv = "2/MkSJoj1xsli0AccessToken_NKPY2";
        String refreshTokenWkf = "3/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        String accessTokenWkf = "3/MkSJoj1xsli0AccessToken_NKPY2";
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        InputStream envStream = UserCredentialsTest.writeUserStream(USER_CLIENT_ID, USER_CLIENT_SECRET, "2/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", QUOTA_PROJECT);
        String envPath = this.tempFilePath("env.json");
        testProvider.setEnv("GOOGLE_APPLICATION_CREDENTIALS", envPath);
        testProvider.addFile(envPath, envStream);
        File homeDir = DefaultCredentialsProviderTest.getTempDirectory();
        File configDir = new File(homeDir, ".config");
        File cloudConfigDir = new File(configDir, "gcloud");
        InputStream wkfStream = UserCredentialsTest.writeUserStream(USER_CLIENT_ID, USER_CLIENT_SECRET, "3/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", QUOTA_PROJECT);
        File wellKnownFile = new File(cloudConfigDir, "application_default_credentials.json");
        testProvider.setProperty("os.name", "linux");
        testProvider.setProperty("user.home", homeDir.getAbsolutePath());
        testProvider.addFile(wellKnownFile.getAbsolutePath(), wkfStream);
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(USER_CLIENT_ID, USER_CLIENT_SECRET);
        transportFactory.transport.addRefreshToken("3/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", "3/MkSJoj1xsli0AccessToken_NKPY2");
        transportFactory.transport.addRefreshToken("2/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", "2/MkSJoj1xsli0AccessToken_NKPY2");
        this.testUserProvidesToken(testProvider, transportFactory, "2/MkSJoj1xsli0AccessToken_NKPY2");
    }

    private String tempFilePath(String filename) {
        return Paths.get(System.getProperty("java.io.tmpdir"), filename).toString();
    }

    @Test
    public void getDefaultCredentials_wellKnownFile_logsGcloudWarning() throws IOException {
        LogRecord message = this.getCredentialsAndReturnLogMessage(false);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)Level.WARNING, (Object)message.getLevel());
        Assert.assertTrue((boolean)message.getMessage().contains("end user credentials from Google Cloud SDK"));
    }

    @Test
    public void getDefaultCredentials_wellKnownFile_suppressGcloudWarning() throws IOException {
        LogRecord message = this.getCredentialsAndReturnLogMessage(true);
        Assert.assertNull((Object)message);
    }

    private LogRecord getCredentialsAndReturnLogMessage(boolean suppressWarning) throws IOException {
        Logger logger = Logger.getLogger(DefaultCredentialsProvider.class.getName());
        LogHandler handler = new LogHandler();
        logger.addHandler(handler);
        File homeDir = DefaultCredentialsProviderTest.getTempDirectory();
        File configDir = new File(homeDir, ".config");
        File cloudConfigDir = new File(configDir, "gcloud");
        InputStream userStream = UserCredentialsTest.writeUserStream(GCLOUDSDK_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        File wellKnownFile = new File(cloudConfigDir, "application_default_credentials.json");
        TestDefaultCredentialsProvider testProvider = new TestDefaultCredentialsProvider();
        testProvider.setEnv("SUPPRESS_GCLOUD_CREDS_WARNING", Boolean.toString(suppressWarning));
        testProvider.setProperty("os.name", "linux");
        testProvider.setProperty("user.home", homeDir.getAbsolutePath());
        testProvider.addFile(wellKnownFile.getAbsolutePath(), userStream);
        this.testUserProvidesToken(testProvider, GCLOUDSDK_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN);
        return handler.getRecord();
    }

    private static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    private void testUserProvidesToken(TestDefaultCredentialsProvider testProvider, String clientId, String clientSecret, String refreshToken) throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(clientId, clientSecret);
        transportFactory.transport.addRefreshToken(refreshToken, ACCESS_TOKEN);
        this.testUserProvidesToken(testProvider, transportFactory, ACCESS_TOKEN);
    }

    private void testUserProvidesToken(TestDefaultCredentialsProvider testProvider, HttpTransportFactory transportFactory, String accessToken) throws IOException {
        GoogleCredentials defaultCredentials = testProvider.getDefaultCredentials(transportFactory);
        Assert.assertNotNull((Object)defaultCredentials);
        Map metadata = defaultCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, accessToken);
    }

    private static class TestDefaultCredentialsProvider
    extends DefaultCredentialsProvider {
        private final Map<String, Class<?>> types = new HashMap();
        private final Map<String, String> variables = new HashMap<String, String>();
        private final Map<String, String> properties = new HashMap<String, String>();
        private final Map<String, InputStream> files = new HashMap<String, InputStream>();
        private boolean fileSandbox = false;

        TestDefaultCredentialsProvider() {
        }

        void addFile(String file, InputStream stream) {
            this.files.put(file, stream);
        }

        void addType(String className, Class<?> type) {
            this.types.put(className, type);
        }

        String getEnv(String name) {
            return this.variables.get(name);
        }

        void setEnv(String name, String value) {
            this.variables.put(name, value);
        }

        String getProperty(String property, String def) {
            String value = this.properties.get(property);
            return value == null ? def : value;
        }

        void setProperty(String property, String value) {
            this.properties.put(property, value);
        }

        Class<?> forName(String className) throws ClassNotFoundException {
            Class<?> lookup = this.types.get(className);
            if (lookup != null) {
                return lookup;
            }
            throw new ClassNotFoundException("TestDefaultCredentialProvider: Class not found.");
        }

        protected boolean isOnGAEStandard7() {
            return this.getProperty("isOnGAEStandard7", "false").equals("true");
        }

        boolean isFile(File file) {
            if (this.fileSandbox) {
                throw new AccessControlException("No file permission.");
            }
            return this.files.containsKey(file.getAbsolutePath());
        }

        InputStream readStream(File file) throws FileNotFoundException {
            if (this.fileSandbox) {
                throw new AccessControlException("No file permission.");
            }
            InputStream stream = this.files.get(file.getAbsolutePath());
            if (stream == null) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            return stream;
        }

        void setFileSandbox(boolean fileSandbox) {
            this.fileSandbox = fileSandbox;
        }
    }

    private static class MockRequestCountingTransport
    extends MockHttpTransport {
        int requestCount = 0;

        MockRequestCountingTransport() {
        }

        int getRequestCount() {
            return this.requestCount;
        }

        public LowLevelHttpRequest buildRequest(String method, String url) {
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    ++MockRequestCountingTransport.this.requestCount;
                    throw new IOException("MockRequestCountingTransport request failed.");
                }
            };
        }
    }

    public static class MockEnvironment {
        private MockEnvironmentEnum innerValue;

        MockEnvironment(MockEnvironmentEnum value) {
            this.innerValue = value;
        }

        public MockEnvironmentEnum value() {
            return this.innerValue;
        }
    }

    private static enum MockEnvironmentEnum {
        Production,
        Development;

    }

    private static class MockOffAppEngineSystemProperty {
        public static final MockEnvironment environment = new MockEnvironment(null);

        private MockOffAppEngineSystemProperty() {
        }
    }

    private static class MockAppEngineSystemProperty {
        public static final MockEnvironment environment = new MockEnvironment(MockEnvironmentEnum.Production);

        private MockAppEngineSystemProperty() {
        }
    }

    public static class MockAppEngineCredentials
    extends GoogleCredentials {
        private static final long serialVersionUID = 2695173591854484322L;

        public MockAppEngineCredentials(Collection<String> scopes) {
        }

        public AccessToken refreshAccessToken() throws IOException {
            return null;
        }
    }

    private class LogHandler
    extends Handler {
        LogRecord lastRecord;

        private LogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            this.lastRecord = record;
        }

        public LogRecord getRecord() {
            return this.lastRecord;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }

    static class MockRequestCountingTransportFactory
    implements HttpTransportFactory {
        MockRequestCountingTransport transport = new MockRequestCountingTransport();

        MockRequestCountingTransportFactory() {
        }

        public HttpTransport create() {
            return this.transport;
        }
    }
}

