/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.MockTokenServerTransport;
import com.google.auth.oauth2.ServiceAccountCredentialsTest;
import com.google.auth.oauth2.UserCredentialsTest;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCredentialsTest {
    private static final String SA_CLIENT_EMAIL = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr@developer.gserviceaccount.com";
    private static final String SA_CLIENT_ID = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com";
    private static final String SA_PRIVATE_KEY_ID = "d84a4fefcf50791d4a90f2d7af17469d6282df9d";
    private static final String SA_PRIVATE_KEY_PKCS8 = "-----BEGIN PRIVATE KEY-----\nMIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALX0PQoe1igW12ikv1bN/r9lN749y2ijmbc/mFHPyS3hNTyOCjDvBbXYbDhQJzWVUikh4mvGBA07qTj79Xc3yBDfKP2IeyYQIFe0t0zkd7R9Zdn98Y2rIQC47aAbDfubtkU1U72t4zL11kHvoa0/RuFZjncvlr42X7be7lYh4p3NAgMBAAECgYASk5wDw4Az2ZkmeuN6Fk/y9H+Lcb2pskJIXjrL533vrDWGOC48LrsThMQPv8cxBky8HFSEklPpkfTF95tpD43iVwJRB/GrCtGTw65IfJ4/tI09h6zGc4yqvIo1cHX/LQ+SxKLGyir/dQM925rGt/VojxY5ryJR7GLbCzxPnJm/oQJBANwOCO6D2hy1LQYJhXh7O+RLtA/tSnT1xyMQsGT+uUCMiKS2bSKx2wxo9k7h3OegNJIu1q6nZ6AbxDK8H3+d0dUCQQDTrPSXagBxzp8PecbaCHjzNRSQE2in81qYnrAFNB4o3DpHyMMY6s5ALLeHKscEWnqP8Ur6X4PvzZecCWU9BKAZAkAutLPknAuxSCsUOvUfS1i87ex77Ot+w6POp34pEX+UWb+u5iFn2cQacDTHLV1LtE80L8jVLSbrbrlH43H0DjU5AkEAgidhycxS86dxpEljnOMCw8CKoUBd5I880IUahEiUltk7OLJYS/Ts1wbn3kPOVX3wyJs8WBDtBkFrDHW2ezth2QJADj3e1YhMVdjJW5jqwlD/VNddGjgzyunmiZg0uOXsHXbytYmsA545S8KRQFaJKFXYYFo2kOjqOiC1T2cAzMDjCQ==\n-----END PRIVATE KEY-----\n";
    private static final String USER_CLIENT_SECRET = "jakuaL9YyieakhECKL2SwZcu";
    private static final String USER_CLIENT_ID = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
    private static final String REFRESH_TOKEN = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
    private static final String ACCESS_TOKEN = "1/MkSJoj1xsli0AccessToken_NKPY2";
    private static final HttpTransportFactory DUMMY_TRANSPORT_FACTORY = new MockTokenServerTransportFactory();
    private static final URI CALL_URI = URI.create("http://googleapis.com/testapi/v1/foo");
    private static final String QUOTA_PROJECT = "sample-quota-project-id";
    private static final Collection<String> SCOPES = Collections.unmodifiableCollection(Arrays.asList("scope1", "scope2"));

    @Test
    public void getApplicationDefault_nullTransport_throws() throws IOException {
        try {
            GoogleCredentials.getApplicationDefault(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromStream_nullTransport_throws() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream("foo".getBytes());
        try {
            GoogleCredentials.fromStream((InputStream)stream, null);
            Assert.fail((String)"Should throw if HttpTransportFactory is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromStream_nullStream_throws() throws IOException {
        MockHttpTransportFactory transportFactory = new MockHttpTransportFactory();
        try {
            GoogleCredentials.fromStream(null, (HttpTransportFactory)transportFactory);
            Assert.fail((String)"Should throw if InputStream is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromStream_serviceAccount_providesToken() throws IOException {
        MockTokenServerTransportFactory transportFactory = new MockTokenServerTransportFactory();
        transportFactory.transport.addServiceAccount(SA_CLIENT_EMAIL, ACCESS_TOKEN);
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(SA_CLIENT_ID, SA_CLIENT_EMAIL, SA_PRIVATE_KEY_PKCS8, SA_PRIVATE_KEY_ID);
        GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)serviceAccountStream, (HttpTransportFactory)transportFactory);
        Assert.assertNotNull((Object)credentials);
        credentials = credentials.createScoped(SCOPES);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void fromStream_serviceAccountNoClientId_throws() throws IOException {
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(null, SA_CLIENT_EMAIL, SA_PRIVATE_KEY_PKCS8, SA_PRIVATE_KEY_ID);
        GoogleCredentialsTest.testFromStreamException(serviceAccountStream, "client_id");
    }

    @Test
    public void fromStream_serviceAccountNoClientEmail_throws() throws IOException {
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(SA_CLIENT_ID, null, SA_PRIVATE_KEY_PKCS8, SA_PRIVATE_KEY_ID);
        GoogleCredentialsTest.testFromStreamException(serviceAccountStream, "client_email");
    }

    @Test
    public void fromStream_serviceAccountNoPrivateKey_throws() throws IOException {
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(SA_CLIENT_ID, SA_CLIENT_EMAIL, null, SA_PRIVATE_KEY_ID);
        GoogleCredentialsTest.testFromStreamException(serviceAccountStream, "private_key");
    }

    @Test
    public void fromStream_serviceAccountNoPrivateKeyId_throws() throws IOException {
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(SA_CLIENT_ID, SA_CLIENT_EMAIL, SA_PRIVATE_KEY_PKCS8, null);
        GoogleCredentialsTest.testFromStreamException(serviceAccountStream, "private_key_id");
    }

    @Test
    public void fromStream_user_providesToken() throws IOException {
        MockTokenServerTransportFactory transportFactory = new MockTokenServerTransportFactory();
        transportFactory.transport.addClient(USER_CLIENT_ID, USER_CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        InputStream userStream = UserCredentialsTest.writeUserStream(USER_CLIENT_ID, USER_CLIENT_SECRET, REFRESH_TOKEN, null);
        GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)userStream, (HttpTransportFactory)transportFactory);
        Assert.assertNotNull((Object)credentials);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void fromStream_userNoClientId_throws() throws IOException {
        InputStream userStream = UserCredentialsTest.writeUserStream(null, USER_CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        GoogleCredentialsTest.testFromStreamException(userStream, "client_id");
    }

    @Test
    public void fromStream_userNoClientSecret_throws() throws IOException {
        InputStream userStream = UserCredentialsTest.writeUserStream(USER_CLIENT_ID, null, REFRESH_TOKEN, QUOTA_PROJECT);
        GoogleCredentialsTest.testFromStreamException(userStream, "client_secret");
    }

    @Test
    public void fromStream_userNoRefreshToken_throws() throws IOException {
        InputStream userStream = UserCredentialsTest.writeUserStream(USER_CLIENT_ID, USER_CLIENT_SECRET, null, QUOTA_PROJECT);
        GoogleCredentialsTest.testFromStreamException(userStream, "refresh_token");
    }

    @Test
    public void createScoped_overloadCallsImplementation() {
        final AtomicReference called = new AtomicReference();
        final GoogleCredentials expectedScopedCredentials = new GoogleCredentials();
        GoogleCredentials credentials = new GoogleCredentials(){

            public GoogleCredentials createScoped(Collection<String> scopes) {
                called.set(scopes);
                return expectedScopedCredentials;
            }
        };
        GoogleCredentials scopedCredentials = credentials.createScoped(new String[]{"foo", "bar"});
        Assert.assertEquals((Object)expectedScopedCredentials, (Object)scopedCredentials);
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar"), called.get());
    }

    private static void testFromStreamException(InputStream stream, String expectedMessageContent) {
        try {
            GoogleCredentials.fromStream((InputStream)stream, (HttpTransportFactory)DUMMY_TRANSPORT_FACTORY);
            Assert.fail((String)String.format("Should throw exception with message containing '%s'", expectedMessageContent));
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains(expectedMessageContent));
        }
    }

    public static class MockTokenServerTransportFactory
    implements HttpTransportFactory {
        public MockTokenServerTransport transport = new MockTokenServerTransport();

        public HttpTransport create() {
            return this.transport;
        }
    }

    static class MockHttpTransportFactory
    implements HttpTransportFactory {
        MockHttpTransport transport = new MockHttpTransport();

        MockHttpTransportFactory() {
        }

        public HttpTransport create() {
            return this.transport;
        }
    }
}

