/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.ComputeEngineCredentialsTest;
import com.google.auth.oauth2.IdTokenCredentials;
import com.google.auth.oauth2.IdTokenProvider;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IdTokenCredentialsTest
extends BaseSerializationTest {
    @Test
    public void hashCode_equals() throws IOException {
        ComputeEngineCredentialsTest.MockMetadataServerTransportFactory transportFactory = new ComputeEngineCredentialsTest.MockMetadataServerTransportFactory();
        transportFactory.transport.setIdToken("eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMDIxMDE1NTA4MzQyMDA3MDg1NjgiLCJleHAiOjE1NjQ0NzUwNTEsImlhdCI6MTU2NDQ3MTQ1MSwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwic3ViIjoiMTAyMTAxNTUwODM0MjAwNzA4NTY4In0.redacted");
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).setTargetAudience(targetAudience).build();
        tokenCredential.refresh();
        IdTokenCredentials otherCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).setTargetAudience(targetAudience).build();
        otherCredential.refresh();
        Assert.assertEquals((Object)tokenCredential, (Object)tokenCredential.toBuilder().build());
        Assert.assertEquals((long)tokenCredential.hashCode(), (long)otherCredential.hashCode());
    }

    @Test
    public void toString_equals() throws IOException {
        ComputeEngineCredentialsTest.MockMetadataServerTransportFactory transportFactory = new ComputeEngineCredentialsTest.MockMetadataServerTransportFactory();
        transportFactory.transport.setIdToken("eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMDIxMDE1NTA4MzQyMDA3MDg1NjgiLCJleHAiOjE1NjQ0NzUwNTEsImlhdCI6MTU2NDQ3MTQ1MSwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwic3ViIjoiMTAyMTAxNTUwODM0MjAwNzA4NTY4In0.redacted");
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).setTargetAudience(targetAudience).build();
        tokenCredential.refresh();
        IdTokenCredentials otherCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).setTargetAudience(targetAudience).build();
        otherCredential.refresh();
        Assert.assertEquals((Object)tokenCredential.toString(), (Object)otherCredential.toString());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        ComputeEngineCredentialsTest.MockMetadataServerTransportFactory transportFactory = new ComputeEngineCredentialsTest.MockMetadataServerTransportFactory();
        transportFactory.transport.setIdToken("eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMDIxMDE1NTA4MzQyMDA3MDg1NjgiLCJleHAiOjE1NjQ0NzUwNTEsImlhdCI6MTU2NDQ3MTQ1MSwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwic3ViIjoiMTAyMTAxNTUwODM0MjAwNzA4NTY4In0.redacted");
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).setTargetAudience(targetAudience).build();
        tokenCredential.refresh();
        IdTokenCredentials deserializedCredentials = this.serializeAndDeserialize(tokenCredential);
        Assert.assertEquals((Object)tokenCredential, (Object)deserializedCredentials);
    }
}

