/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonGenerator;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.util.Clock;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.IdTokenCredentials;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.auth.oauth2.MockIAMCredentialsServiceTransport;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ImpersonatedCredentialsTest
extends BaseSerializationTest {
    private static final String SA_CLIENT_EMAIL = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr@developer.gserviceaccount.com";
    private static final String SA_PRIVATE_KEY_ID = "d84a4fefcf50791d4a90f2d7af17469d6282df9d";
    static final String SA_PRIVATE_KEY_PKCS8 = "-----BEGIN PRIVATE KEY-----\nMIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALX0PQoe1igW12ikv1bN/r9lN749y2ijmbc/mFHPyS3hNTyOCjDvBbXYbDhQJzWVUikh4mvGBA07qTj79Xc3yBDfKP2IeyYQIFe0t0zkd7R9Zdn98Y2rIQC47aAbDfubtkU1U72t4zL11kHvoa0/RuFZjncvlr42X7be7lYh4p3NAgMBAAECgYASk5wDw4Az2ZkmeuN6Fk/y9H+Lcb2pskJIXjrL533vrDWGOC48LrsThMQPv8cxBky8HFSEklPpkfTF95tpD43iVwJRB/GrCtGTw65IfJ4/tI09h6zGc4yqvIo1cHX/LQ+SxKLGyir/dQM925rGt/VojxY5ryJR7GLbCzxPnJm/oQJBANwOCO6D2hy1LQYJhXh7O+RLtA/tSnT1xyMQsGT+uUCMiKS2bSKx2wxo9k7h3OegNJIu1q6nZ6AbxDK8H3+d0dUCQQDTrPSXagBxzp8PecbaCHjzNRSQE2in81qYnrAFNB4o3DpHyMMY6s5ALLeHKscEWnqP8Ur6X4PvzZecCWU9BKAZAkAutLPknAuxSCsUOvUfS1i87ex77Ot+w6POp34pEX+UWb+u5iFn2cQacDTHLV1LtE80L8jVLSbrbrlH43H0DjU5AkEAgidhycxS86dxpEljnOMCw8CKoUBd5I880IUahEiUltk7OLJYS/Ts1wbn3kPOVX3wyJs8WBDtBkFrDHW2ezth2QJADj3e1YhMVdjJW5jqwlD/VNddGjgzyunmiZg0uOXsHXbytYmsA545S8KRQFaJKFXYYFo2kOjqOiC1T2cAzMDjCQ==\n-----END PRIVATE KEY-----\n";
    public static final String STANDARD_ID_TOKEN = "eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMDIxMDE1NTA4MzQyMDA3MDg1NjgiLCJleHAiOjE1NjQ1MzI5NzIsImlhdCI6MTU2NDUyOTM3MiwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwic3ViIjoiMTAyMTAxNTUwODM0MjAwNzA4NTY4In0.redacted";
    public static final String TOKEN_WITH_EMAIL = "eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMDIxMDE1NTA4MzQyMDA3MDg1NjgiLCJlbWFpbCI6ImltcGVyc29uYXRlZC1hY2NvdW50QGZhYmxlZC1yYXktMTA0MTE3LmlhbS5nc2VydmljZWFjY291bnQuY29tIiwiZW1haWxfdmVyaWZpZWQiOnRydWUsImV4cCI6MTU2NDUzMzA0MiwiaWF0IjoxNTY0NTI5NDQyLCJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJzdWIiOiIxMDIxMDE1NTA4MzQyMDA3MDg1NjgifQ.redacted";
    private static final String PROJECT_ID = "project-id";
    private static final String IMPERSONATED_CLIENT_EMAIL = "impersonated-account@iam.gserviceaccount.com";
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/devstorage.read_only");
    private static final String ACCESS_TOKEN = "1/MkSJoj1xsli0AccessToken_NKPY2";
    private static final int VALID_LIFETIME = 300;
    private static final int INVALID_LIFETIME = 3800;
    private static JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final String RFC3339 = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    private GoogleCredentials getSourceCredentials() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountCredentials sourceCredentials = ServiceAccountCredentials.newBuilder().setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setScopes(SCOPES).setProjectId(PROJECT_ID).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        transportFactory.transport.addServiceAccount(SA_CLIENT_EMAIL, ACCESS_TOKEN);
        return sourceCredentials;
    }

    @Test
    public void refreshAccessToken_unauthorized() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        String expectedMessage = "The caller does not have permission";
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setTokenResponseErrorCode(401);
        mtransportFactory.transport.setTokenResponseErrorContent(this.generateErrorJson(401, expectedMessage, "global", "forbidden"));
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        try {
            targetCredentials.refreshAccessToken().getTokenValue();
            Assert.fail((String)String.format("Should throw exception with message containing '%s'", expectedMessage));
        }
        catch (IOException expected) {
            Assert.assertEquals((Object)"Error requesting access token", (Object)expected.getMessage());
            Assert.assertTrue((boolean)expected.getCause().getMessage().contains(expectedMessage));
        }
    }

    @Test
    public void refreshAccessToken_malformedTarget() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        String invalidTargetEmail = "foo";
        String expectedMessage = "Request contains an invalid argument";
        mtransportFactory.transport.setTargetPrincipal(invalidTargetEmail);
        mtransportFactory.transport.setTokenResponseErrorCode(400);
        mtransportFactory.transport.setTokenResponseErrorContent(this.generateErrorJson(400, expectedMessage, "global", "badRequest"));
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)invalidTargetEmail, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        try {
            targetCredentials.refreshAccessToken().getTokenValue();
            Assert.fail((String)String.format("Should throw exception with message containing '%s'", expectedMessage));
        }
        catch (IOException expected) {
            Assert.assertEquals((Object)"Error requesting access token", (Object)expected.getMessage());
            Assert.assertTrue((boolean)expected.getCause().getMessage().contains(expectedMessage));
        }
    }

    @Test
    public void credential_with_invalid_lifetime() throws IOException, IllegalStateException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        try {
            ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)3800);
            targetCredentials.refreshAccessToken().getTokenValue();
            Assert.fail((String)String.format("Should throw exception with message containing '%s'", "lifetime must be less than or equal to 3600"));
        }
        catch (IllegalStateException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("lifetime must be less than or equal to 3600"));
        }
    }

    @Test
    public void credential_with_invalid_scope() throws IOException, IllegalStateException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        try {
            ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, null, (int)300);
            targetCredentials.refreshAccessToken().getTokenValue();
            Assert.fail((String)String.format("Should throw exception with message containing '%s'", "Scopes cannot be null"));
        }
        catch (IllegalStateException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("Scopes cannot be null"));
        }
    }

    @Test
    public void refreshAccessToken_success() throws IOException, IllegalStateException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        Assert.assertEquals((Object)ACCESS_TOKEN, (Object)targetCredentials.refreshAccessToken().getTokenValue());
    }

    @Test
    public void refreshAccessToken_delegates_success() throws IOException, IllegalStateException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        List<String> delegates = Arrays.asList("delegate-account@iam.gserviceaccount.com");
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, delegates, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        Assert.assertEquals((Object)ACCESS_TOKEN, (Object)targetCredentials.refreshAccessToken().getTokenValue());
    }

    @Test
    public void refreshAccessToken_invalidDate() throws IOException, IllegalStateException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        String expectedMessage = "Unparseable date";
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken("foo");
        mtransportFactory.transport.setExpireTime("1973-09-29T15:01:23");
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        try {
            targetCredentials.refreshAccessToken().getTokenValue();
            Assert.fail((String)String.format("Should throw exception with message containing '%s'", expectedMessage));
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains(expectedMessage));
        }
    }

    @Test
    public void getAccount_sameAs() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        Assert.assertEquals((Object)IMPERSONATED_CLIENT_EMAIL, (Object)targetCredentials.getAccount());
    }

    @Test
    public void sign_sameAs() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        byte[] expectedSignature = new byte[]{13, 14, 10, 13};
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setSignedBlob(expectedSignature);
        Assert.assertArrayEquals((byte[])expectedSignature, (byte[])targetCredentials.sign(expectedSignature));
    }

    @Test
    public void sign_requestIncludesDelegates() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, (List)ImmutableList.of((Object)"delegate@example.com"), SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        byte[] expectedSignature = new byte[]{13, 14, 10, 13};
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setSignedBlob(expectedSignature);
        Assert.assertArrayEquals((byte[])expectedSignature, (byte[])targetCredentials.sign(expectedSignature));
        MockLowLevelHttpRequest request = mtransportFactory.transport.getRequest();
        GenericJson body = (GenericJson)JSON_FACTORY.createJsonParser(request.getContentAsString()).parseAndClose(GenericJson.class);
        ArrayList<String> delegates = new ArrayList<String>();
        delegates.add("delegate@example.com");
        Assert.assertEquals(delegates, (Object)body.get((Object)"delegates"));
    }

    @Test
    public void sign_usesSourceCredentials() throws IOException {
        Date expiry = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(expiry);
        c.add(5, 1);
        expiry = c.getTime();
        GoogleCredentials sourceCredentials = new GoogleCredentials.Builder().setAccessToken(new AccessToken("source-token", expiry)).build();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, (List)ImmutableList.of((Object)"delegate@example.com"), SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        byte[] expectedSignature = new byte[]{13, 14, 10, 13};
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setSignedBlob(expectedSignature);
        Assert.assertArrayEquals((byte[])expectedSignature, (byte[])targetCredentials.sign(expectedSignature));
        MockLowLevelHttpRequest request = mtransportFactory.transport.getRequest();
        Assert.assertEquals((Object)"Bearer source-token", (Object)request.getFirstHeaderValue("Authorization"));
    }

    @Test
    public void sign_accessDenied_throws() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        byte[] expectedSignature = new byte[]{13, 14, 10, 13};
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setSignedBlob(expectedSignature);
        mtransportFactory.transport.setErrorResponseCodeAndMessage(403, "Sign Error");
        try {
            byte[] bytes = new byte[]{13, 14, 10, 13};
            targetCredentials.sign(bytes);
            Assert.fail((String)"Signing should have failed");
        }
        catch (ServiceAccountSigner.SigningException e) {
            Assert.assertEquals((Object)"Failed to sign the provided bytes", (Object)e.getMessage());
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("403"));
        }
    }

    @Test
    public void sign_serverError_throws() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        byte[] expectedSignature = new byte[]{13, 14, 10, 13};
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setSignedBlob(expectedSignature);
        mtransportFactory.transport.setErrorResponseCodeAndMessage(500, "Sign Error");
        try {
            byte[] bytes = new byte[]{13, 14, 10, 13};
            targetCredentials.sign(bytes);
            Assert.fail((String)"Signing should have failed");
        }
        catch (ServiceAccountSigner.SigningException e) {
            Assert.assertEquals((Object)"Failed to sign the provided bytes", (Object)e.getMessage());
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("500"));
        }
    }

    @Test
    public void idTokenWithAudience_sameAs() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        mtransportFactory.transport.setIdToken(STANDARD_ID_TOKEN);
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)targetCredentials).setTargetAudience(targetAudience).build();
        tokenCredential.refresh();
        Assert.assertEquals((Object)STANDARD_ID_TOKEN, (Object)tokenCredential.getAccessToken().getTokenValue());
        Assert.assertEquals((Object)STANDARD_ID_TOKEN, (Object)tokenCredential.getIdToken().getTokenValue());
        Assert.assertEquals((Object)targetAudience, (Object)((String)tokenCredential.getIdToken().getJsonWebSignature().getPayload().getAudience()));
    }

    @Test
    public void idTokenWithAudience_withEmail() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        mtransportFactory.transport.setIdToken(TOKEN_WITH_EMAIL);
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)targetCredentials).setTargetAudience(targetAudience).setOptions(Arrays.asList(IdTokenProvider.Option.INCLUDE_EMAIL)).build();
        tokenCredential.refresh();
        Assert.assertEquals((Object)TOKEN_WITH_EMAIL, (Object)tokenCredential.getAccessToken().getTokenValue());
        JsonWebToken.Payload p = tokenCredential.getIdToken().getJsonWebSignature().getPayload();
        Assert.assertTrue((boolean)p.containsKey((Object)"email"));
    }

    @Test
    public void idToken_withServerError() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        mtransportFactory.transport.setIdToken(STANDARD_ID_TOKEN);
        mtransportFactory.transport.setErrorResponseCodeAndMessage(500, "Internal Server Error");
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)targetCredentials).setTargetAudience(targetAudience).build();
        try {
            tokenCredential.refresh();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Error code 500 trying to getIDToken"));
        }
    }

    @Test
    public void idToken_withOtherError() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        mtransportFactory.transport.setIdToken(STANDARD_ID_TOKEN);
        mtransportFactory.transport.setErrorResponseCodeAndMessage(301, "Redirect");
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)targetCredentials).setTargetAudience(targetAudience).build();
        try {
            tokenCredential.refresh();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unexpected Error code 301 trying to getIDToken"));
        }
    }

    @Test
    public void hashCode_equals() throws IOException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials credentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        ImpersonatedCredentials otherCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        Assert.assertEquals((long)credentials.hashCode(), (long)otherCredentials.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        GoogleCredentials sourceCredentials = this.getSourceCredentials();
        MockIAMCredentialsServiceTransportFactory mtransportFactory = new MockIAMCredentialsServiceTransportFactory();
        mtransportFactory.transport.setTargetPrincipal(IMPERSONATED_CLIENT_EMAIL);
        mtransportFactory.transport.setAccessToken(ACCESS_TOKEN);
        mtransportFactory.transport.setExpireTime(this.getDefaultExpireTime());
        ImpersonatedCredentials targetCredentials = ImpersonatedCredentials.create((GoogleCredentials)sourceCredentials, (String)IMPERSONATED_CLIENT_EMAIL, null, SCOPES, (int)300, (HttpTransportFactory)mtransportFactory);
        GoogleCredentials deserializedCredentials = (GoogleCredentials)this.serializeAndDeserialize(targetCredentials);
        Assert.assertEquals((Object)targetCredentials, (Object)deserializedCredentials);
        Assert.assertEquals((long)targetCredentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)targetCredentials.toString(), (Object)deserializedCredentials.toString());
        Assert.assertSame((Object)deserializedCredentials.clock, (Object)Clock.SYSTEM);
    }

    private String getDefaultExpireTime() {
        Date currentDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(currentDate);
        c.add(13, 300);
        return new SimpleDateFormat(RFC3339).format(c.getTime());
    }

    private String generateErrorJson(int errorCode, String errorMessage, String errorDomain, String errorReason) throws IOException {
        JacksonFactory factory = new JacksonFactory();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createJsonGenerator((OutputStream)bout, Charset.defaultCharset());
        generator.enablePrettyPrint();
        generator.writeStartObject();
        generator.writeFieldName("error");
        generator.writeStartObject();
        generator.writeFieldName("code");
        generator.writeNumber(errorCode);
        generator.writeFieldName("message");
        generator.writeString(errorMessage);
        generator.writeFieldName("errors");
        generator.writeStartArray();
        generator.writeStartObject();
        generator.writeFieldName("message");
        generator.writeString(errorMessage);
        generator.writeFieldName("domain");
        generator.writeString(errorDomain);
        generator.writeFieldName("reason");
        generator.writeString(errorReason);
        generator.writeEndObject();
        generator.writeEndArray();
        generator.writeFieldName("status");
        generator.writeString("PERMISSION_DENIED");
        generator.writeEndObject();
        generator.writeEndObject();
        generator.close();
        return bout.toString();
    }

    static class MockIAMCredentialsServiceTransportFactory
    implements HttpTransportFactory {
        MockIAMCredentialsServiceTransport transport = new MockIAMCredentialsServiceTransport();

        MockIAMCredentialsServiceTransportFactory() {
        }

        public HttpTransport create() {
            return this.transport;
        }
    }
}

