/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.Clock;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.JwtClaims;
import com.google.auth.oauth2.JwtCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JwtCredentialsTest
extends BaseSerializationTest {
    private static final String PRIVATE_KEY_ID = "d84a4fefcf50791d4a90f2d7af17469d6282df9d";
    private static final String PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----\nMIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALX0PQoe1igW12ikv1bN/r9lN749y2ijmbc/mFHPyS3hNTyOCjDvBbXYbDhQJzWVUikh4mvGBA07qTj79Xc3yBDfKP2IeyYQIFe0t0zkd7R9Zdn98Y2rIQC47aAbDfubtkU1U72t4zL11kHvoa0/RuFZjncvlr42X7be7lYh4p3NAgMBAAECgYASk5wDw4Az2ZkmeuN6Fk/y9H+Lcb2pskJIXjrL533vrDWGOC48LrsThMQPv8cxBky8HFSEklPpkfTF95tpD43iVwJRB/GrCtGTw65IfJ4/tI09h6zGc4yqvIo1cHX/LQ+SxKLGyir/dQM925rGt/VojxY5ryJR7GLbCzxPnJm/oQJBANwOCO6D2hy1LQYJhXh7O+RLtA/tSnT1xyMQsGT+uUCMiKS2bSKx2wxo9k7h3OegNJIu1q6nZ6AbxDK8H3+d0dUCQQDTrPSXagBxzp8PecbaCHjzNRSQE2in81qYnrAFNB4o3DpHyMMY6s5ALLeHKscEWnqP8Ur6X4PvzZecCWU9BKAZAkAutLPknAuxSCsUOvUfS1i87ex77Ot+w6POp34pEX+UWb+u5iFn2cQacDTHLV1LtE80L8jVLSbrbrlH43H0DjU5AkEAgidhycxS86dxpEljnOMCw8CKoUBd5I880IUahEiUltk7OLJYS/Ts1wbn3kPOVX3wyJs8WBDtBkFrDHW2ezth2QJADj3e1YhMVdjJW5jqwlD/VNddGjgzyunmiZg0uOXsHXbytYmsA545S8KRQFaJKFXYYFo2kOjqOiC1T2cAzMDjCQ==\n-----END PRIVATE KEY-----\n";
    private static final String JWT_ACCESS_PREFIX = "Bearer ";
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();

    static PrivateKey getPrivateKey() {
        try {
            return ServiceAccountCredentials.privateKeyFromPkcs8((String)PRIVATE_KEY);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        JwtClaims claims = JwtClaims.newBuilder().setAudience("some-audience").setIssuer("some-issuer").setSubject("some-subject").build();
        JwtCredentials credentials = JwtCredentials.newBuilder().setJwtClaims(claims).setPrivateKey(JwtCredentialsTest.getPrivateKey()).setPrivateKeyId(PRIVATE_KEY_ID).build();
        JwtCredentials deserializedCredentials = this.serializeAndDeserialize(credentials);
        Assert.assertEquals((Object)credentials, (Object)deserializedCredentials);
        Assert.assertEquals((long)credentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)credentials.toString(), (Object)deserializedCredentials.toString());
        Assert.assertSame((Object)deserializedCredentials.getClock(), (Object)Clock.SYSTEM);
    }

    @Test
    public void builder_requiresPrivateKey() {
        try {
            JwtClaims claims = JwtClaims.newBuilder().setAudience("some-audience").setIssuer("some-issuer").setSubject("some-subject").build();
            JwtCredentials.newBuilder().setJwtClaims(claims).setPrivateKeyId(PRIVATE_KEY_ID).build();
            Assert.fail((String)"Should throw exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void builder_requiresClaims() {
        try {
            JwtCredentials.newBuilder().setPrivateKeyId(PRIVATE_KEY_ID).setPrivateKey(JwtCredentialsTest.getPrivateKey()).build();
            Assert.fail((String)"Should throw exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void builder_requiresCompleteClaims() {
        try {
            JwtClaims claims = JwtClaims.newBuilder().build();
            JwtCredentials.newBuilder().setJwtClaims(claims).setPrivateKeyId(PRIVATE_KEY_ID).setPrivateKey(JwtCredentialsTest.getPrivateKey()).build();
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void jwtWithClaims_overwritesClaims() throws IOException {
        JwtClaims claims = JwtClaims.newBuilder().setAudience("some-audience").setIssuer("some-issuer").setSubject("some-subject").build();
        JwtCredentials credentials = JwtCredentials.newBuilder().setJwtClaims(claims).setPrivateKey(JwtCredentialsTest.getPrivateKey()).setPrivateKeyId(PRIVATE_KEY_ID).build();
        JwtClaims claims2 = JwtClaims.newBuilder().setAudience("some-audience2").setIssuer("some-issuer2").setSubject("some-subject2").build();
        JwtCredentials credentials2 = credentials.jwtWithClaims(claims2);
        Map metadata = credentials2.getRequestMetadata();
        this.verifyJwtAccess(metadata, "some-audience2", "some-issuer2", "some-subject2", PRIVATE_KEY_ID);
    }

    @Test
    public void jwtWithClaims_defaultsClaims() throws IOException {
        JwtClaims claims = JwtClaims.newBuilder().setAudience("some-audience").setIssuer("some-issuer").setSubject("some-subject").build();
        JwtCredentials credentials = JwtCredentials.newBuilder().setJwtClaims(claims).setPrivateKey(JwtCredentialsTest.getPrivateKey()).setPrivateKeyId(PRIVATE_KEY_ID).build();
        JwtClaims claims2 = JwtClaims.newBuilder().build();
        JwtCredentials credentials2 = credentials.jwtWithClaims(claims2);
        Map metadata = credentials2.getRequestMetadata();
        this.verifyJwtAccess(metadata, "some-audience", "some-issuer", "some-subject", PRIVATE_KEY_ID);
    }

    @Test
    public void getRequestMetadata_hasJwtAccess() throws IOException {
        JwtClaims claims = JwtClaims.newBuilder().setAudience("some-audience").setIssuer("some-issuer").setSubject("some-subject").build();
        JwtCredentials credentials = JwtCredentials.newBuilder().setJwtClaims(claims).setPrivateKey(JwtCredentialsTest.getPrivateKey()).setPrivateKeyId(PRIVATE_KEY_ID).build();
        Map metadata = credentials.getRequestMetadata();
        this.verifyJwtAccess(metadata, "some-audience", "some-issuer", "some-subject", PRIVATE_KEY_ID);
    }

    @Test
    public void getRequestMetadata_withAdditionalClaims_hasJwtAccess() throws IOException {
        JwtClaims claims = JwtClaims.newBuilder().setAudience("some-audience").setIssuer("some-issuer").setSubject("some-subject").setAdditionalClaims(Collections.singletonMap("foo", "bar")).build();
        JwtCredentials credentials = JwtCredentials.newBuilder().setJwtClaims(claims).setPrivateKey(JwtCredentialsTest.getPrivateKey()).setPrivateKeyId(PRIVATE_KEY_ID).build();
        Map metadata = credentials.getRequestMetadata();
        this.verifyJwtAccess(metadata, "some-audience", "some-issuer", "some-subject", PRIVATE_KEY_ID, Collections.singletonMap("foo", "bar"));
    }

    @Test
    public void privateKeyIdNull() throws IOException {
        JwtClaims claims = JwtClaims.newBuilder().setAudience("some-audience").setIssuer("some-issuer").setSubject("some-subject").build();
        JwtCredentials credentials = JwtCredentials.newBuilder().setJwtClaims(claims).setPrivateKey(JwtCredentialsTest.getPrivateKey()).setPrivateKeyId(null).build();
        Map metadata = credentials.getRequestMetadata();
        this.verifyJwtAccess(metadata, "some-audience", "some-issuer", "some-subject", null);
    }

    @Test
    public void privateKeyIdNotSpecified() throws IOException {
        JwtClaims claims = JwtClaims.newBuilder().setAudience("some-audience").setIssuer("some-issuer").setSubject("some-subject").build();
        JwtCredentials credentials = JwtCredentials.newBuilder().setJwtClaims(claims).setPrivateKey(JwtCredentialsTest.getPrivateKey()).build();
        Map metadata = credentials.getRequestMetadata();
        this.verifyJwtAccess(metadata, "some-audience", "some-issuer", "some-subject", null);
    }

    private void verifyJwtAccess(Map<String, List<String>> metadata, String expectedAudience, String expectedIssuer, String expectedSubject, String expectedKeyId) throws IOException {
        this.verifyJwtAccess(metadata, expectedAudience, expectedIssuer, expectedSubject, expectedKeyId, Collections.emptyMap());
    }

    private void verifyJwtAccess(Map<String, List<String>> metadata, String expectedAudience, String expectedIssuer, String expectedSubject, String expectedKeyId, Map<String, String> expectedAdditionalClaims) throws IOException {
        Assert.assertNotNull(metadata);
        List<String> authorizations = metadata.get("Authorization");
        Assert.assertNotNull((String)"Authorization headers not found", authorizations);
        String assertion = null;
        for (String authorization : authorizations) {
            if (!authorization.startsWith(JWT_ACCESS_PREFIX)) continue;
            Assert.assertNull((String)"Multiple bearer assertions found", assertion);
            assertion = authorization.substring(JWT_ACCESS_PREFIX.length());
        }
        Assert.assertNotNull((String)"Bearer assertion not found", assertion);
        JsonWebSignature signature = JsonWebSignature.parse((JsonFactory)JSON_FACTORY, assertion);
        Assert.assertEquals((Object)expectedIssuer, (Object)signature.getPayload().getIssuer());
        Assert.assertEquals((Object)expectedSubject, (Object)signature.getPayload().getSubject());
        Assert.assertEquals((Object)expectedAudience, (Object)signature.getPayload().getAudience());
        Assert.assertEquals((Object)expectedKeyId, (Object)signature.getHeader().getKeyId());
        for (Map.Entry<String, String> entry : expectedAdditionalClaims.entrySet()) {
            Assert.assertEquals((Object)entry.getValue(), (Object)signature.getPayload().get((Object)entry.getKey()));
        }
    }
}

