/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;

public class MockMetadataServerTransport
extends MockHttpTransport {
    private String accessToken;
    private Integer tokenRequestStatusCode;
    private String serviceAccountEmail;
    private String idToken;
    private byte[] signature;

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setTokenRequestStatusCode(Integer tokenRequestStatusCode) {
        this.tokenRequestStatusCode = tokenRequestStatusCode;
    }

    public void setServiceAccountEmail(String serviceAccountEmail) {
        this.serviceAccountEmail = serviceAccountEmail;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
        if (url.equals(ComputeEngineCredentials.getTokenServerEncodedUrl())) {
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    if (MockMetadataServerTransport.this.tokenRequestStatusCode != null) {
                        return new MockLowLevelHttpResponse().setStatusCode(MockMetadataServerTransport.this.tokenRequestStatusCode.intValue()).setContent("Token Fetch Error");
                    }
                    String metadataRequestHeader = this.getFirstHeaderValue("Metadata-Flavor");
                    if (!"Google".equals(metadataRequestHeader)) {
                        throw new IOException("Metadata request header not found.");
                    }
                    GenericJson refreshContents = new GenericJson();
                    refreshContents.setFactory(OAuth2Utils.JSON_FACTORY);
                    refreshContents.put("access_token", (Object)MockMetadataServerTransport.this.accessToken);
                    refreshContents.put("expires_in", (Object)3600000);
                    refreshContents.put("token_type", (Object)"Bearer");
                    String refreshText = refreshContents.toPrettyString();
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(refreshText);
                }
            };
        }
        if (url.equals(ComputeEngineCredentials.getMetadataServerUrl())) {
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() {
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    response.addHeader("Metadata-Flavor", "Google");
                    return response;
                }
            };
        }
        if (this.isGetServiceAccountsUrl(url)) {
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    GenericJson serviceAccountsContents = new GenericJson();
                    serviceAccountsContents.setFactory(OAuth2Utils.JSON_FACTORY);
                    GenericJson defaultAccount = new GenericJson();
                    defaultAccount.put("email", (Object)MockMetadataServerTransport.this.serviceAccountEmail);
                    serviceAccountsContents.put("default", (Object)defaultAccount);
                    String serviceAccounts = serviceAccountsContents.toPrettyString();
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(serviceAccounts);
                }
            };
        }
        if (this.isSignRequestUrl(url)) {
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    GenericJson signContents = new GenericJson();
                    signContents.setFactory(OAuth2Utils.JSON_FACTORY);
                    signContents.put("signedBlob", (Object)BaseEncoding.base64().encode(MockMetadataServerTransport.this.signature));
                    String signature = signContents.toPrettyString();
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(signature);
                }
            };
        }
        if (this.isIdentityDocumentUrl(url)) {
            String[] pairs;
            if (this.idToken != null) {
                return new MockLowLevelHttpRequest(url){

                    public LowLevelHttpResponse execute() throws IOException {
                        return new MockLowLevelHttpResponse().setContent(MockMetadataServerTransport.this.idToken);
                    }
                };
            }
            HashMap<String, String> queryPairs = new HashMap<String, String>();
            String query = new URL(url).getQuery();
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            if (queryPairs.containsKey("format") && ((String)queryPairs.get("format")).equals("full")) {
                if (queryPairs.containsKey("license") && ((String)queryPairs.get("license")).equals("TRUE")) {
                    return new MockLowLevelHttpRequest(url){

                        public LowLevelHttpResponse execute() throws IOException {
                            return new MockLowLevelHttpResponse().setContent("eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.ew0KICAiYXVkIjogImh0dHBzOi8vZm9vLmJhciIsDQogICJhenAiOiAiMTEyMTc5MDYyNzIwMzkxMzA1ODg1IiwNCiAgImVtYWlsIjogIjEyMzQ1Ni1jb21wdXRlQGRldmVsb3Blci5nc2VydmljZWFjY291bnQuY29tIiwNCiAgImVtYWlsX3ZlcmlmaWVkIjogdHJ1ZSwNCiAgImV4cCI6IDE1NjQ1MTk0OTYsDQogICJnb29nbGUiOiB7DQogICAgImNvbXB1dGVfZW5naW5lIjogew0KICAgICAgImluc3RhbmNlX2NyZWF0aW9uX3RpbWVzdGFtcCI6IDE1NjMyMzA5MDcsDQogICAgICAiaW5zdGFuY2VfaWQiOiAiMzQ5Nzk3NDM5MzQ0MTE3OTI0MyIsDQogICAgICAiaW5zdGFuY2VfbmFtZSI6ICJpYW0iLA0KICAgICAgInByb2plY3RfaWQiOiAiZm9vLWJhci04MjAiLA0KICAgICAgInByb2plY3RfbnVtYmVyIjogMTA3MTI4NDE4NDQzNiwNCiAgICAgICJ6b25lIjogInVzLWNlbnRyYWwxLWEiDQogICAgfSwNCiAgICAibGljZW5zZSI6IFsNCiAgICAgICAiTElDRU5TRV8xIiwNCiAgICAgICAiTElDRU5TRV8yIg0KICAgIF0NCiAgfSwNCiAgImlhdCI6IDE1NjQ1MTU4OTYsDQogICJpc3MiOiAiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwNCiAgInN1YiI6ICIxMTIxNzkwNjI3MjAzOTEzMDU4ODUiDQp9.redacted");
                        }
                    };
                }
                return new MockLowLevelHttpRequest(url){

                    public LowLevelHttpResponse execute() throws IOException {
                        return new MockLowLevelHttpResponse().setContent("eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMTIxNzkwNjI3MjAzOTEzMDU4ODUiLCJlbWFpbCI6IjEwNzEyODQxODQ0MzYtY29tcHV0ZUBkZXZlbG9wZXIuZ3NlcnZpY2VhY2NvdW50LmNvbSIsImVtYWlsX3ZlcmlmaWVkIjp0cnVlLCJleHAiOjE1NjQ1MTk0OTYsImdvb2dsZSI6eyJjb21wdXRlX2VuZ2luZSI6eyJpbnN0YW5jZV9jcmVhdGlvbl90aW1lc3RhbXAiOjE1NjMyMzA5MDcsImluc3RhbmNlX2lkIjoiMzQ5Nzk3NDM5MzQ0MTE3OTI0MyIsImluc3RhbmNlX25hbWUiOiJpYW0iLCJwcm9qZWN0X2lkIjoibWluZXJhbC1taW51dGlhLTgyMCIsInByb2plY3RfbnVtYmVyIjoxMDcxMjg0MTg0NDM2LCJ6b25lIjoidXMtY2VudHJhbDEtYSJ9fSwiaWF0IjoxNTY0NTE1ODk2LCJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJzdWIiOiIxMTIxNzkwNjI3MjAzOTEzMDU4ODUifQ.redacted");
                    }
                };
            }
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    return new MockLowLevelHttpResponse().setContent("eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMDIxMDE1NTA4MzQyMDA3MDg1NjgiLCJleHAiOjE1NjQ0NzUwNTEsImlhdCI6MTU2NDQ3MTQ1MSwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwic3ViIjoiMTAyMTAxNTUwODM0MjAwNzA4NTY4In0.redacted");
                }
            };
        }
        return super.buildRequest(method, url);
    }

    protected boolean isGetServiceAccountsUrl(String url) {
        return url.equals(ComputeEngineCredentials.getServiceAccountsUrl());
    }

    protected boolean isSignRequestUrl(String url) {
        return this.serviceAccountEmail != null && url.equals(String.format("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:signBlob", this.serviceAccountEmail));
    }

    protected boolean isIdentityDocumentUrl(String url) {
        return url.startsWith(String.format(ComputeEngineCredentials.getIdentityDocumentUrl(), new Object[0]));
    }
}

