/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.util.Clock;
import com.google.auth.RequestMetadataCallback;
import com.google.auth.TestClock;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.MockExecutor;
import com.google.auth.oauth2.MockRequestMetadataCallback;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Executor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OAuth2CredentialsTest
extends BaseSerializationTest {
    private static final String CLIENT_SECRET = "jakuaL9YyieakhECKL2SwZcu";
    private static final String CLIENT_ID = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
    private static final String REFRESH_TOKEN = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
    private static final String ACCESS_TOKEN = "aashpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
    private static final URI CALL_URI = URI.create("http://googleapis.com/testapi/v1/foo");

    @Test
    public void constructor_storesAccessToken() {
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken(ACCESS_TOKEN, null)).build();
        Assert.assertEquals((Object)credentials.getAccessToken().getTokenValue(), (Object)ACCESS_TOKEN);
    }

    @Test
    public void getAuthenticationType_returnsOAuth2() {
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        Assert.assertEquals((Object)credentials.getAuthenticationType(), (Object)"OAuth2");
    }

    @Test
    public void hasRequestMetadata_returnsTrue() {
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        Assert.assertTrue((boolean)credentials.hasRequestMetadata());
    }

    @Test
    public void hasRequestMetadataOnly_returnsTrue() {
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        Assert.assertTrue((boolean)credentials.hasRequestMetadata());
    }

    @Test
    public void addChangeListener_notifiesOnRefresh() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        userCredentials.clock = new TestClock();
        TestChangeListener listener = new TestChangeListener();
        userCredentials.addChangeListener((OAuth2Credentials.CredentialsChangedListener)listener);
        Assert.assertEquals((long)0L, (long)listener.callCount);
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((Object)"1/MkSJoj1xsli0AccessToken_NKPY2", (Object)listener.accessToken.getTokenValue());
        Assert.assertEquals((long)1L, (long)listener.callCount);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        userCredentials.refresh();
        metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((Object)"2/MkSJoj1xsli0AccessToken_NKPY2", (Object)listener.accessToken.getTokenValue());
        Assert.assertEquals((long)2L, (long)listener.callCount);
    }

    @Test
    public void removeChangeListener_unregisters_observer() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        userCredentials.clock = new TestClock();
        TestChangeListener listener = new TestChangeListener();
        userCredentials.addChangeListener((OAuth2Credentials.CredentialsChangedListener)listener);
        Assert.assertEquals((long)0L, (long)listener.callCount);
        userCredentials.getRequestMetadata(CALL_URI);
        Assert.assertEquals((long)1L, (long)listener.callCount);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        userCredentials.refresh();
        Assert.assertEquals((long)2L, (long)listener.callCount);
        userCredentials.removeChangeListener((OAuth2Credentials.CredentialsChangedListener)listener);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        userCredentials.refresh();
        Assert.assertEquals((long)2L, (long)listener.callCount);
    }

    @Test
    public void getRequestMetadata_blocking_cachesExpiringToken() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        TestClock clock = new TestClock();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        credentials.clock = clock;
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        IOException error = new IOException("error");
        transportFactory.transport.setError(error);
        clock.addToCurrentTime(300000L);
        metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        clock.addToCurrentTime(3600000L);
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        try {
            credentials.getRequestMetadata(CALL_URI);
            Assert.fail((String)"Should throw");
        }
        catch (IOException e) {
            Assert.assertSame((Object)error, (Object)e);
            Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        }
        transportFactory.transport.setError(null);
        metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
    }

    @Test
    public void getRequestMetadata_async() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        TestClock clock = new TestClock();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        credentials.clock = clock;
        MockExecutor executor = new MockExecutor();
        MockRequestMetadataCallback callback = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertNull(callback.metadata);
        Assert.assertEquals((long)1L, (long)executor.runTasksExhaustively());
        Assert.assertNotNull(callback.metadata);
        TestUtils.assertContainsBearerToken(callback.metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        IOException error = new IOException("error");
        transportFactory.transport.setError(error);
        callback.reset();
        clock.addToCurrentTime(300000L);
        Assert.assertNull(callback.metadata);
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertNotNull(callback.metadata);
        Assert.assertEquals((long)0L, (long)executor.numTasks());
        TestUtils.assertContainsBearerToken(callback.metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        callback.reset();
        clock.addToCurrentTime(3600000L);
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertNull((Object)callback.exception);
        Assert.assertEquals((long)1L, (long)executor.runTasksExhaustively());
        Assert.assertSame((Object)error, (Object)callback.exception);
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        transportFactory.transport.setError(null);
        callback.reset();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertNull(callback.metadata);
        Assert.assertEquals((long)1L, (long)executor.runTasksExhaustively());
        Assert.assertNotNull(callback.metadata);
        TestUtils.assertContainsBearerToken(callback.metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
    }

    @Test
    public void getRequestMetadata_async_refreshRace() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        TestClock clock = new TestClock();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        credentials.clock = clock;
        MockExecutor executor = new MockExecutor();
        MockRequestMetadataCallback callback = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertNull(callback.metadata);
        Assert.assertEquals((long)1L, (long)executor.numTasks());
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)executor.runTasksExhaustively());
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertEquals((Object)metadata, callback.metadata);
    }

    @Test
    public void getRequestMetadata_temporaryToken_hasToken() throws IOException {
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken(ACCESS_TOKEN, null)).build();
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void refresh_refreshesToken() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        userCredentials.clock = new TestClock();
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        userCredentials.refresh();
        metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
    }

    @Test
    public void refreshIfExpired_refreshesToken() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        TestClock mockClock = new TestClock();
        userCredentials.clock = mockClock;
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        userCredentials.refreshIfExpired();
        metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertNotContainsBearerToken(metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        mockClock.addToCurrentTime(3600000L);
        userCredentials.refreshIfExpired();
        metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
    }

    @Test(expected=IllegalStateException.class)
    public void refresh_temporaryToken_throws() throws IOException {
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken(ACCESS_TOKEN, null)).build();
        credentials.refresh();
    }

    @Test
    public void equals_true() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        OAuth2Credentials otherCredentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        Assert.assertTrue((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertTrue((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_accessToken() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        OAuth2Credentials otherCredentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("2/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void toString_containsFields() throws IOException {
        AccessToken accessToken = new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null);
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(accessToken).build();
        String expectedToString = String.format("OAuth2Credentials{requestMetadata=%s, temporaryAccess=%s}", ImmutableMap.of((Object)"Authorization", (Object)ImmutableList.of((Object)("Bearer " + accessToken.getTokenValue()))), accessToken.toString());
        Assert.assertEquals((Object)expectedToString, (Object)credentials.toString());
    }

    @Test
    public void hashCode_equals() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        OAuth2Credentials otherCredentials = OAuth2Credentials.create((AccessToken)new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null));
        Assert.assertEquals((long)credentials.hashCode(), (long)otherCredentials.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        OAuth2Credentials deserializedCredentials = this.serializeAndDeserialize(credentials);
        Assert.assertEquals((Object)credentials, (Object)deserializedCredentials);
        Assert.assertEquals((long)credentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)credentials.toString(), (Object)deserializedCredentials.toString());
        Assert.assertSame((Object)deserializedCredentials.clock, (Object)Clock.SYSTEM);
    }

    private static class TestChangeListener
    implements OAuth2Credentials.CredentialsChangedListener {
        public AccessToken accessToken = null;
        public int callCount = 0;

        private TestChangeListener() {
        }

        public void onChanged(OAuth2Credentials credentials) throws IOException {
            this.accessToken = credentials.getAccessToken();
            ++this.callCount;
        }
    }
}

